/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.jena;

import com.franz.agraph.jena.AGGraph;
import com.franz.agraph.jena.AGReasoner;
import com.franz.agraph.repository.AGAbstractRepository;
import com.franz.agraph.repository.AGVirtualRepository;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.reasoner.Derivation;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ValidityReport;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.Iterator;
import org.openrdf.model.Resource;
import org.openrdf.query.Dataset;
import org.openrdf.query.impl.DatasetImpl;
import org.openrdf.repository.RepositoryException;

public class AGInfGraph
extends AGGraph
implements InfGraph {
    private final AGReasoner reasoner;
    private final AGGraph rawGraph;
    AGVirtualRepository infRepo;

    AGInfGraph(AGReasoner reasoner, AGGraph rawGraph) {
        super(rawGraph.getGraphMaker(), rawGraph.getGraphContext(), new Resource[0]);
        this.reasoner = reasoner;
        this.rawGraph = rawGraph;
        this.entailmentRegime = reasoner.getEntailmentRegime();
        if (rawGraph.getGraphContexts().length > 0) {
            AGAbstractRepository repo = rawGraph.getConnection().getRepository();
            String infSpec = AGVirtualRepository.reasoningSpec(AGVirtualRepository.filteredSpec(repo, rawGraph.getGraphContexts()), this.entailmentRegime);
            this.infRepo = repo.getCatalog().getServer().virtualRepository(infSpec);
            try {
                this.conn = this.infRepo.getConnection();
            }
            catch (RepositoryException e2) {
                throw new RuntimeException(e2);
            }
            this.vf = this.conn.getValueFactory();
        } else {
            this.infRepo = null;
        }
    }

    @Override
    public void close() {
        if (this.infRepo != null) {
            try {
                this.conn.close();
                this.infRepo.close();
            }
            catch (RepositoryException e2) {
                throw new RuntimeException(e2);
            }
        }
        super.close();
    }

    @Override
    Dataset getDataset() {
        DatasetImpl dataset = new DatasetImpl();
        return dataset;
    }

    @Override
    public ExtendedIterator<Triple> find(Node subject, Node property, Node object, Graph param) {
        throw new UnsupportedOperationException("This method is not currently supported.");
    }

    @Override
    public Graph getDeductionsGraph() {
        throw new UnsupportedOperationException("This method is not currently supported.");
    }

    @Override
    public Iterator<Derivation> getDerivation(Triple triple) {
        throw new UnsupportedOperationException("This method is not currently supported.");
    }

    @Override
    public Node getGlobalProperty(Node property) {
        throw new UnsupportedOperationException("This method is not currently supported.");
    }

    @Override
    public AGGraph getRawGraph() {
        return this.rawGraph;
    }

    @Override
    public Reasoner getReasoner() {
        return this.reasoner;
    }

    @Override
    public void prepare() {
    }

    @Override
    public void rebind() {
    }

    @Override
    public void rebind(Graph data) {
    }

    @Override
    public void reset() {
    }

    @Override
    public void setDerivationLogging(boolean logOn) {
        throw new UnsupportedOperationException("This method is not currently supported.");
    }

    @Override
    public boolean testGlobalProperty(Node property) {
        throw new UnsupportedOperationException("This method is not currently supported.");
    }

    @Override
    public ValidityReport validate() {
        throw new UnsupportedOperationException("This method is not currently supported.");
    }
}

