/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.jena;

import com.franz.agraph.http.exception.AGHttpException;
import com.franz.agraph.jena.AGBulkUpdateHandler;
import com.franz.agraph.jena.AGCapabilities;
import com.franz.agraph.jena.AGGraphMaker;
import com.franz.agraph.jena.AGPrefixMapping;
import com.franz.agraph.jena.AGReifier;
import com.franz.agraph.jena.AGTransactionHandler;
import com.franz.agraph.jena.AGTripleIterator;
import com.franz.agraph.repository.AGBooleanQuery;
import com.franz.agraph.repository.AGRepositoryConnection;
import com.franz.agraph.repository.AGValueFactory;
import com.franz.util.Closeable;
import com.hp.hpl.jena.graph.BulkUpdateHandler;
import com.hp.hpl.jena.graph.Capabilities;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphUtil;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Reifier;
import com.hp.hpl.jena.graph.TransactionHandler;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.impl.GraphBase;
import com.hp.hpl.jena.graph.impl.ReifierFragmentHandler;
import com.hp.hpl.jena.graph.impl.ReifierFragmentsMap;
import com.hp.hpl.jena.graph.impl.ReifierTripleMap;
import com.hp.hpl.jena.graph.impl.SimpleReifier;
import com.hp.hpl.jena.shared.AddDeniedException;
import com.hp.hpl.jena.shared.DeleteDeniedException;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.NullIterator;
import java.util.ArrayList;
import org.openrdf.http.protocol.UnauthorizedException;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.query.Dataset;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.impl.DatasetImpl;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.helpers.StatementCollector;

public class AGGraph
extends GraphBase
implements Graph,
Closeable {
    protected final AGGraphMaker maker;
    protected final Node graphNode;
    protected AGRepositoryConnection conn;
    protected AGValueFactory vf;
    protected final Resource context;
    protected final Resource[] contexts;
    protected String entailmentRegime = "false";

    AGGraph(AGGraphMaker maker, Node graphNode) {
        super(maker.getReificationStyle());
        this.maker = maker;
        this.graphNode = graphNode;
        this.conn = maker.getRepositoryConnection();
        this.vf = this.conn.getValueFactory();
        this.context = this.vf.asResource(graphNode);
        this.contexts = new Resource[]{this.context};
    }

    AGGraph(AGGraphMaker maker, Resource context, Resource ... contexts) {
        super(maker.getReificationStyle());
        this.maker = maker;
        this.graphNode = null;
        this.conn = maker.getRepositoryConnection();
        this.vf = this.conn.getValueFactory();
        this.context = context;
        this.contexts = contexts;
    }

    AGGraphMaker getGraphMaker() {
        return this.maker;
    }

    Node getGraphNode() {
        return this.graphNode;
    }

    public String getName() {
        if (this.graphNode == null) {
            return "default-graph";
        }
        return this.graphNode.toString();
    }

    Resource getGraphContext() {
        return this.context;
    }

    Resource[] getGraphContexts() {
        return this.contexts;
    }

    AGRepositoryConnection getConnection() {
        return this.conn;
    }

    String getEntailmentRegime() {
        return this.entailmentRegime;
    }

    @Override
    public BulkUpdateHandler getBulkUpdateHandler() {
        return new AGBulkUpdateHandler(this);
    }

    @Override
    public Capabilities getCapabilities() {
        if (this.capabilities == null) {
            this.capabilities = new AGCapabilities();
        }
        return this.capabilities;
    }

    @Override
    public PrefixMapping getPrefixMapping() {
        return new AGPrefixMapping(this);
    }

    @Override
    public TransactionHandler getTransactionHandler() {
        return new AGTransactionHandler(this);
    }

    @Override
    public String toString() {
        return AGGraph.toString(this.getName() + (this.closed ? " (closed) " : " (size: " + this.graphBaseSize() + ")."), this);
    }

    public static String toString(String prefix, Graph that) {
        StringBuffer b = new StringBuffer(prefix + " {");
        String gap = "";
        ExtendedIterator<Triple> it = GraphUtil.findAll(that);
        int count = 0;
        while (it.hasNext() && count < 20) {
            b.append(gap);
            gap = "; ";
            b.append(((Triple)it.next()).toString());
        }
        b.append("}");
        return b.toString();
    }

    Dataset getDataset() {
        DatasetImpl dataset = new DatasetImpl();
        for (Resource c : this.contexts) {
            if (c == null) {
                dataset.addDefaultGraph(null);
                continue;
            }
            if (!(c instanceof URI)) continue;
            dataset.addDefaultGraph((URI)c);
            dataset.addNamedGraph((URI)c);
        }
        return dataset;
    }

    @Override
    protected ExtendedIterator<Triple> graphBaseFind(TripleMatch m) {
        RepositoryResult<Statement> result;
        try {
            Node s = m.getMatchSubject();
            Node p = m.getMatchPredicate();
            if (s != null && s.isLiteral() || p != null && (p.isLiteral() || p.isBlank())) {
                result = this.conn.createRepositoryResult(new ArrayList());
            } else {
                StatementCollector collector = new StatementCollector();
                this.conn.getHttpRepoClient().getStatements(this.vf.asResource(s), this.vf.asURI(p), this.vf.asValue(m.getMatchObject()), this.entailmentRegime, collector, this.contexts);
                result = this.conn.createRepositoryResult(collector.getStatements());
            }
        }
        catch (AGHttpException e2) {
            throw new RuntimeException(e2);
        }
        catch (RDFHandlerException e3) {
            throw new RuntimeException(e3);
        }
        return new AGTripleIterator(this, result);
    }

    @Override
    public void performAdd(Triple t) {
        try {
            AGRepositoryConnection conn = this.maker.getRepositoryConnection();
            AGValueFactory vf = conn.getValueFactory();
            conn.add(vf.asResource(t.getSubject()), vf.asURI(t.getPredicate()), vf.asValue(t.getObject()), this.context);
        }
        catch (UnauthorizedException e2) {
            throw new AddDeniedException(e2.getMessage());
        }
        catch (RepositoryException e3) {
            throw new RuntimeException(e3);
        }
    }

    @Override
    public void performDelete(Triple t) {
        try {
            this.conn.remove(this.vf.asResource(t.getSubject()), this.vf.asURI(t.getPredicate()), this.vf.asValue(t.getObject()), this.contexts);
        }
        catch (UnauthorizedException e2) {
            throw new DeleteDeniedException(e2.getMessage());
        }
        catch (RepositoryException e3) {
            throw new RuntimeException(e3);
        }
    }

    @Override
    protected int graphBaseSize() {
        int size;
        try {
            size = (int)this.conn.size(this.contexts);
        }
        catch (RepositoryException e2) {
            throw new RuntimeException(e2);
        }
        return size;
    }

    @Override
    public boolean isEmpty() {
        String queryString = "ask {?s ?p ?o}";
        AGBooleanQuery bq = this.conn.prepareBooleanQuery(QueryLanguage.SPARQL, queryString);
        bq.setDataset(this.getDataset());
        try {
            return !bq.evaluate();
        }
        catch (QueryEvaluationException e2) {
            throw new RuntimeException(e2);
        }
    }

    @Override
    protected Reifier constructReifier() {
        if (!this.style.intercepts() && !this.style.conceals()) {
            return new SimpleReifier(this, new EmptyReifierTripleMap(), new EmptyReifierFragmentsMap(), this.style);
        }
        if (this.style == ReificationStyle.Standard) {
            return new AGReifier(this);
        }
        return new SimpleReifier(this, this.style);
    }

    class EmptyReifierFragmentsMap
    implements ReifierFragmentsMap {
        EmptyReifierFragmentsMap() {
        }

        @Override
        public ExtendedIterator<Triple> find(TripleMatch m) {
            return NullIterator.instance();
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public ReifierFragmentHandler getFragmentHandler(Triple fragment) {
            return null;
        }

        @Override
        public boolean hasFragments(Node tag) {
            return false;
        }

        @Override
        public void clear() {
        }
    }

    class EmptyReifierTripleMap
    implements ReifierTripleMap {
        EmptyReifierTripleMap() {
        }

        @Override
        public Triple getTriple(Node tag) {
            return null;
        }

        @Override
        public boolean hasTriple(Triple t) {
            return false;
        }

        @Override
        public Triple putTriple(Node key, Triple value) {
            return null;
        }

        @Override
        public void removeTriple(Node key) {
        }

        @Override
        public void removeTriple(Node key, Triple value) {
        }

        @Override
        public void removeTriple(Triple triple) {
        }

        @Override
        public ExtendedIterator<Triple> find(TripleMatch m) {
            return NullIterator.instance();
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public ExtendedIterator<Node> tagIterator() {
            return NullIterator.instance();
        }

        @Override
        public ExtendedIterator<Node> tagIterator(Triple t) {
            return NullIterator.instance();
        }

        @Override
        public void clear() {
        }
    }
}

