/*
 * Decompiled with CFR 0.152.
 */
package webshell.app.security;

import io.jsonwebtoken.Jwts;
import java.security.Key;
import java.security.Principal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import webshell.app.Application;

@RestController
@CrossOrigin(allowCredentials="true")
@RequestMapping(value={"/api"})
public class JwtTokenController {
    @PostMapping(value={"/token"})
    public Map<String, String> generateToken(Principal principal) {
        HashMap<String, String> map = new HashMap<String, String>();
        String token = Jwts.builder().setSubject(principal.getName()).signWith((Key)Application.SECRET_KEY).compact();
        map.put("token", token);
        map.put("posix", String.valueOf(!System.getProperty("os.name").toLowerCase().contains("windows")));
        return map;
    }

    @PostMapping(value={"/auth"})
    public void checkToken() {
    }

    @GetMapping(value={"/token/temp"})
    public Map<String, String> generateTempToken(Principal principal) {
        HashMap<String, String> map = new HashMap<String, String>();
        String token = Jwts.builder().setSubject(principal.getName()).setExpiration(new Date(System.currentTimeMillis() + 60000L)).signWith((Key)Application.SECRET_KEY).compact();
        map.put("token", token);
        return map;
    }
}

