/*
 * Decompiled with CFR 0.152.
 */
package webshell.app.security;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.Jwts;
import java.io.IOException;
import java.security.Key;
import java.util.Collections;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import webshell.app.Application;

public class JwtAuthorizationFilter
extends BasicAuthenticationFilter {
    public JwtAuthorizationFilter(AuthenticationManager authenticationManager) {
        super(authenticationManager);
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        UsernamePasswordAuthenticationToken authentication = this.getAuthentication(request);
        if (authentication == null) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private UsernamePasswordAuthenticationToken getAuthentication(HttpServletRequest request) {
        String token = request.getHeader("Authorization");
        if (token != null && token.length() > 0 && token.startsWith("Bearer")) {
            try {
                Jws parsedToken = Jwts.parser().setSigningKey((Key)Application.SECRET_KEY).parseClaimsJws(token.replace("Bearer ", ""));
                String username = ((Claims)parsedToken.getBody()).getSubject();
                if (username != null && username.length() > 0) {
                    return new UsernamePasswordAuthenticationToken((Object)System.getProperty("app.default-user"), null, Collections.emptyList());
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return null;
    }
}

