/*
 * Decompiled with CFR 0.152.
 */
package webshell.app.files;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;
import webshell.app.files.PosixPermission;
import webshell.app.files.copy.FileCopyProgressResponse;
import webshell.app.files.copy.FileCopyTask;

@Component
public class FileOperations {
    private final Map<String, FileCopyTask> pendingOperations = new ConcurrentHashMap();
    private final ExecutorService threadPool = Executors.newFixedThreadPool(5);

    public void setPosixPermission(String file, PosixPermission perm) throws Exception {
        Set<PosixFilePermission> permissions = Files.getPosixFilePermissions(Paths.get(file, new String[0]), new LinkOption[0]);
        if (perm.isExecutable()) {
            permissions.add(PosixFilePermission.OWNER_EXECUTE);
        } else {
            permissions.remove((Object)PosixFilePermission.OWNER_EXECUTE);
        }
        if ("READ_WRITE".equals(perm.getOwnerAccess())) {
            permissions.add(PosixFilePermission.OWNER_READ);
            permissions.add(PosixFilePermission.OWNER_WRITE);
        } else if ("READ_ONLY".equals(perm.getOwnerAccess())) {
            permissions.add(PosixFilePermission.OWNER_READ);
            permissions.remove((Object)PosixFilePermission.OWNER_WRITE);
        } else if ("WRITE_ONLY".equals(perm.getOwnerAccess())) {
            permissions.remove((Object)PosixFilePermission.OWNER_READ);
            permissions.add(PosixFilePermission.OWNER_WRITE);
        } else {
            permissions.remove((Object)PosixFilePermission.OWNER_READ);
            permissions.remove((Object)PosixFilePermission.OWNER_WRITE);
        }
        if ("READ_WRITE".equals(perm.getGroupAccess())) {
            permissions.add(PosixFilePermission.GROUP_READ);
            permissions.add(PosixFilePermission.GROUP_WRITE);
        } else if ("READ_ONLY".equals(perm.getGroupAccess())) {
            permissions.add(PosixFilePermission.GROUP_READ);
            permissions.remove((Object)PosixFilePermission.GROUP_WRITE);
        } else if ("WRITE_ONLY".equals(perm.getGroupAccess())) {
            permissions.remove((Object)PosixFilePermission.GROUP_READ);
            permissions.add(PosixFilePermission.GROUP_WRITE);
        } else {
            permissions.remove((Object)PosixFilePermission.GROUP_READ);
            permissions.remove((Object)PosixFilePermission.GROUP_WRITE);
            permissions.remove((Object)PosixFilePermission.GROUP_EXECUTE);
        }
        if ("READ_WRITE".equals(perm.getOtherAccess())) {
            permissions.add(PosixFilePermission.OTHERS_READ);
            permissions.add(PosixFilePermission.OTHERS_WRITE);
        } else if ("READ_ONLY".equals(perm.getOtherAccess())) {
            permissions.add(PosixFilePermission.OTHERS_READ);
            permissions.remove((Object)PosixFilePermission.OTHERS_WRITE);
        } else if ("WRITE_ONLY".equals(perm.getOtherAccess())) {
            permissions.remove((Object)PosixFilePermission.OTHERS_READ);
            permissions.add(PosixFilePermission.OTHERS_WRITE);
        } else {
            permissions.remove((Object)PosixFilePermission.OTHERS_READ);
            permissions.remove((Object)PosixFilePermission.OTHERS_WRITE);
            permissions.remove((Object)PosixFilePermission.OTHERS_EXECUTE);
        }
        Files.setPosixFilePermissions(Paths.get(file, new String[0]), permissions);
    }

    public PosixPermission getPosixPermission(String file) throws Exception {
        Path path = Paths.get(file, new String[0]);
        PosixFileAttributeView view = Files.getFileAttributeView(path, PosixFileAttributeView.class, new LinkOption[0]);
        PosixFileAttributes attrs = view.readAttributes();
        PosixPermission perm = new PosixPermission();
        perm.setOwner(attrs.owner().getName());
        perm.setGroup(attrs.group().getName());
        Set<PosixFilePermission> permissions = attrs.permissions();
        perm.setExecutable(permissions.contains((Object)PosixFilePermission.OWNER_EXECUTE));
        String ownerPerm = "NONE";
        if (permissions.contains((Object)PosixFilePermission.OWNER_READ) && permissions.contains((Object)PosixFilePermission.OWNER_WRITE)) {
            ownerPerm = "READ_WRITE";
        } else if (permissions.contains((Object)PosixFilePermission.OWNER_READ)) {
            ownerPerm = "READ_ONLY";
        } else if (permissions.contains((Object)PosixFilePermission.OWNER_WRITE)) {
            ownerPerm = "WRITE_ONLY";
        }
        perm.setOwnerAccess(ownerPerm);
        String groupPerm = "NONE";
        if (permissions.contains((Object)PosixFilePermission.GROUP_READ) && permissions.contains((Object)PosixFilePermission.GROUP_WRITE)) {
            groupPerm = "READ_WRITE";
        } else if (permissions.contains((Object)PosixFilePermission.GROUP_READ)) {
            groupPerm = "READ_ONLY";
        } else if (permissions.contains((Object)PosixFilePermission.GROUP_WRITE)) {
            groupPerm = "WRITE_ONLY";
        }
        perm.setGroupAccess(groupPerm);
        String otherPerm = "NONE";
        if (permissions.contains((Object)PosixFilePermission.OTHERS_READ) && permissions.contains((Object)PosixFilePermission.OTHERS_WRITE)) {
            otherPerm = "READ_WRITE";
        } else if (permissions.contains((Object)PosixFilePermission.OTHERS_READ)) {
            otherPerm = "READ_ONLY";
        } else if (permissions.contains((Object)PosixFilePermission.OTHERS_WRITE)) {
            otherPerm = "WRITE_ONLY";
        }
        perm.setOtherAccess(otherPerm);
        return perm;
    }

    public void rename(String oldName, String newName, String folder) throws IOException {
        Files.move(Paths.get(folder, oldName), Paths.get(folder, newName), new CopyOption[0]);
    }

    public void deleteFiles(List<String> files) throws IOException {
        for (String file : files) {
            File[] children;
            System.out.println("Delete: " + file);
            File f = new File(file);
            if (f.isDirectory() && (children = f.listFiles()) != null) {
                this.deleteFiles(Arrays.asList(children).stream().map(a -> a.getAbsolutePath()).collect(Collectors.toList()));
            }
            if (f.delete()) continue;
            throw new IOException("Unable to delete: " + f.getAbsolutePath());
        }
    }

    public Map<String, FileCopyTask> getPendingOperations() {
        return this.pendingOperations;
    }

    public String createFileCopyTask(List<String> sourceFile, String destinationFolder, boolean move) {
        FileCopyTask cp = new FileCopyTask(sourceFile, destinationFolder, move);
        this.pendingOperations.put(cp.getId(), cp);
        this.threadPool.submit((Runnable)cp);
        return cp.getId();
    }

    public List<FileCopyProgressResponse> getProgress(List<String> idList) {
        ArrayList<FileCopyProgressResponse> list = new ArrayList<FileCopyProgressResponse>();
        for (String id : idList) {
            FileCopyTask cp = (FileCopyTask)this.pendingOperations.get(id);
            FileCopyProgressResponse r = new FileCopyProgressResponse(cp.getId(), cp.getName(), (int)cp.getProgress(), cp.getStatus(), String.join((CharSequence)"\n", cp.getErrorMessage()), cp.isHasErrors());
            list.add(r);
        }
        return list;
    }

    public String getOpName(String id) {
        return ((FileCopyTask)this.pendingOperations.get(id)).getName();
    }

    public void cancelTask(String id) {
        FileCopyTask cp = (FileCopyTask)this.pendingOperations.get(id);
        cp.cancel();
    }
}

