/*
 * Decompiled with CFR 0.152.
 */
package webshell.app.files;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.Jwts;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.Key;
import java.util.ArrayList;
import java.util.Base64;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import webshell.app.Application;
import webshell.app.files.FileTransfer;
import webshell.app.files.FileTypeDetector;

@RestController
@CrossOrigin(allowCredentials="true")
@RequestMapping(value={"/bin"})
public class BinaryDataController {
    @Autowired
    private FileTypeDetector typeDetector;

    private void validateToken(String token) throws Exception {
        Jws parsedToken = Jwts.parser().setSigningKey((Key)Application.SECRET_KEY).parseClaimsJws(token);
        String username = ((Claims)parsedToken.getBody()).getSubject();
        if (username != null && username.length() > 0 && username.equals(System.getProperty("app.default-user"))) {
            System.out.println("Token and user is valid");
            return;
        }
        throw new Exception("Invalid username: " + username);
    }

    @GetMapping(value={"/image/{encodedPath}"})
    public ResponseEntity<byte[]> getImage(@PathVariable String encodedPath, @RequestParam String token) throws Exception {
        this.validateToken(token);
        String path = new String(Base64.getDecoder().decode(encodedPath));
        byte[] b = Files.readAllBytes(Paths.get(path, new String[0]));
        HttpHeaders headers = new HttpHeaders();
        headers.add((Object)"Content-Type", (Object)this.getImageType(path));
        ResponseEntity resp = new ResponseEntity((Object)b, (MultiValueMap)headers, HttpStatus.OK);
        return resp;
    }

    @GetMapping(value={"/blob/{encodedPath}"})
    public void getBlob(@PathVariable String encodedPath, @RequestParam String token, HttpServletRequest request, HttpServletResponse resp) throws Exception {
        this.validateToken(token);
        String path = new String(Base64.getDecoder().decode(encodedPath));
        System.out.println("Get file: " + path);
        long fileSize = Files.size(Paths.get(path, new String[0]));
        String r = request.getHeader("Range");
        long upperBound = fileSize - 1L;
        long lowerBound = 0L;
        if (r != null) {
            System.out.println(r);
            String rstr = r.split("=")[1];
            String[] arr = rstr.split("-");
            lowerBound = Long.parseLong(arr[0]);
            if (arr.length > 1 && arr[1].length() > 0) {
                upperBound = Long.parseLong(arr[1]);
            }
        }
        System.out.println("lb: " + lowerBound + " ub: " + fileSize);
        if (r != null) {
            resp.setStatus(206);
        }
        resp.addHeader("Content-Length", String.valueOf(fileSize - lowerBound));
        resp.addHeader("Content-Range", "bytes " + lowerBound + "-" + upperBound + "/" + fileSize);
        resp.addHeader("Content-Type", this.typeDetector.getType(new File(path)));
        long rem = fileSize - lowerBound;
        Throwable throwable = null;
        Object var16_15 = null;
        try (FileInputStream in = new FileInputStream(path);){
            ((InputStream)in).skip(lowerBound);
            byte[] b = new byte[8192];
            while (rem > 0L) {
                int x = ((InputStream)in).read(b, 0, (int)(rem > (long)b.length ? (long)b.length : rem));
                if (x == -1) {
                    break;
                }
                resp.getOutputStream().write(b, 0, x);
                rem -= (long)x;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @GetMapping(value={"/download"})
    public void downloadFiles(@RequestParam(name="folder") String encodedFolder, @RequestParam(name="files", required=false) String encodedFiles, @RequestParam String token, HttpServletResponse response) throws Exception {
        String files;
        String[] arr1;
        this.validateToken(token);
        int fileCount = 0;
        String folder = new String(Base64.getDecoder().decode(encodedFolder), "utf-8");
        ArrayList<String> fileList = new ArrayList<String>();
        if (encodedFiles != null && (arr1 = (files = new String(Base64.getDecoder().decode(encodedFiles), "utf-8")).split("/")) != null && arr1.length > 0) {
            fileCount = arr1.length;
            String[] stringArray = arr1;
            int n = arr1.length;
            int n2 = 0;
            while (n2 < n) {
                String str = stringArray[n2];
                fileList.add(new File(folder, str).getAbsolutePath());
                ++n2;
            }
        }
        if (fileList.size() == 0) {
            throw new IOException();
        }
        String name = "download.zip";
        boolean compress = false;
        if (fileCount == 1) {
            File f = new File((String)fileList.get(0));
            name = f.getName();
            compress = f.isDirectory();
            if (name.length() < 1) {
                name = "files";
            }
        } else {
            compress = true;
        }
        response.addHeader("Content-Disposition", "attachment; filename=\"" + name + ".zip" + "\"");
        response.setContentType("application/octet-stream");
        FileTransfer fs = new FileTransfer(compress);
        fs.transferFiles(fileList, (OutputStream)response.getOutputStream());
    }

    private String getImageType(String path) {
        return this.typeDetector.getTypeByName(path);
    }
}

