/*
 * Decompiled with CFR 0.152.
 */
package webshell.app;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import webshell.app.AppContext;
import webshell.app.config.ConfigManager;
import webshell.app.files.FileOperations;
import webshell.app.files.FileService;
import webshell.app.files.FileTransfer;
import webshell.app.files.PosixPermission;
import webshell.app.files.copy.FileCopyProgressResponse;
import webshell.app.files.copy.FileCopyRequest;
import webshell.app.files.search.SearchResult;
import webshell.app.terminal.PtySession;

@RestController
@CrossOrigin(allowCredentials="true")
@RequestMapping(value={"/api"})
public class AppController {
    @Autowired
    private FileService service;
    @Autowired
    private FileOperations fs;
    @Autowired
    private BCryptPasswordEncoder passwordEncoder;

    @PostMapping(value={"/app/terminal/{appId}/resize"})
    public void resizePty(@PathVariable String appId, @RequestBody Map<String, Integer> body) {
        ((PtySession)AppContext.INSTANCES.get(appId)).resizePty(body.get("row").intValue(), body.get("col").intValue());
    }

    @PostMapping(value={"/app/terminal"})
    public Map<String, String> createTerminal() throws Exception {
        PtySession pty = new PtySession();
        AppContext.INSTANCES.put(pty.getId(), pty);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("id", pty.getId());
        return map;
    }

    @GetMapping(value={"/app/files/home"})
    public Map<String, Object> listHome() throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("files", this.service.list(System.getProperty("user.home")));
        map.put("folder", System.getProperty("user.home"));
        map.put("folderName", new File(System.getProperty("user.home")).getName());
        return map;
    }

    @GetMapping(value={"/app/files/list/{path}"})
    public Map<String, Object> list(@PathVariable String path) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String folder = null;
        folder = path == null ? System.getProperty("user.home") : new String(Base64.getDecoder().decode(path), "utf-8");
        System.out.println("base64: " + path + " " + folder);
        map.put("files", this.service.list(folder));
        map.put("folder", folder);
        map.put("folderName", new File(folder).getName());
        return map;
    }

    @GetMapping(value={"/app/files/up/{path}"})
    public Map<String, Object> up(@PathVariable String path) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        path = new String(Base64.getDecoder().decode(path), "utf-8");
        if (!path.equals("/")) {
            path = new File(path).getParent();
        }
        map.put("files", this.service.list(path));
        map.put("folder", path);
        map.put("folderName", new File(path).getName());
        return map;
    }

    @PostMapping(value={"/app/upload/{folder}/{relativePath}"})
    public void upload(@PathVariable String folder, @PathVariable String relativePath, HttpServletRequest request) throws Exception {
        System.out.println("uploading...");
        try {
            folder = new String(Base64.getDecoder().decode(folder), "utf-8");
            relativePath = new String(Base64.getDecoder().decode(relativePath), "utf-8");
            FileTransfer fs = new FileTransfer(false);
            fs.transferFile(relativePath, folder, (InputStream)request.getInputStream());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    @GetMapping(value={"/app/folder/tree/home"})
    public List<Map<String, ?>> listTreeHome() {
        ArrayList list = new ArrayList();
        File f = new File(System.getProperty("user.home"));
        File[] files = f.listFiles();
        if (files != null && files.length > 0) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    HashMap<String, Object> entry = new HashMap<String, Object>();
                    entry.put("name", file.getName());
                    entry.put("path", file.getAbsolutePath());
                    entry.put("leafNode", !file.isDirectory());
                    list.add(entry);
                }
                ++n2;
            }
        }
        return list;
    }

    @GetMapping(value={"/app/folder/tree/path/{encodedPath}"})
    public List<Map<String, ?>> listTreePath(@PathVariable String encodedPath) throws Exception {
        String path = new String(Base64.getDecoder().decode(encodedPath), "utf-8");
        ArrayList list = new ArrayList();
        File f = new File(path);
        File[] files = f.listFiles();
        if (files != null && files.length > 0) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    HashMap<String, Object> entry = new HashMap<String, Object>();
                    entry.put("name", file.getName());
                    entry.put("path", file.getAbsolutePath());
                    entry.put("leafNode", !file.isDirectory());
                    list.add(entry);
                }
                ++n2;
            }
        }
        return list;
    }

    @GetMapping(value={"/app/folder/tree/fs"})
    public List<Map<String, ?>> listFsRoots() throws Exception {
        ArrayList list = new ArrayList();
        File[] files = File.listRoots();
        if (files != null && files.length > 0) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                HashMap<String, Object> entry = new HashMap<String, Object>();
                System.out.println("Root: " + file.getName());
                entry.put("name", file.getAbsolutePath());
                entry.put("path", file.getAbsolutePath());
                entry.put("leafNode", !file.isDirectory());
                list.add(entry);
                ++n2;
            }
        }
        return list;
    }

    @PostMapping(value={"/app/fs/{mode}"})
    public Map<String, String> startCopyOrMove(@PathVariable String mode, @RequestBody FileCopyRequest request) {
        List sourceFile = request.getSourceFile();
        String targetFolder = request.getTargetFolder();
        HashMap<String, String> map = new HashMap<String, String>();
        String id = this.fs.createFileCopyTask(sourceFile, targetFolder, "move".equals(mode));
        map.put("id", id);
        map.put("name", this.fs.getOpName(id));
        return map;
    }

    @PostMapping(value={"/app/fs/progress"})
    public List<FileCopyProgressResponse> getProgress(@RequestBody List<String> idList) {
        return this.fs.getProgress(idList);
    }

    @PostMapping(value={"/app/fs/cancel/{id}"})
    public void cancel(@PathVariable String id) {
        this.fs.cancelTask(id);
    }

    @PostMapping(value={"/app/fs/rename"})
    public void rename(@RequestBody Map<String, String> body) throws IOException {
        this.fs.rename(body.get("oldName"), body.get("newName"), body.get("folder"));
    }

    @PostMapping(value={"/app/fs/delete"})
    public void delete(@RequestBody List<String> body) throws IOException {
        this.fs.deleteFiles(body);
    }

    @GetMapping(value={"/app/fs/files/{encodedPath}"})
    public String getText(@PathVariable String encodedPath) throws Exception {
        return this.service.getText(new String(Base64.getDecoder().decode(encodedPath)));
    }

    @PostMapping(value={"/app/fs/files/{encodedPath}"})
    public void setText(@PathVariable String encodedPath, @RequestBody String body) throws Exception {
        this.service.setText(new String(Base64.getDecoder().decode(encodedPath)), body);
    }

    @PostMapping(value={"/app/fs/search"})
    public Map<String, String> initSearch(@RequestBody Map<String, String> request) {
        String id = this.service.createSearch(request.get("folder"), request.get("searchText"));
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("id", id);
        return response;
    }

    @DeleteMapping(value={"/app/fs/search/{id}"})
    public void cancelSearch(@PathVariable String id) {
        this.service.cancelSearch(id);
    }

    @GetMapping(value={"/app/fs/search/{id}"})
    public SearchResult getSearchResult(@PathVariable String id, @RequestParam(defaultValue="0", required=false) int fileIndex, @RequestParam(defaultValue="0", required=false) int folderIndex) {
        return this.service.getSearchResult(id, fileIndex, folderIndex);
    }

    @GetMapping(value={"/app/fs/posix/{encodedPath}"})
    public PosixPermission getPosixPerm(@PathVariable String encodedPath) throws Exception {
        return this.fs.getPosixPermission(new String(Base64.getDecoder().decode(encodedPath), "utf-8"));
    }

    @PostMapping(value={"/app/fs/posix/{encodedPath}"})
    public void setPosixPerm(@PathVariable String encodedPath, @RequestBody PosixPermission perm) throws Exception {
        this.fs.setPosixPermission(new String(Base64.getDecoder().decode(encodedPath), "utf-8"), perm);
    }

    @GetMapping(value={"/app/config"})
    public Map<String, String> getConfig() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("app.default-user", System.getProperty("app.default-user"));
        map.put("app.default-pass", System.getProperty("app.default-pass"));
        map.put("app.default-shell", System.getProperty("app.default-shell"));
        return map;
    }

    @PostMapping(value={"/app/config"})
    public void setConfig(@RequestBody Map<String, String> map) throws IOException {
        for (String key : map.keySet()) {
            String val = map.get(key);
            if (val == null || val.length() <= 0) continue;
            if (key.equals("app.default-pass")) {
                System.setProperty(key, this.passwordEncoder.encode((CharSequence)val));
                continue;
            }
            System.setProperty(key, val);
        }
        ConfigManager.saveUserDetails();
    }

    @PostMapping(value={"/app/fs/mkdir"})
    public void mkdir(@RequestBody Map<String, String> map) throws Exception {
        String dir = map.get("dir");
        String name = map.get("name");
        Path path = Paths.get(dir, name);
        Files.createDirectories(path, new FileAttribute[0]);
    }

    @PostMapping(value={"/app/fs/touch"})
    public void touch(@RequestBody Map<String, String> map) throws Exception {
        String dir = map.get("dir");
        String name = map.get("name");
        Path path = Paths.get(dir, name);
        Files.createFile(path, new FileAttribute[0]);
    }
}

