/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.impl;

import java.sql.DatabaseMetaData;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.seasar.dao.BeanAnnotationReader;
import org.seasar.dao.ColumnNaming;
import org.seasar.dao.Dbms;
import org.seasar.dao.ValueTypeFactory;
import org.seasar.dao.impl.AbstractPropertyTypeFactory;
import org.seasar.extension.jdbc.PropertyType;
import org.seasar.extension.jdbc.util.DatabaseMetaDataUtil;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.exception.EmptyRuntimeException;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.StringUtil;

public class PropertyTypeFactoryImpl
extends AbstractPropertyTypeFactory {
    private static Logger logger = Logger.getLogger((Class)PropertyTypeFactoryImpl.class);
    private DatabaseMetaData databaseMetaData;

    public PropertyTypeFactoryImpl(Class beanClass, BeanAnnotationReader beanAnnotationReader, ValueTypeFactory valueTypeFactory, ColumnNaming columnNaming) {
        super(beanClass, beanAnnotationReader, valueTypeFactory, columnNaming);
    }

    public PropertyTypeFactoryImpl(Class beanClass, BeanAnnotationReader beanAnnotationReader, ValueTypeFactory valueTypeFactory, ColumnNaming columnNaming, Dbms dbms, DatabaseMetaData databaseMetaData) {
        super(beanClass, beanAnnotationReader, valueTypeFactory, columnNaming, dbms);
        this.databaseMetaData = databaseMetaData;
    }

    public PropertyType[] createBeanPropertyTypes(String tableName) {
        ArrayList<PropertyType> list = new ArrayList<PropertyType>();
        BeanDesc beanDesc = this.getBeanDesc();
        Set columns = this.getColumns(tableName);
        boolean found = false;
        for (int i = 0; i < beanDesc.getPropertyDescSize(); ++i) {
            PropertyDesc pd = beanDesc.getPropertyDesc(i);
            if (this.isRelation(pd)) continue;
            PropertyType pt = this.createPropertyType(pd);
            if (this.isPrimaryKey(pd)) {
                pt.setPrimaryKey(true);
                found = true;
            }
            this.setupColumnName(pt, columns);
            this.setupPersistent(pt, columns);
            list.add(pt);
        }
        PropertyType[] propertyTypes = list.toArray(new PropertyType[list.size()]);
        if (!found) {
            this.setupPrimaryKey(propertyTypes, tableName);
        }
        return propertyTypes;
    }

    protected Set getColumns(String tableName) {
        Set columnSet = DatabaseMetaDataUtil.getColumnMap((DatabaseMetaData)this.getDatabaseMetaData(), (String)tableName).keySet();
        if (columnSet.isEmpty()) {
            logger.log("WDAO0002", new Object[]{tableName});
        }
        return columnSet;
    }

    protected void setupColumnName(PropertyType propertyType, Set columns) {
        PropertyDesc pd = propertyType.getPropertyDesc();
        if (this.beanAnnotationReader.getColumnAnnotation(pd) != null) {
            return;
        }
        Iterator i = columns.iterator();
        while (i.hasNext()) {
            String columnName = (String)i.next();
            String columnName2 = StringUtil.replace((String)columnName, (String)"_", (String)"");
            if (!propertyType.getColumnName().equalsIgnoreCase(columnName2)) continue;
            propertyType.setColumnName(columnName);
            break;
        }
    }

    protected void setupPersistent(PropertyType propertyType, Set columns) {
        propertyType.setPersistent(this.isPersistent(propertyType));
        if (!columns.contains(propertyType.getColumnName())) {
            propertyType.setPersistent(false);
        }
    }

    protected void setupPrimaryKey(PropertyType[] propertyTypes, String tableName) {
        Set primaryKeySet = DatabaseMetaDataUtil.getPrimaryKeySet((DatabaseMetaData)this.getDatabaseMetaData(), (String)tableName);
        for (int i = 0; i < propertyTypes.length; ++i) {
            PropertyType pt = propertyTypes[i];
            if (!primaryKeySet.contains(pt.getColumnName())) continue;
            pt.setPrimaryKey(true);
        }
    }

    protected DatabaseMetaData getDatabaseMetaData() {
        if (this.databaseMetaData == null) {
            throw new EmptyRuntimeException("databaseMetaData");
        }
        return this.databaseMetaData;
    }
}

