/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.impl;

import java.util.ArrayList;
import org.seasar.dao.BeanAnnotationReader;
import org.seasar.dao.ColumnNaming;
import org.seasar.dao.Dbms;
import org.seasar.dao.PropertyTypeFactory;
import org.seasar.dao.ValueTypeFactory;
import org.seasar.extension.jdbc.PropertyType;
import org.seasar.extension.jdbc.ValueType;
import org.seasar.extension.jdbc.impl.PropertyTypeImpl;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.exception.EmptyRuntimeException;

public abstract class AbstractPropertyTypeFactory
implements PropertyTypeFactory {
    protected Class beanClass;
    protected BeanAnnotationReader beanAnnotationReader;
    protected ValueTypeFactory valueTypeFactory;
    protected ColumnNaming columnNaming;
    private Dbms dbms;

    public AbstractPropertyTypeFactory(Class beanClass, BeanAnnotationReader beanAnnotationReader, ValueTypeFactory valueTypeFactory, ColumnNaming columnNaming) {
        this.beanClass = beanClass;
        this.beanAnnotationReader = beanAnnotationReader;
        this.valueTypeFactory = valueTypeFactory;
        this.columnNaming = columnNaming;
    }

    public AbstractPropertyTypeFactory(Class beanClass, BeanAnnotationReader beanAnnotationReader, ValueTypeFactory valueTypeFactory, ColumnNaming columnNaming, Dbms dbms) {
        this(beanClass, beanAnnotationReader, valueTypeFactory, columnNaming);
        this.dbms = dbms;
    }

    public PropertyType[] createDtoPropertyTypes() {
        ArrayList<PropertyType> list = new ArrayList<PropertyType>();
        BeanDesc beanDesc = this.getBeanDesc();
        for (int i = 0; i < beanDesc.getPropertyDescSize(); ++i) {
            PropertyDesc pd = beanDesc.getPropertyDesc(i);
            PropertyType pt = this.createPropertyType(pd);
            list.add(pt);
        }
        return list.toArray(new PropertyType[list.size()]);
    }

    protected BeanDesc getBeanDesc() {
        return BeanDescFactory.getBeanDesc((Class)this.beanClass);
    }

    protected boolean isRelation(PropertyDesc propertyDesc) {
        return this.beanAnnotationReader.hasRelationNo(propertyDesc);
    }

    protected boolean isPrimaryKey(PropertyDesc propertyDesc) {
        Dbms dbms = this.getDbms();
        return this.beanAnnotationReader.getId(propertyDesc, dbms) != null;
    }

    protected boolean isPersistent(PropertyType propertyType) {
        String[] props = this.beanAnnotationReader.getNoPersisteneProps();
        if (props != null) {
            String propertyName = propertyType.getPropertyName();
            for (int i = 0; i < props.length; ++i) {
                if (!props[i].equals(propertyName)) continue;
                return false;
            }
        }
        return true;
    }

    protected PropertyType createPropertyType(PropertyDesc propertyDesc) {
        String columnName = this.getColumnName(propertyDesc);
        ValueType valueType = this.getValueType(propertyDesc);
        return new PropertyTypeImpl(propertyDesc, valueType, columnName);
    }

    protected String getColumnName(PropertyDesc propertyDesc) {
        String propertyName = propertyDesc.getPropertyName();
        String defaultName = this.fromPropertyNameToColumnName(propertyName);
        String name = this.beanAnnotationReader.getColumnAnnotation(propertyDesc);
        return name != null ? name : defaultName;
    }

    protected String fromPropertyNameToColumnName(String propertyName) {
        return this.columnNaming.fromPropertyNameToColumnName(propertyName);
    }

    protected ValueType getValueType(PropertyDesc propertyDesc) {
        String name = this.beanAnnotationReader.getValueType(propertyDesc);
        if (name != null) {
            return this.valueTypeFactory.getValueTypeByName(name);
        }
        Class type = propertyDesc.getPropertyType();
        return this.valueTypeFactory.getValueTypeByClass(type);
    }

    public Dbms getDbms() {
        if (this.dbms == null) {
            throw new EmptyRuntimeException("dbms");
        }
        return this.dbms;
    }
}

