/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.sql.DataSource;
import org.seasar.dao.BeanMetaData;
import org.seasar.dao.impl.AbstractAutoHandler;
import org.seasar.extension.jdbc.PropertyType;
import org.seasar.extension.jdbc.ReturningRowsBatchHandler;
import org.seasar.extension.jdbc.StatementFactory;
import org.seasar.extension.jdbc.util.ConnectionUtil;
import org.seasar.framework.exception.SQLRuntimeException;
import org.seasar.framework.util.PreparedStatementUtil;
import org.seasar.framework.util.StatementUtil;

public abstract class AbstractBatchAutoHandler
extends AbstractAutoHandler
implements ReturningRowsBatchHandler {
    public AbstractBatchAutoHandler(DataSource dataSource, StatementFactory statementFactory, BeanMetaData beanMetaData, PropertyType[] propertyTypes) {
        super(dataSource, statementFactory, beanMetaData, propertyTypes);
    }

    public int[] execute(List list, Class[] argTypes) throws SQLRuntimeException {
        return this.execute(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] execute(List list) throws SQLRuntimeException {
        if (list == null) {
            throw new IllegalArgumentException("list");
        }
        Connection connection = this.getConnection();
        try {
            int[] nArray;
            PreparedStatement ps = this.prepareStatement(connection);
            try {
                Iterator iter = list.iterator();
                while (iter.hasNext()) {
                    Object bean = iter.next();
                    this.execute(ps, bean);
                }
                nArray = PreparedStatementUtil.executeBatch((PreparedStatement)ps);
            }
            catch (Throwable throwable) {
                StatementUtil.close((Statement)ps);
                throw throwable;
            }
            StatementUtil.close((Statement)ps);
            return nArray;
        }
        finally {
            ConnectionUtil.close((Connection)connection);
        }
    }

    public int execute(Object[] args) throws SQLRuntimeException {
        List list = null;
        if (args[0] instanceof Object[]) {
            list = Arrays.asList((Object[])args[0]);
        } else if (args[0] instanceof List) {
            list = (List)args[0];
        }
        if (list == null) {
            throw new IllegalArgumentException("args[0]");
        }
        int[] ret = this.execute(list);
        int updatedRow = 0;
        for (int i = 0; i < ret.length; ++i) {
            if (ret[i] <= 0) continue;
            updatedRow += ret[i];
        }
        return updatedRow;
    }

    public int[] executeBatch(Object[] args) throws SQLRuntimeException {
        List list = null;
        if (args[0] instanceof Object[]) {
            list = Arrays.asList((Object[])args[0]);
        } else if (args[0] instanceof List) {
            list = (List)args[0];
        }
        if (list == null) {
            throw new IllegalArgumentException("args[0]");
        }
        return this.execute(list);
    }

    protected void execute(PreparedStatement ps, Object bean) {
        this.setupBindVariables(bean);
        this.logSql(this.getBindVariables(), this.getArgTypes(this.getBindVariables()));
        this.bindArgs(ps, this.getBindVariables(), this.getBindVariableValueTypes());
        PreparedStatementUtil.addBatch((PreparedStatement)ps);
    }
}

