/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.where;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.seasar.extension.jdbc.ConditionType;
import org.seasar.extension.jdbc.where.SingleValueOperator;
import org.seasar.framework.util.StringUtil;

public class LikeOperator
extends SingleValueOperator {
    protected static final Pattern WILDCARD_PATTERN = Pattern.compile("[$%_]");
    protected static final char WILDCARD_ESCAPE_CHAR = '$';
    protected String escapeChar;
    protected boolean needEscape;

    public LikeOperator(ConditionType conditionType, CharSequence propertyName, Object value) {
        super(conditionType, propertyName, value);
        switch (conditionType) {
            case STARTS: 
            case ENDS: 
            case CONTAINS: {
                this.needEscape = true;
            }
        }
    }

    public LikeOperator(ConditionType conditionType, CharSequence propertyName, Object value, String escapeChar) {
        super(conditionType, propertyName, value);
        this.escapeChar = escapeChar;
    }

    public LikeOperator(ConditionType conditionType, CharSequence propertyName, Object value, boolean needEscape) {
        super(conditionType, propertyName, value);
        this.needEscape = needEscape;
    }

    protected Object normalize(Object value) {
        Object param = super.normalize(value);
        if (param == null) {
            return null;
        }
        if (!StringUtil.isEmpty((String)this.escapeChar)) {
            return new Object[]{param, this.escapeChar};
        }
        if (!this.needEscape) {
            return param;
        }
        String normalizedValue = (String)param;
        if (normalizedValue.indexOf(37) == -1 && normalizedValue.indexOf(95) == -1) {
            return normalizedValue;
        }
        switch (this.conditionType) {
            case STARTS: {
                this.conditionType = ConditionType.STARTS_ESCAPE;
                break;
            }
            case ENDS: {
                this.conditionType = ConditionType.ENDS_ESCAPE;
                break;
            }
            case CONTAINS: {
                this.conditionType = ConditionType.CONTAINS_ESCAPE;
            }
        }
        return this.escapeWildcard((String)String.class.cast(normalizedValue));
    }

    protected String escapeWildcard(String likeCondition) {
        Matcher matcher = WILDCARD_PATTERN.matcher(likeCondition);
        return matcher.replaceAll("\\$$0");
    }
}

