/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.arg;

import java.util.ArrayList;
import java.util.List;
import org.seasar.extension.jdbc.gen.internal.argtype.ArgumentType;
import org.seasar.extension.jdbc.gen.internal.argtype.ArgumentTypeRegistry;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArgumentsBuilder {
    protected static Logger logger = Logger.getLogger(ArgumentsBuilder.class);
    protected Object bean;
    protected BeanDesc beanDesc;

    public ArgumentsBuilder(Object bean) {
        if (bean == null) {
            throw new NullPointerException("bean");
        }
        this.bean = bean;
        this.beanDesc = BeanDescFactory.getBeanDesc(bean.getClass());
    }

    public List<String> build() {
        ArrayList<String> args = new ArrayList<String>();
        int i = 0;
        while (i < this.beanDesc.getPropertyDescSize()) {
            PropertyDesc propertyDesc = this.beanDesc.getPropertyDesc(i);
            if (propertyDesc.hasReadMethod()) {
                ArgumentType<Object> argumentType = ArgumentTypeRegistry.getArgumentType(propertyDesc);
                if (argumentType == null) {
                    logger.log("WS2JDBCGEN0001", new Object[]{this.bean.getClass().getName(), propertyDesc.getPropertyName()});
                } else {
                    String name = propertyDesc.getPropertyName();
                    Object value = propertyDesc.getValue(this.bean);
                    args.add(String.valueOf(name) + "=" + argumentType.toText(value));
                }
            }
            ++i;
        }
        return args;
    }
}

