/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.ea2ddl.dao.allcommon.s2dao.internal.various;

import java.lang.reflect.Field;
import org.seasar.extension.jdbc.ValueType;

public class InternalProcedureParameterType {
    private String parameterName;
    private Integer parameterIndex;
    private Field field;
    private ValueType valueType;
    private boolean inType;
    private boolean outType;
    private boolean returnType;

    public InternalProcedureParameterType(Field field) {
        this.field = field;
        this.parameterName = field.getName();
    }

    public Object getValue(Object target) {
        try {
            return this.field.get(target);
        }
        catch (IllegalAccessException e) {
            String msg = "The getting of the field threw the exception:";
            msg = String.valueOf(msg) + " class=" + this.field.getDeclaringClass().getSimpleName();
            msg = String.valueOf(msg) + " field=" + this.field.getName();
            throw new IllegalStateException(msg, e);
        }
    }

    public void setValue(Object target, Object value) {
        try {
            this.field.set(target, value);
        }
        catch (IllegalAccessException e) {
            String msg = "The setting of the field threw the exception:";
            msg = String.valueOf(msg) + " class=" + this.field.getDeclaringClass().getSimpleName();
            msg = String.valueOf(msg) + " field=" + this.field.getName();
            throw new IllegalStateException(msg, e);
        }
    }

    public String getParameterName() {
        return this.parameterName;
    }

    public Integer getParameterIndex() {
        return this.parameterIndex;
    }

    public void setParameterIndex(Integer parameterIndex) {
        this.parameterIndex = parameterIndex;
    }

    public ValueType getValueType() {
        return this.valueType;
    }

    public void setValueType(ValueType valueType) {
        this.valueType = valueType;
    }

    public boolean isInType() {
        return this.inType;
    }

    public void setInType(boolean inType) {
        this.inType = inType;
    }

    public boolean isOutType() {
        return this.outType;
    }

    public void setOutType(boolean outType) {
        this.outType = outType;
    }

    public boolean isReturnType() {
        return this.returnType;
    }

    public void setReturnType(boolean returnType) {
        this.returnType = returnType;
    }
}

