/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.ea2ddl.dao.allcommon.s2dao.internal.sqllog;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternalSqlLogRegistry {
    private static final Log _log = LogFactory.getLog(InternalSqlLogRegistry.class);
    protected static final String NAME_SqlLogRegistryLocator = "org.seasar.extension.jdbc.SqlLogRegistryLocator";
    protected static final String NAME_getInstance = "getInstance";
    protected static final String NAME_setInstance = "setInstance";
    protected static final String NAME_SqlLogRegistry = "org.seasar.extension.jdbc.SqlLogRegistry";
    protected static final String NAME_SqlLog = "org.seasar.extension.jdbc.SqlLog";
    protected static final String NAME_SqlLogImpl = "org.seasar.extension.jdbc.impl.SqlLogImpl";
    protected static boolean STATUS_SqlLogExists = false;

    static {
        InternalSqlLogRegistry.forNameContainerSqlLogRegistryLocator();
    }

    public static boolean existsSqlLogRegistry() {
        return STATUS_SqlLogExists;
    }

    public static Object findContainerSqlLogRegistry() {
        Class<?> sqlLogRegistryLocatorType = InternalSqlLogRegistry.forNameContainerSqlLogRegistryLocator();
        if (sqlLogRegistryLocatorType == null) {
            return null;
        }
        try {
            Method method = sqlLogRegistryLocatorType.getMethod(NAME_getInstance, null);
            return method.invoke(null, null);
        }
        catch (Exception e) {
            String msg = "InternalSqlLogRegistry.findContainerSqlLogRegistry() threw the exception:";
            msg = String.valueOf(msg) + " sqlLogRegistryLocatorType=" + sqlLogRegistryLocatorType;
            msg = String.valueOf(msg) + " NAME_getInstance=" + NAME_getInstance;
            throw new IllegalStateException(msg, e);
        }
    }

    public static void closeRegistration() {
        Class<?> sqlLogRegistryLocatorType = InternalSqlLogRegistry.forNameContainerSqlLogRegistryLocator();
        if (sqlLogRegistryLocatorType == null) {
            return;
        }
        Class<?> sqlLogRegistryType = InternalSqlLogRegistry.forNameContainerSqlLogRegistry();
        if (sqlLogRegistryType == null) {
            return;
        }
        try {
            Method method = sqlLogRegistryLocatorType.getMethod(NAME_setInstance, sqlLogRegistryType);
            _log.info((Object)"...Closing the registration of sqlLog.");
            method.invoke(null, new Object[1]);
        }
        catch (Exception e) {
            String msg = "InternalSqlLogRegistry.closeRegistration() threw the exception:";
            msg = String.valueOf(msg) + " sqlLogRegistryLocatorType=" + sqlLogRegistryLocatorType;
            msg = String.valueOf(msg) + " NAME_setInstance=" + NAME_setInstance;
            throw new IllegalStateException(msg, e);
        }
    }

    public static void push(String rawSql, String completeSql, Object[] bindArgs, Class<?>[] bindArgTypes, Object sqlLogRegistry) {
        if (sqlLogRegistry == null) {
            throw new IllegalArgumentException("sqlLogRegistry should not be null!");
        }
        Object sqlLogImpl = InternalSqlLogRegistry.createContainerSqlLogImpl(rawSql, completeSql, bindArgs, bindArgTypes);
        InternalSqlLogRegistry.reflectSqlLogToContainerSqlLogRegistry(sqlLogImpl, sqlLogRegistry);
    }

    public static String peekCompleteSql() {
        Object sqlLogRegistry = InternalSqlLogRegistry.findContainerSqlLogRegistry();
        if (sqlLogRegistry == null) {
            return null;
        }
        Object sqlLog = InternalSqlLogRegistry.findLastContainerSqlLog(sqlLogRegistry);
        if (sqlLog == null) {
            return null;
        }
        return InternalSqlLogRegistry.extractCompleteSqlFromContainerSqlLog(sqlLog);
    }

    protected static Object createContainerSqlLogImpl(String rawSql, String completeSql, Object[] bindArgs, Class<?>[] bindArgTypes) {
        try {
            Class<?> sqlLogImplType = Class.forName(NAME_SqlLogImpl);
            Class[] argTypes = new Class[]{String.class, String.class, Object[].class, Class[].class};
            Constructor<?> constructor = sqlLogImplType.getConstructor(argTypes);
            return constructor.newInstance(rawSql, completeSql, bindArgs, bindArgTypes);
        }
        catch (Exception e) {
            String msg = "InternalSqlLogRegistry.createContainerSqlLogImpl() threw the exception:";
            msg = String.valueOf(msg) + " completeSql=" + completeSql;
            msg = String.valueOf(msg) + " NAME_SqlLogImpl=" + NAME_SqlLogImpl;
            throw new IllegalStateException(msg, e);
        }
    }

    protected static void reflectSqlLogToContainerSqlLogRegistry(Object sqlLog, Object sqlLogRegistry) {
        if (sqlLog == null || sqlLogRegistry == null) {
            return;
        }
        try {
            Class<?> sqlLogRegistryType = sqlLogRegistry.getClass();
            Class<?> sqlLogType = Class.forName(NAME_SqlLog);
            Method method = sqlLogRegistryType.getMethod("add", sqlLogType);
            method.invoke(sqlLogRegistry, sqlLog);
        }
        catch (Exception e) {
            String msg = "InternalSqlLogRegistry.reflectToContainerSqlLogRegistry() threw the exception:";
            msg = String.valueOf(msg) + " sqlLog=" + sqlLog + " sqlLogRegistry=" + sqlLogRegistry;
            msg = String.valueOf(msg) + " NAME_SqlLog=" + NAME_SqlLog;
            throw new IllegalStateException(msg, e);
        }
    }

    protected static Object findLastContainerSqlLog(Object sqlLogRegistry) {
        if (sqlLogRegistry == null) {
            return null;
        }
        try {
            Class<?> sqlLogRegistryType = sqlLogRegistry.getClass();
            Method method = sqlLogRegistryType.getMethod("getLast", null);
            return method.invoke(sqlLogRegistry, null);
        }
        catch (Exception e) {
            String msg = "InternalSqlLogRegistry.findLastContainerSqlLog() threw the exception:";
            msg = String.valueOf(msg) + " sqlLogRegistry=" + sqlLogRegistry;
            throw new IllegalStateException(msg, e);
        }
    }

    protected static String extractCompleteSqlFromContainerSqlLog(Object sqlLog) {
        if (sqlLog == null) {
            return null;
        }
        try {
            Class<?> sqlLogType = sqlLog.getClass();
            Method method = sqlLogType.getMethod("getCompleteSql", null);
            return (String)method.invoke(sqlLog, null);
        }
        catch (Exception e) {
            String msg = "InternalSqlLogRegistry.extractCompleteSqlFromContainerSqlLog() threw the exception:";
            msg = String.valueOf(msg) + " sqlLog=" + sqlLog;
            throw new IllegalStateException(msg, e);
        }
    }

    protected static Class<?> forNameContainerSqlLogRegistryLocator() {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(NAME_SqlLogRegistryLocator);
            STATUS_SqlLogExists = true;
        }
        catch (Exception ignored) {
            STATUS_SqlLogExists = false;
            return null;
        }
        return clazz;
    }

    protected static Class<?> forNameContainerSqlLogRegistry() {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(NAME_SqlLogRegistry);
        }
        catch (Exception ignored) {
            return null;
        }
        return clazz;
    }
}

