/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.ea2ddl.dao.allcommon.s2dao.internal.sqlhandler;

import java.sql.Connection;
import java.sql.PreparedStatement;
import javax.sql.DataSource;
import jp.sourceforge.ea2ddl.dao.allcommon.s2dao.internal.sqlhandler.InternalBasicHandler;
import org.seasar.dao.CommandContext;
import org.seasar.extension.jdbc.StatementFactory;

public class InternalCommandContextHandler
extends InternalBasicHandler {
    protected CommandContext commandContext;

    public InternalCommandContextHandler(DataSource dataSource, StatementFactory statementFactory, CommandContext commandContext) {
        super(dataSource, statementFactory);
        this.commandContext = commandContext;
        this.setSql(commandContext.getSql());
    }

    public int execute(Object[] args) {
        Connection connection = this.getConnection();
        try {
            int n = this.execute(connection, this.commandContext);
            return n;
        }
        finally {
            this.close(connection);
        }
    }

    protected int execute(Connection connection, CommandContext context) {
        this.logSql(context.getBindVariables(), this.getArgTypes(context.getBindVariables()));
        PreparedStatement ps = this.prepareStatement(connection);
        int ret = -1;
        try {
            this.bindArgs(ps, context.getBindVariables(), context.getBindVariableTypes());
            ret = this.executeUpdate(ps);
        }
        finally {
            this.close(ps);
        }
        return ret;
    }
}

