/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.ea2ddl.dao.allcommon.s2dao.internal.sqlhandler;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.FetchNarrowingBean;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.FetchNarrowingBeanContext;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.outsidesql.OutsideSqlContext;
import jp.sourceforge.ea2ddl.dao.allcommon.s2dao.FetchNarrowingResultSetWrapper;
import jp.sourceforge.ea2ddl.dao.allcommon.s2dao.internal.sqlhandler.InternalBasicHandler;
import org.seasar.extension.jdbc.ResultSetHandler;
import org.seasar.extension.jdbc.StatementFactory;

public class InternalBasicSelectHandler
extends InternalBasicHandler {
    private ResultSetHandler resultSetHandler;

    public InternalBasicSelectHandler(DataSource dataSource, String sql, ResultSetHandler resultSetHandler, StatementFactory statementFactory) {
        super(dataSource, statementFactory);
        this.setSql(sql);
        this.setResultSetHandler(resultSetHandler);
    }

    public Object execute(Object[] args) {
        return this.execute(args, this.getArgTypes(args));
    }

    public Object execute(Object[] args, Class[] argTypes) {
        Connection conn = this.getConnection();
        try {
            Object object = this.execute(conn, args, argTypes);
            return object;
        }
        finally {
            this.close(conn);
        }
    }

    public Object execute(Connection conn, Object[] args, Class[] argTypes) {
        this.logSql(args, argTypes);
        PreparedStatement ps = null;
        try {
            ps = this.prepareStatement(conn);
            this.bindArgs(ps, args, argTypes);
            Object object = this.execute(ps);
            return object;
        }
        catch (SQLException e) {
            this.handleSQLException(e, ps);
            return null;
        }
        finally {
            this.close(ps);
        }
    }

    protected Object execute(PreparedStatement ps) throws SQLException {
        if (this.resultSetHandler == null) {
            throw new IllegalStateException("The resultSetHandler should not be null!");
        }
        ResultSet resultSet = null;
        try {
            resultSet = this.createResultSet(ps);
            Object object = this.resultSetHandler.handle(resultSet);
            return object;
        }
        finally {
            this.close(resultSet);
        }
    }

    protected ResultSet createResultSet(PreparedStatement ps) throws SQLException {
        FetchNarrowingResultSetWrapper wrapper;
        ResultSet resultSet = ps.executeQuery();
        if (!FetchNarrowingBeanContext.isExistFetchNarrowingBeanOnThread()) {
            return resultSet;
        }
        FetchNarrowingBean cb = FetchNarrowingBeanContext.getFetchNarrowingBeanOnThread();
        if (!this.isUseFetchNarrowingResultSetWrapper(cb)) {
            return resultSet;
        }
        if (OutsideSqlContext.isExistOutsideSqlContextOnThread()) {
            OutsideSqlContext outsideSqlContext = OutsideSqlContext.getOutsideSqlContextOnThread();
            wrapper = new FetchNarrowingResultSetWrapper(resultSet, cb, outsideSqlContext.isOffsetByCursorForcedly(), outsideSqlContext.isLimitByCursorForcedly());
        } else {
            wrapper = new FetchNarrowingResultSetWrapper(resultSet, cb, false, false);
        }
        return wrapper;
    }

    protected boolean isUseFetchNarrowingResultSetWrapper(FetchNarrowingBean cb) {
        OutsideSqlContext outsideSqlContext;
        if (cb.getSafetyMaxResultSize() > 0) {
            return true;
        }
        if (!cb.isFetchNarrowingEffective()) {
            return false;
        }
        if (OutsideSqlContext.isExistOutsideSqlContextOnThread() && ((outsideSqlContext = OutsideSqlContext.getOutsideSqlContextOnThread()).isOffsetByCursorForcedly() || outsideSqlContext.isLimitByCursorForcedly())) {
            return true;
        }
        return cb.isFetchNarrowingSkipStartIndexEffective() || cb.isFetchNarrowingLoopCountEffective();
    }

    public ResultSetHandler getResultSetHandler() {
        return this.resultSetHandler;
    }

    public void setResultSetHandler(ResultSetHandler resultSetHandler) {
        this.resultSetHandler = resultSetHandler;
    }
}

