/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.ea2ddl.dao.allcommon.s2dao.internal.sqlhandler;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import jp.sourceforge.ea2ddl.dao.allcommon.DBFluteConfig;
import jp.sourceforge.ea2ddl.dao.allcommon.InternalMapContext;
import jp.sourceforge.ea2ddl.dao.allcommon.QLog;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.ConditionBean;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.ConditionBeanContext;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.outsidesql.OutsideSqlContext;
import jp.sourceforge.ea2ddl.dao.allcommon.exception.EntityAlreadyExistsException;
import jp.sourceforge.ea2ddl.dao.allcommon.exception.SQLFailureException;
import jp.sourceforge.ea2ddl.dao.allcommon.s2dao.internal.sqllog.InternalSqlLogRegistry;
import jp.sourceforge.ea2ddl.dao.allcommon.s2dao.internal.util.InternalBindVariableUtil;
import jp.sourceforge.ea2ddl.dao.allcommon.util.SimpleSystemUtil;
import org.seasar.extension.jdbc.StatementFactory;
import org.seasar.extension.jdbc.ValueType;
import org.seasar.extension.jdbc.types.ValueTypes;
import org.seasar.framework.exception.SQLRuntimeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternalBasicHandler {
    private DataSource dataSource;
    private String sql;
    private StatementFactory statementFactory;
    private Object[] loggingMessageSqlArgs;

    public InternalBasicHandler(DataSource ds, StatementFactory statementFactory) {
        this.setDataSource(ds);
        this.setStatementFactory(statementFactory);
    }

    public InternalBasicHandler(DataSource ds, String sql, StatementFactory statementFactory) {
        this.setDataSource(ds);
        this.setSql(sql);
        this.setStatementFactory(statementFactory);
    }

    protected void bindArgs(PreparedStatement ps, Object[] args, Class<?>[] argTypes) {
        if (args == null) {
            return;
        }
        int i = 0;
        while (i < args.length) {
            ValueType valueType = this.getValueType(argTypes[i]);
            try {
                valueType.bindValue(ps, i + 1, args[i]);
            }
            catch (SQLException e) {
                this.handleSQLException(e, ps);
            }
            ++i;
        }
    }

    protected Class<?>[] getArgTypes(Object[] args) {
        if (args == null) {
            return null;
        }
        Class[] argTypes = new Class[args.length];
        int i = 0;
        while (i < args.length) {
            Object arg = args[i];
            if (arg != null) {
                argTypes[i] = arg.getClass();
            }
            ++i;
        }
        return argTypes;
    }

    protected String getCompleteSql(Object[] args) {
        return InternalBindVariableUtil.getCompleteSql(this.sql, args);
    }

    protected String getBindVariableText(Object bindVariable) {
        return InternalBindVariableUtil.getBindVariableText(bindVariable);
    }

    protected ValueType getValueType(Class<?> clazz) {
        return ValueTypes.getValueType(clazz);
    }

    protected void logSql(Object[] args, Class<?>[] argTypes) {
        if (QLog.isLogEnabled() || InternalSqlLogRegistry.existsSqlLogRegistry()) {
            Object sqlLogRegistry;
            String completeSql = this.getCompleteSql(args);
            if (this.isContainsLineSeparatorInSql()) {
                QLog.log(String.valueOf(this.getLineSeparator()) + completeSql);
            } else {
                QLog.log(completeSql);
            }
            if (InternalSqlLogRegistry.existsSqlLogRegistry() && (sqlLogRegistry = InternalSqlLogRegistry.findContainerSqlLogRegistry()) != null) {
                InternalSqlLogRegistry.push(this.getSql(), completeSql, args, argTypes, sqlLogRegistry);
            }
        }
    }

    protected boolean isContainsLineSeparatorInSql() {
        return this.sql != null ? this.sql.contains(this.getLineSeparator()) : false;
    }

    protected void handleSQLException(SQLException e, Statement statement) {
        this.handleSQLException(e, statement, false);
    }

    protected void handleSQLException(SQLException e, Statement statement, boolean uniqueConstraintValid) {
        String completeSql = this.buildLoggingMessageSql();
        new SQLExceptionHandler().handleSQLException(e, statement, uniqueConstraintValid, completeSql);
    }

    protected String buildLoggingMessageSql() {
        String completeSql = null;
        if (this.sql != null && this.loggingMessageSqlArgs != null) {
            try {
                completeSql = this.getCompleteSql(this.loggingMessageSqlArgs);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return completeSql;
    }

    protected Connection getConnection() {
        if (this.dataSource == null) {
            throw new IllegalStateException("The dataSource should not be null!");
        }
        try {
            return this.dataSource.getConnection();
        }
        catch (SQLException e) {
            this.handleSQLException(e, null);
            return null;
        }
    }

    protected PreparedStatement prepareStatement(Connection conn) {
        if (this.sql == null) {
            throw new IllegalStateException("The sql should not be null!");
        }
        return this.statementFactory.createPreparedStatement(conn, this.sql);
    }

    protected int executeUpdate(PreparedStatement ps) {
        try {
            return ps.executeUpdate();
        }
        catch (SQLException e) {
            this.handleSQLException(e, ps, true);
            return 0;
        }
    }

    protected void setFetchSize(Statement statement, int fetchSize) {
        if (statement == null) {
            return;
        }
        try {
            statement.setFetchSize(fetchSize);
        }
        catch (SQLException e) {
            this.handleSQLException(e, statement);
        }
    }

    protected void setMaxRows(Statement statement, int maxRows) {
        if (statement == null) {
            return;
        }
        try {
            statement.setMaxRows(maxRows);
        }
        catch (SQLException e) {
            this.handleSQLException(e, statement);
        }
    }

    protected void close(Statement statement) {
        if (statement == null) {
            return;
        }
        try {
            statement.close();
        }
        catch (SQLException e) {
            this.handleSQLException(e, statement);
        }
    }

    protected void close(ResultSet resultSet) {
        if (resultSet == null) {
            return;
        }
        try {
            resultSet.close();
        }
        catch (SQLException e) {
            this.handleSQLException(e, null);
        }
    }

    protected void close(Connection conn) {
        if (conn == null) {
            return;
        }
        try {
            conn.close();
        }
        catch (SQLException e) {
            this.handleSQLException(e, null);
        }
    }

    protected String removeLineComment(String sql) {
        String[] lines;
        if (sql == null || sql.trim().length() == 0) {
            return sql;
        }
        StringBuilder sb = new StringBuilder();
        String[] stringArray = lines = sql.split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line != null && !(line = line.replaceAll("\r", "")).startsWith("--")) {
                sb.append(line).append("\n");
            }
            ++n2;
        }
        return sb.toString();
    }

    protected String getLineSeparator() {
        return SimpleSystemUtil.getLineSeparator();
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql = this.removeLineComment(sql);
    }

    public StatementFactory getStatementFactory() {
        return this.statementFactory;
    }

    public void setStatementFactory(StatementFactory statementFactory) {
        this.statementFactory = statementFactory;
    }

    public void setLoggingMessageSqlArgs(Object[] loggingMessageSqlArgs) {
        this.loggingMessageSqlArgs = loggingMessageSqlArgs;
    }

    public static class SQLExceptionHandler {
        public void handleSQLException(SQLException e, Statement statement) {
            this.handleSQLException(e, statement, false);
        }

        public void handleSQLException(SQLException e, Statement statement, boolean uniqueConstraintValid) {
            this.handleSQLException(e, statement, uniqueConstraintValid, null);
        }

        public void handleSQLException(SQLException e, Statement statement, boolean uniqueConstraintValid, String completeSql) {
            if (this.isSqlExceptionOldStyleHandling()) {
                throw new SQLRuntimeException(e);
            }
            if (uniqueConstraintValid && this.isUniqueConstraintException(e)) {
                this.throwEntityAlreadyExistsException(e, statement, completeSql);
            }
            this.throwSQLFailureException(e, statement, completeSql);
        }

        protected boolean isUniqueConstraintException(SQLException e) {
            DBFluteConfig.UniqueConstraintDeterminator determinator = this.getUniqueConstraintDeterminator();
            if (determinator != null) {
                return determinator.isUniqueConstraintException(e);
            }
            return ConditionBeanContext.isUniqueConstraintException(this.extractSQLState(e), e.getErrorCode());
        }

        protected DBFluteConfig.UniqueConstraintDeterminator getUniqueConstraintDeterminator() {
            return DBFluteConfig.getInstance().getUniqueConstraintDeterminator();
        }

        protected boolean isSqlExceptionOldStyleHandling() {
            return DBFluteConfig.getInstance().isSqlExceptionOldStyleHandling();
        }

        protected void throwEntityAlreadyExistsException(SQLException e, Statement statement, String completeSql) {
            String invokeName;
            String msg = "Look! Read the message below." + this.getLineSeparator();
            msg = String.valueOf(msg) + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.getLineSeparator();
            msg = String.valueOf(msg) + "The entity already exists on the database!" + this.getLineSeparator();
            msg = String.valueOf(msg) + this.getLineSeparator();
            msg = String.valueOf(msg) + "[Advice]" + this.getLineSeparator();
            msg = String.valueOf(msg) + "Please confirm the primary key whether it already exists on the database." + this.getLineSeparator();
            msg = String.valueOf(msg) + "And confirm the unique constraint for other columns." + this.getLineSeparator();
            msg = String.valueOf(msg) + this.getLineSeparator();
            msg = String.valueOf(msg) + "[SQLState]" + this.getLineSeparator() + this.extractSQLState(e) + this.getLineSeparator();
            msg = String.valueOf(msg) + this.getLineSeparator();
            msg = String.valueOf(msg) + "[ErrorCode]" + this.getLineSeparator() + e.getErrorCode() + this.getLineSeparator();
            msg = String.valueOf(msg) + this.getLineSeparator();
            msg = String.valueOf(msg) + "[SQLException]" + this.getLineSeparator() + e.getClass().getName() + this.getLineSeparator();
            msg = String.valueOf(msg) + e.getMessage() + this.getLineSeparator();
            SQLException nextEx = e.getNextException();
            if (nextEx != null) {
                msg = String.valueOf(msg) + this.getLineSeparator();
                msg = String.valueOf(msg) + "[NextException]" + this.getLineSeparator();
                msg = String.valueOf(msg) + nextEx.getClass().getName() + this.getLineSeparator();
                msg = String.valueOf(msg) + nextEx.getMessage() + this.getLineSeparator();
                SQLException nextNextEx = nextEx.getNextException();
                if (nextNextEx != null) {
                    msg = String.valueOf(msg) + this.getLineSeparator();
                    msg = String.valueOf(msg) + "[NextNextException]" + this.getLineSeparator();
                    msg = String.valueOf(msg) + nextNextEx.getClass().getName() + this.getLineSeparator();
                    msg = String.valueOf(msg) + nextNextEx.getMessage() + this.getLineSeparator();
                }
            }
            if ((invokeName = this.extractBehaviorInvokeName()) != null) {
                msg = String.valueOf(msg) + this.getLineSeparator();
                msg = String.valueOf(msg) + "[Behavior]" + this.getLineSeparator();
                msg = String.valueOf(msg) + invokeName + this.getLineSeparator();
            }
            if (this.hasConditionBean()) {
                msg = String.valueOf(msg) + this.getLineSeparator();
                msg = String.valueOf(msg) + "[ConditionBean]" + this.getLineSeparator();
                msg = String.valueOf(msg) + this.getConditionBean().getClass().getName() + this.getLineSeparator();
            }
            if (this.hasOutsideSqlContext()) {
                msg = String.valueOf(msg) + this.getLineSeparator();
                msg = String.valueOf(msg) + "[OutsideSql]" + this.getLineSeparator();
                msg = String.valueOf(msg) + this.getOutsideSqlContext().getOutsideSqlPath() + this.getLineSeparator();
                msg = String.valueOf(msg) + this.getLineSeparator();
                msg = String.valueOf(msg) + "[ParameterBean]" + this.getLineSeparator();
                Object pmb = this.getOutsideSqlContext().getParameterBean();
                if (pmb != null) {
                    msg = String.valueOf(msg) + pmb.getClass().getName() + this.getLineSeparator();
                    msg = String.valueOf(msg) + pmb + this.getLineSeparator();
                } else {
                    msg = String.valueOf(msg) + pmb + this.getLineSeparator();
                }
            }
            if (statement != null) {
                msg = String.valueOf(msg) + this.getLineSeparator();
                msg = String.valueOf(msg) + "[Statement]" + this.getLineSeparator();
                msg = String.valueOf(msg) + statement.getClass().getName() + this.getLineSeparator();
            }
            if (completeSql != null) {
                msg = String.valueOf(msg) + this.getLineSeparator();
                msg = String.valueOf(msg) + "[Display SQL]" + this.getLineSeparator();
                msg = String.valueOf(msg) + completeSql + this.getLineSeparator();
            }
            msg = String.valueOf(msg) + "* * * * * * * * * */";
            throw new EntityAlreadyExistsException(msg, e);
        }

        protected void throwSQLFailureException(SQLException e, Statement statement, String completeSql) {
            String invokeName;
            String msg = "Look! Read the message below." + this.getLineSeparator();
            msg = String.valueOf(msg) + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.getLineSeparator();
            msg = String.valueOf(msg) + "The SQL failed to execute!" + this.getLineSeparator();
            msg = String.valueOf(msg) + this.getLineSeparator();
            msg = String.valueOf(msg) + "[Advice]" + this.getLineSeparator();
            msg = String.valueOf(msg) + "Please confirm the SQLException message." + this.getLineSeparator();
            msg = String.valueOf(msg) + this.getLineSeparator();
            msg = String.valueOf(msg) + "[SQLState]" + this.getLineSeparator() + this.extractSQLState(e) + this.getLineSeparator();
            msg = String.valueOf(msg) + this.getLineSeparator();
            msg = String.valueOf(msg) + "[ErrorCode]" + this.getLineSeparator() + e.getErrorCode() + this.getLineSeparator();
            msg = String.valueOf(msg) + this.getLineSeparator();
            msg = String.valueOf(msg) + "[SQLException]" + this.getLineSeparator() + e.getClass().getName() + this.getLineSeparator();
            msg = String.valueOf(msg) + e.getMessage() + this.getLineSeparator();
            SQLException nextEx = e.getNextException();
            if (nextEx != null) {
                msg = String.valueOf(msg) + this.getLineSeparator();
                msg = String.valueOf(msg) + "[NextException]" + this.getLineSeparator();
                msg = String.valueOf(msg) + nextEx.getClass().getName() + this.getLineSeparator();
                msg = String.valueOf(msg) + nextEx.getMessage() + this.getLineSeparator();
                SQLException nextNextEx = nextEx.getNextException();
                if (nextNextEx != null) {
                    msg = String.valueOf(msg) + this.getLineSeparator();
                    msg = String.valueOf(msg) + "[NextNextException]" + this.getLineSeparator();
                    msg = String.valueOf(msg) + nextNextEx.getClass().getName() + this.getLineSeparator();
                    msg = String.valueOf(msg) + nextNextEx.getMessage() + this.getLineSeparator();
                }
            }
            if ((invokeName = this.extractBehaviorInvokeName()) != null) {
                msg = String.valueOf(msg) + this.getLineSeparator();
                msg = String.valueOf(msg) + "[Behavior]" + this.getLineSeparator();
                msg = String.valueOf(msg) + invokeName + this.getLineSeparator();
            }
            if (this.hasConditionBean()) {
                msg = String.valueOf(msg) + this.getLineSeparator();
                msg = String.valueOf(msg) + "[ConditionBean]" + this.getLineSeparator();
                msg = String.valueOf(msg) + this.getConditionBean().getClass().getName() + this.getLineSeparator();
            }
            if (this.hasOutsideSqlContext()) {
                msg = String.valueOf(msg) + this.getLineSeparator();
                msg = String.valueOf(msg) + "[OutsideSql]" + this.getLineSeparator();
                msg = String.valueOf(msg) + this.getOutsideSqlContext().getOutsideSqlPath() + this.getLineSeparator();
                msg = String.valueOf(msg) + this.getLineSeparator();
                msg = String.valueOf(msg) + "[ParameterBean]" + this.getLineSeparator();
                Object pmb = this.getOutsideSqlContext().getParameterBean();
                if (pmb != null) {
                    msg = String.valueOf(msg) + pmb.getClass().getName() + this.getLineSeparator();
                    msg = String.valueOf(msg) + pmb + this.getLineSeparator();
                } else {
                    msg = String.valueOf(msg) + pmb + this.getLineSeparator();
                }
            }
            if (statement != null) {
                msg = String.valueOf(msg) + this.getLineSeparator();
                msg = String.valueOf(msg) + "[Statement]" + this.getLineSeparator();
                msg = String.valueOf(msg) + statement.getClass().getName() + this.getLineSeparator();
            }
            if (completeSql != null) {
                msg = String.valueOf(msg) + this.getLineSeparator();
                msg = String.valueOf(msg) + "[Display SQL]" + this.getLineSeparator();
                msg = String.valueOf(msg) + completeSql + this.getLineSeparator();
            }
            msg = String.valueOf(msg) + "* * * * * * * * * */";
            throw new SQLFailureException(msg, e);
        }

        protected String extractSQLState(SQLException e) {
            String sqlState = e.getSQLState();
            if (sqlState != null) {
                return sqlState;
            }
            SQLException nextEx = e.getNextException();
            if (nextEx == null) {
                return null;
            }
            sqlState = nextEx.getSQLState();
            if (sqlState != null) {
                return sqlState;
            }
            SQLException nextNextEx = nextEx.getNextException();
            if (nextNextEx == null) {
                return null;
            }
            sqlState = nextNextEx.getSQLState();
            if (sqlState != null) {
                return sqlState;
            }
            SQLException nextNextNextEx = nextNextEx.getNextException();
            if (nextNextNextEx == null) {
                return null;
            }
            sqlState = nextNextNextEx.getSQLState();
            if (sqlState != null) {
                return sqlState;
            }
            return null;
        }

        protected String extractBehaviorInvokeName() {
            Object behaviorInvokeName = InternalMapContext.getObject("df:BehaviorInvokeName");
            if (behaviorInvokeName == null) {
                return null;
            }
            Object clientInvokeName = InternalMapContext.getObject("df:ClientInvokeName");
            Object byPassInvokeName = InternalMapContext.getObject("df:ByPassInvokeName");
            StringBuilder sb = new StringBuilder();
            boolean existsPath = false;
            if (clientInvokeName != null) {
                existsPath = true;
                sb.append(clientInvokeName);
            }
            if (byPassInvokeName != null) {
                existsPath = true;
                sb.append(byPassInvokeName);
            }
            sb.append(behaviorInvokeName);
            if (existsPath) {
                sb.append("...");
            }
            return sb.toString();
        }

        protected boolean hasConditionBean() {
            return ConditionBeanContext.isExistConditionBeanOnThread();
        }

        protected ConditionBean getConditionBean() {
            return ConditionBeanContext.getConditionBeanOnThread();
        }

        protected boolean hasOutsideSqlContext() {
            return OutsideSqlContext.isExistOutsideSqlContextOnThread();
        }

        protected OutsideSqlContext getOutsideSqlContext() {
            return OutsideSqlContext.getOutsideSqlContextOnThread();
        }

        protected String getLineSeparator() {
            return SimpleSystemUtil.getLineSeparator();
        }
    }
}

