/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.ea2ddl.dao.allcommon.s2dao.internal.sqlhandler;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.sql.DataSource;
import jp.sourceforge.ea2ddl.dao.allcommon.s2dao.internal.sqlhandler.InternalBasicHandler;
import org.seasar.dao.BeanMetaData;
import org.seasar.extension.jdbc.PropertyType;
import org.seasar.extension.jdbc.StatementFactory;
import org.seasar.extension.jdbc.ValueType;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.util.IntegerConversionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InternalAbstractAutoHandler
extends InternalBasicHandler {
    protected BeanMetaData beanMetaData;
    protected Object[] bindVariables;
    protected ValueType[] bindVariableValueTypes;
    protected Timestamp timestamp;
    protected Integer versionNo;
    protected PropertyType[] propertyTypes;
    protected boolean versionNoAutoIncrementOnMemory = true;

    public InternalAbstractAutoHandler(DataSource dataSource, StatementFactory statementFactory, BeanMetaData beanMetaData, PropertyType[] propertyTypes) {
        super(dataSource, statementFactory);
        this.beanMetaData = beanMetaData;
        this.propertyTypes = propertyTypes;
    }

    public int execute(Object[] args) {
        Connection connection = this.getConnection();
        try {
            int n = this.execute(connection, args[0]);
            return n;
        }
        finally {
            this.close(connection);
        }
    }

    public int execute(Object[] args, Class<?>[] argTypes) {
        return this.execute(args);
    }

    protected int execute(Connection connection, Object bean) {
        this.preUpdateBean(bean);
        this.setupBindVariables(bean);
        this.logSql(this.bindVariables, this.getArgTypes(this.bindVariables));
        PreparedStatement ps = this.prepareStatement(connection);
        int ret = -1;
        try {
            this.bindArgs(ps, this.bindVariables, this.bindVariableValueTypes);
            ret = this.executeUpdate(ps);
        }
        finally {
            this.close(ps);
        }
        this.postUpdateBean(bean, ret);
        return ret;
    }

    protected void bindArgs(PreparedStatement ps, Object[] args, ValueType[] valueTypes) {
        if (args == null) {
            return;
        }
        int i = 0;
        while (i < args.length) {
            ValueType valueType = valueTypes[i];
            try {
                valueType.bindValue(ps, i + 1, args[i]);
            }
            catch (SQLException e) {
                this.handleSQLException(e, ps);
            }
            ++i;
        }
    }

    protected void preUpdateBean(Object bean) {
    }

    protected void postUpdateBean(Object bean, int ret) {
    }

    protected abstract void setupBindVariables(Object var1);

    protected void setupInsertBindVariables(Object bean) {
        ArrayList<Object> varList = new ArrayList<Object>();
        ArrayList<ValueType> varValueTypeList = new ArrayList<ValueType>();
        BeanMetaData bmd = this.getBeanMetaData();
        String timestampPropertyName = bmd.getTimestampPropertyName();
        String versionNoPropertyName = bmd.getVersionNoPropertyName();
        int i = 0;
        while (i < this.propertyTypes.length) {
            PropertyType pt = this.propertyTypes[i];
            if (pt.getPropertyName().equalsIgnoreCase(timestampPropertyName)) {
                this.setTimestamp(new Timestamp(new Date().getTime()));
                varList.add(this.getTimestamp());
            } else if (pt.getPropertyName().equalsIgnoreCase(versionNoPropertyName)) {
                this.setVersionNo(new Integer(0));
                varList.add(this.getVersionNo());
            } else {
                varList.add(pt.getPropertyDesc().getValue(bean));
            }
            varValueTypeList.add(pt.getValueType());
            ++i;
        }
        this.setBindVariables(varList.toArray());
        this.setBindVariableValueTypes(varValueTypeList.toArray(new ValueType[varValueTypeList.size()]));
    }

    protected void setupUpdateBindVariables(Object bean) {
        ArrayList<Object> varList = new ArrayList<Object>();
        ArrayList<ValueType> varValueTypeList = new ArrayList<ValueType>();
        BeanMetaData bmd = this.getBeanMetaData();
        String timestampPropertyName = bmd.getTimestampPropertyName();
        String versionNoPropertyName = bmd.getVersionNoPropertyName();
        int i = 0;
        while (i < this.propertyTypes.length) {
            block4: {
                PropertyType pt;
                block2: {
                    block3: {
                        Object value;
                        block1: {
                            pt = this.propertyTypes[i];
                            if (!pt.getPropertyName().equalsIgnoreCase(timestampPropertyName)) break block1;
                            this.setTimestamp(new Timestamp(new Date().getTime()));
                            varList.add(this.getTimestamp());
                            break block2;
                        }
                        if (!pt.getPropertyName().equalsIgnoreCase(versionNoPropertyName)) break block3;
                        if (!this.isVersionNoAutoIncrementOnMemory() || (value = pt.getPropertyDesc().getValue(bean)) == null) break block4;
                        int intValue = IntegerConversionUtil.toPrimitiveInt((Object)value) + 1;
                        this.setVersionNo(new Integer(intValue));
                        varList.add(this.getVersionNo());
                        break block2;
                    }
                    varList.add(pt.getPropertyDesc().getValue(bean));
                }
                varValueTypeList.add(pt.getValueType());
            }
            ++i;
        }
        this.addAutoUpdateWhereBindVariables(varList, varValueTypeList, bean);
        this.setBindVariables(varList.toArray());
        this.setBindVariableValueTypes(varValueTypeList.toArray(new ValueType[varValueTypeList.size()]));
    }

    protected void setupDeleteBindVariables(Object bean) {
        ArrayList<Object> varList = new ArrayList<Object>();
        ArrayList<ValueType> varValueTypeList = new ArrayList<ValueType>();
        this.addAutoUpdateWhereBindVariables(varList, varValueTypeList, bean);
        this.setBindVariables(varList.toArray());
        this.setBindVariableValueTypes(varValueTypeList.toArray(new ValueType[varValueTypeList.size()]));
    }

    protected void addAutoUpdateWhereBindVariables(List<Object> varList, List<ValueType> varValueTypeList, Object bean) {
        PropertyDesc pd;
        BeanMetaData bmd = this.getBeanMetaData();
        int i = 0;
        while (i < bmd.getPrimaryKeySize()) {
            PropertyType pt = bmd.getPropertyTypeByColumnName(bmd.getPrimaryKey(i));
            PropertyDesc pd2 = pt.getPropertyDesc();
            varList.add(pd2.getValue(bean));
            varValueTypeList.add(pt.getValueType());
            ++i;
        }
        if (bmd.hasVersionNoPropertyType()) {
            PropertyType pt = bmd.getVersionNoPropertyType();
            pd = pt.getPropertyDesc();
            varList.add(pd.getValue(bean));
            varValueTypeList.add(pt.getValueType());
        }
        if (bmd.hasTimestampPropertyType()) {
            PropertyType pt = bmd.getTimestampPropertyType();
            pd = pt.getPropertyDesc();
            varList.add(pd.getValue(bean));
            varValueTypeList.add(pt.getValueType());
        }
    }

    protected void updateTimestampIfNeed(Object bean) {
        if (this.getTimestamp() != null) {
            PropertyDesc pd = this.getBeanMetaData().getTimestampPropertyType().getPropertyDesc();
            pd.setValue(bean, (Object)this.getTimestamp());
        }
    }

    protected void updateVersionNoIfNeed(Object bean) {
        if (this.getVersionNo() != null) {
            PropertyDesc pd = this.getBeanMetaData().getVersionNoPropertyType().getPropertyDesc();
            pd.setValue(bean, (Object)this.getVersionNo());
        }
    }

    public BeanMetaData getBeanMetaData() {
        return this.beanMetaData;
    }

    protected Object[] getBindVariables() {
        return this.bindVariables;
    }

    protected void setBindVariables(Object[] bindVariables) {
        this.bindVariables = bindVariables;
    }

    protected ValueType[] getBindVariableValueTypes() {
        return this.bindVariableValueTypes;
    }

    protected void setBindVariableValueTypes(ValueType[] bindVariableValueTypes) {
        this.bindVariableValueTypes = bindVariableValueTypes;
    }

    protected Timestamp getTimestamp() {
        return this.timestamp;
    }

    protected void setTimestamp(Timestamp timestamp) {
        this.timestamp = timestamp;
    }

    protected Integer getVersionNo() {
        return this.versionNo;
    }

    protected void setVersionNo(Integer versionNo) {
        this.versionNo = versionNo;
    }

    protected PropertyType[] getPropertyTypes() {
        return this.propertyTypes;
    }

    protected void setPropertyTypes(PropertyType[] propertyTypes) {
        this.propertyTypes = propertyTypes;
    }

    protected boolean isVersionNoAutoIncrementOnMemory() {
        return this.versionNoAutoIncrementOnMemory;
    }

    public void setVersionNoAutoIncrementOnMemory(boolean versionNoAutoIncrementOnMemory) {
        this.versionNoAutoIncrementOnMemory = versionNoAutoIncrementOnMemory;
    }
}

