/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.ea2ddl.dao.allcommon.s2dao.internal.sqlcommand;

import javax.sql.DataSource;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.outsidesql.OutsideSqlContext;
import jp.sourceforge.ea2ddl.dao.allcommon.s2dao.internal.sqlhandler.InternalProcedureHandler;
import jp.sourceforge.ea2ddl.dao.allcommon.s2dao.internal.various.InternalProcedureMetaData;
import org.seasar.dao.SqlCommand;
import org.seasar.extension.jdbc.ResultSetHandler;
import org.seasar.extension.jdbc.StatementFactory;

public class InternalProcedureCommand
implements SqlCommand {
    protected DataSource dataSource;
    protected ResultSetHandler resultSetHandler;
    protected StatementFactory statementFactory;
    protected InternalProcedureMetaData procedureMetaData;

    public InternalProcedureCommand(DataSource dataSource, ResultSetHandler resultSetHandler, StatementFactory statementFactory, InternalProcedureMetaData procedureMetaData) {
        this.dataSource = dataSource;
        this.resultSetHandler = resultSetHandler;
        this.statementFactory = statementFactory;
        this.procedureMetaData = procedureMetaData;
    }

    public Object execute(Object[] args) {
        InternalProcedureHandler handler = this.newArgumentDtoProcedureHandler();
        OutsideSqlContext outsideSqlContext = OutsideSqlContext.getOutsideSqlContextOnThread();
        Object pmb = outsideSqlContext.getParameterBean();
        return handler.execute(new Object[]{pmb});
    }

    protected InternalProcedureHandler newArgumentDtoProcedureHandler() {
        return new InternalProcedureHandler(this.dataSource, this.createSql(this.procedureMetaData), this.resultSetHandler, this.statementFactory, this.procedureMetaData);
    }

    protected String createSql(InternalProcedureMetaData procedureMetaData) {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        int size = procedureMetaData.parameterTypes().size();
        if (procedureMetaData.hasReturnParameterType()) {
            sb.append("? = ");
            --size;
        }
        sb.append("call ").append(procedureMetaData.getProcedureName()).append("(");
        int i = 0;
        while (i < size) {
            sb.append("?, ");
            ++i;
        }
        if (size > 0) {
            sb.setLength(sb.length() - 2);
        }
        sb.append(")}");
        return sb.toString();
    }
}

