/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.ea2ddl.dao.allcommon.s2dao;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import jp.sourceforge.ea2ddl.dao.allcommon.Entity;
import jp.sourceforge.ea2ddl.dao.allcommon.InternalMapContext;
import jp.sourceforge.ea2ddl.dao.allcommon.XLog;
import jp.sourceforge.ea2ddl.dao.allcommon.annotation.OutsideSql;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.ConditionBean;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.ConditionBeanContext;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.FetchNarrowingBean;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.FetchNarrowingBeanContext;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.outsidesql.OutsideSqlContext;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.outsidesql.OutsideSqlDao;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.outsidesql.OutsideSqlOption;
import jp.sourceforge.ea2ddl.dao.allcommon.dbmeta.DBMeta;
import jp.sourceforge.ea2ddl.dao.allcommon.dbmeta.DBMetaInstanceHandler;
import jp.sourceforge.ea2ddl.dao.allcommon.exception.EntityAlreadyUpdatedException;
import jp.sourceforge.ea2ddl.dao.allcommon.helper.stacktrace.InvokeNameExtractingResource;
import jp.sourceforge.ea2ddl.dao.allcommon.helper.stacktrace.InvokeNameResult;
import jp.sourceforge.ea2ddl.dao.allcommon.helper.stacktrace.impl.InvokeNameExtractorImpl;
import jp.sourceforge.ea2ddl.dao.allcommon.util.TraceViewUtil;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.dao.DaoMetaData;
import org.seasar.dao.DaoMetaDataFactory;
import org.seasar.dao.NotSingleRowUpdatedRuntimeException;
import org.seasar.dao.SqlCommand;
import org.seasar.framework.aop.interceptors.AbstractInterceptor;
import org.seasar.framework.beans.MethodNotFoundRuntimeException;
import org.seasar.framework.util.NumberConversionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class S2DaoInterceptor
extends AbstractInterceptor {
    private static final long serialVersionUID = 1L;
    private static final Log _log = LogFactory.getLog(S2DaoInterceptor.class);
    protected DaoMetaDataFactory _daoMetaDataFactory;

    public S2DaoInterceptor(DaoMetaDataFactory daoMetaDataFactory) {
        this._daoMetaDataFactory = daoMetaDataFactory;
    }

    protected void log(String msg) {
        XLog.log(msg);
    }

    protected boolean isLogEnabled() {
        return XLog.isLogEnabled();
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        this.clearThreadLocal();
        try {
            Object object = this.dispatchInvoking(invocation);
            return object;
        }
        finally {
            this.clearThreadLocal();
        }
    }

    protected Object dispatchInvoking(MethodInvocation invocation) throws Throwable {
        SqlCommand cmd;
        Method method = invocation.getMethod();
        if (!this.isAbstract(method)) {
            return invocation.proceed();
        }
        if (method.getName().equals("initializeDaoMetaData")) {
            this.initializeSqlCommand(invocation);
            return null;
        }
        this.preprocessOutsideSql(invocation);
        ConditionBean cb = this.preprocessConditionBean(invocation);
        try {
            long afterCmd;
            long beforeCmd = 0L;
            if (this.isLogEnabled()) {
                beforeCmd = System.currentTimeMillis();
            }
            cmd = this.findSqlCommand(invocation);
            if (this.isLogEnabled() && beforeCmd != (afterCmd = System.currentTimeMillis())) {
                this.logSqlCommand(invocation, cmd, beforeCmd, afterCmd);
            }
        }
        finally {
            if (this.isLogEnabled()) {
                this.logInvocation(invocation);
            }
        }
        long before = 0L;
        if (this.isLogEnabled()) {
            before = System.currentTimeMillis();
        }
        Object ret = null;
        try {
            try {
                ret = cmd.execute(invocation.getArguments());
            }
            catch (Exception e) {
                if (e.getClass().equals(NotSingleRowUpdatedRuntimeException.class)) {
                    throw new EntityAlreadyUpdatedException((NotSingleRowUpdatedRuntimeException)e);
                }
                throw e;
            }
        }
        finally {
            this.postprocessConditionBean(invocation, cb);
        }
        Class<?> retType = method.getReturnType();
        this.assertRetType(retType, ret);
        if (this.isLogEnabled()) {
            long after = System.currentTimeMillis();
            this.logReturn(invocation, retType, ret, before, after);
        }
        if (retType.isPrimitive()) {
            return NumberConversionUtil.convertPrimitiveWrapper(retType, (Object)ret);
        }
        if (Number.class.isAssignableFrom(retType)) {
            return NumberConversionUtil.convertNumber(retType, (Object)ret);
        }
        return ret;
    }

    protected void initializeSqlCommand(MethodInvocation invocation) {
        Class targetType = this.getTargetClass(invocation);
        DaoMetaData dmd = this._daoMetaDataFactory.getDaoMetaData(targetType);
        if (OutsideSqlDao.class.isAssignableFrom(targetType)) {
            return;
        }
        Object[] arguments = invocation.getArguments();
        if (arguments != null && arguments.length > 0 && arguments[0] instanceof String) {
            block4: {
                String methodName = (String)arguments[0];
                try {
                    dmd.getSqlCommand(methodName);
                }
                catch (MethodNotFoundRuntimeException ignored) {
                    if (!this.isLogEnabled()) break block4;
                    this.log("Not Found the method: " + methodName + " msg=" + ignored.getMessage());
                }
            }
            return;
        }
        String msg = "The method should have one string argument as method name: " + invocation;
        throw new IllegalStateException(msg);
    }

    protected SqlCommand findSqlCommand(MethodInvocation invocation) {
        Class targetType = this.getTargetClass(invocation);
        DaoMetaData dmd = this._daoMetaDataFactory.getDaoMetaData(targetType);
        SqlCommand cmd = OutsideSqlDao.class.isAssignableFrom(targetType) ? dmd.getSqlCommand(this.generateSpecifiedOutsideSqlUniqueKey(invocation)) : dmd.getSqlCommand(invocation.getMethod().getName());
        return cmd;
    }

    protected String generateSpecifiedOutsideSqlUniqueKey(MethodInvocation invocation) {
        Object[] args = invocation.getArguments();
        String path = (String)args[0];
        Object pmb = args[1];
        OutsideSqlOption option = (OutsideSqlOption)args[2];
        Object resultTypeSpecification = null;
        if (args.length > 3) {
            resultTypeSpecification = args[3];
        }
        return OutsideSqlContext.generateSpecifiedOutsideSqlUniqueKey(invocation.getMethod().getName(), path, pmb, option, resultTypeSpecification);
    }

    protected void logInvocation(MethodInvocation invocation) {
        OutsideSqlContext outsideSqlContext;
        String invokeMethodName;
        String invokeClassName;
        StackTraceElement[] stackTrace = new Exception().getStackTrace();
        InvokeNameResult behaviorResult = this.extractBehaviorInvokeName(stackTrace);
        if (!behaviorResult.isEmptyResult()) {
            invokeClassName = behaviorResult.getSimpleClassName();
            invokeMethodName = behaviorResult.getMethodName();
        } else {
            Method method = invocation.getMethod();
            invokeClassName = this.extractInvocationExpression(method);
            invokeMethodName = method.getName();
        }
        String expWithoutKakko = this.buildInvocationExpressionWithoutKakko(invocation, invokeClassName, invokeMethodName);
        this.putObjectToMapContext("df:BehaviorInvokeName", String.valueOf(expWithoutKakko) + "()");
        String equalBorder = this.buildFitBorder("", "=", expWithoutKakko, false);
        String invocationExpression = String.valueOf(expWithoutKakko) + "()";
        this.log("/=====================================================" + equalBorder + "==");
        this.log("                                                      " + invocationExpression);
        this.log("                                                      " + equalBorder + "=/");
        this.logPath(invocation, stackTrace, behaviorResult);
        if (this.isSpecifiedOutsideSql(invocation) && !(outsideSqlContext = this.getOutsideSqlContext()).isProcedure()) {
            Object[] args = invocation.getArguments();
            if (outsideSqlContext != null) {
                this.log("path: " + outsideSqlContext.getOutsideSqlPath());
            } else {
                this.log("path: " + this.getOutsideSqlPath(args));
            }
            this.log("option: " + this.getOutsideSqlOption(args));
        }
    }

    protected String buildInvocationExpressionWithoutKakko(MethodInvocation invocation, String invokeClassName, String invokeMethodName) {
        if (invokeClassName.contains("OutsideSql") && invokeClassName.endsWith("Executor")) {
            try {
                String originalName = invokeClassName;
                if (this.isSpecifiedOutsideSql()) {
                    OutsideSqlContext outsideSqlContext = this.getOutsideSqlContext();
                    String tableDbName = outsideSqlContext.getTableDbName();
                    DBMeta dbmeta = DBMetaInstanceHandler.findDBMeta(tableDbName);
                    String behaviorTypeName = dbmeta.getBehaviorTypeName();
                    String behaviorClassName = behaviorTypeName.substring(behaviorTypeName.lastIndexOf(".") + ".".length());
                    invokeClassName = String.valueOf(behaviorClassName) + ".outsideSql()";
                    if (originalName.endsWith("OutsideSqlEntityExecutor")) {
                        invokeClassName = String.valueOf(invokeClassName) + ".entityHandling()";
                    } else if (originalName.endsWith("OutsideSqlPagingExecutor")) {
                        invokeClassName = outsideSqlContext.isOffsetByCursorForcedly() || outsideSqlContext.isLimitByCursorForcedly() ? String.valueOf(invokeClassName) + ".autoPaging()" : String.valueOf(invokeClassName) + ".manualPaging()";
                    } else if (originalName.endsWith("OutsideSqlCursorExecutor")) {
                        invokeClassName = String.valueOf(invokeClassName) + ".cursorHandling()";
                    }
                } else {
                    invokeClassName = "OutsideSql";
                }
            }
            catch (RuntimeException ignored) {
                this.log("Ignored exception occurred: msg=" + ignored.getMessage());
            }
        }
        String invocationExpressionWithoutKakko = String.valueOf(invokeClassName) + "." + invokeMethodName;
        if ("selectPage".equals(invokeMethodName)) {
            Class resultType;
            OutsideSqlContext outsideSqlContext;
            Object resultTypeSpecification;
            boolean resultTypeInteger = false;
            if (this.isSpecifiedOutsideSql() && (resultTypeSpecification = (outsideSqlContext = this.getOutsideSqlContext()).getResultTypeSpecification()) != null && resultTypeSpecification instanceof Class && Integer.class.isAssignableFrom(resultType = (Class)resultTypeSpecification)) {
                resultTypeInteger = true;
            }
            invocationExpressionWithoutKakko = resultTypeInteger || "selectCount".equals(invocation.getMethod().getName()) ? String.valueOf(invocationExpressionWithoutKakko) + "():count" : String.valueOf(invocationExpressionWithoutKakko) + "():paging";
        }
        return invocationExpressionWithoutKakko;
    }

    protected void logPath(MethodInvocation invocation, StackTraceElement[] stackTrace, InvokeNameResult behaviorResult) {
        int bhvNextIndex = behaviorResult.getNextStartIndex();
        InvokeNameResult clientResult = this.extractClientInvokeName(stackTrace, bhvNextIndex);
        int clientFirstIndex = clientResult.getFoundFirstIndex();
        InvokeNameResult byPassResult = this.extractByPassInvokeName(stackTrace, bhvNextIndex, clientFirstIndex - bhvNextIndex);
        String clientInvokeName = clientResult.getInvokeName();
        String byPassInvokeName = byPassResult.getInvokeName();
        String behaviorInvokeName = behaviorResult.getInvokeName();
        if (clientInvokeName.trim().length() == 0 && byPassInvokeName.trim().length() == 0) {
            return;
        }
        if (!clientResult.isEmptyResult()) {
            this.putObjectToMapContext("df:ClientInvokeName", clientInvokeName);
        }
        if (!byPassResult.isEmptyResult()) {
            this.putObjectToMapContext("df:ByPassInvokeName", byPassInvokeName);
        }
        this.log(String.valueOf(clientInvokeName) + byPassInvokeName + behaviorInvokeName + "...");
    }

    protected String buildFitBorder(String prefix, String element, String lengthTargetString, boolean space) {
        int length = space ? lengthTargetString.length() / 2 : lengthTargetString.length();
        StringBuffer sb = new StringBuffer();
        sb.append(prefix);
        int i = 0;
        while (i < length) {
            sb.append(element);
            if (space) {
                sb.append(" ");
            }
            ++i;
        }
        if (space) {
            sb.append(element);
        }
        return sb.toString();
    }

    protected InvokeNameResult extractClientInvokeName(StackTraceElement[] stackTrace, final int startIndex) {
        final List<String> suffixList = Arrays.asList("Page", "Action");
        InvokeNameExtractingResource resource = new InvokeNameExtractingResource(){

            public boolean isTargetElement(String className, String methodName) {
                return S2DaoInterceptor.this.isClassNameEndsWith(className, suffixList);
            }

            public String filterSimpleClassName(String simpleClassName) {
                return simpleClassName;
            }

            public boolean isUseAdditionalInfo() {
                return true;
            }

            public int getStartIndex() {
                return startIndex;
            }

            public int getLoopSize() {
                return 25;
            }
        };
        return this.extractInvokeName(resource, stackTrace);
    }

    protected InvokeNameResult extractByPassInvokeName(StackTraceElement[] stackTrace, final int startIndex, final int loopSize) {
        final List<String> suffixList = Arrays.asList("Service", "ServiceImpl", "Facade", "FacadeImpl");
        InvokeNameExtractingResource resource = new InvokeNameExtractingResource(){

            public boolean isTargetElement(String className, String methodName) {
                return S2DaoInterceptor.this.isClassNameEndsWith(className, suffixList);
            }

            public String filterSimpleClassName(String simpleClassName) {
                return simpleClassName;
            }

            public boolean isUseAdditionalInfo() {
                return true;
            }

            public int getStartIndex() {
                return startIndex;
            }

            public int getLoopSize() {
                return loopSize >= 0 ? loopSize : 25;
            }
        };
        return this.extractInvokeName(resource, stackTrace);
    }

    protected InvokeNameResult extractBehaviorInvokeName(StackTraceElement[] stackTrace) {
        final List<String> suffixList = Arrays.asList("Bhv", "BehaviorReadable", "BehaviorWritable", "PagingInvoker");
        final List<String> keywordList = Arrays.asList("Bhv$", "BehaviorReadable$", "BehaviorWritable$");
        final List<String> ousideSql1List = Arrays.asList("OutsideSql");
        final List<String> ousideSql2List = Arrays.asList("Executor");
        final List<String> ousideSql3List = Arrays.asList("Executor$");
        InvokeNameExtractingResource resource = new InvokeNameExtractingResource(){

            public boolean isTargetElement(String className, String methodName) {
                if (S2DaoInterceptor.this.isClassNameEndsWith(className, suffixList)) {
                    return true;
                }
                if (S2DaoInterceptor.this.isClassNameContains(className, keywordList)) {
                    return true;
                }
                return S2DaoInterceptor.this.isClassNameContains(className, ousideSql1List) && (S2DaoInterceptor.this.isClassNameEndsWith(className, ousideSql2List) || S2DaoInterceptor.this.isClassNameContains(className, ousideSql3List));
            }

            public String filterSimpleClassName(String simpleClassName) {
                return S2DaoInterceptor.this.removeBasePrefixFromSimpleClassName(simpleClassName);
            }

            public boolean isUseAdditionalInfo() {
                return false;
            }

            public int getStartIndex() {
                return 0;
            }

            public int getLoopSize() {
                return 25;
            }
        };
        return this.extractInvokeName(resource, stackTrace);
    }

    protected boolean isClassNameEndsWith(String className, List<String> suffixList) {
        for (String suffix : suffixList) {
            if (!className.endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    protected boolean isClassNameContains(String className, List<String> keywordList) {
        for (String keyword : keywordList) {
            if (!className.contains(keyword)) continue;
            return true;
        }
        return false;
    }

    protected InvokeNameResult extractInvokeName(InvokeNameExtractingResource resource, StackTraceElement[] stackTrace) {
        InvokeNameExtractorImpl extractor = new InvokeNameExtractorImpl();
        extractor.setStackTrace(stackTrace);
        return extractor.extractInvokeName(resource);
    }

    protected String extractInvocationExpression(Method method) {
        Class<?> declaringClass = method.getDeclaringClass();
        return this.removeBasePrefixFromSimpleClassName(declaringClass.getSimpleName());
    }

    protected String removeBasePrefixFromSimpleClassName(String simpleClassName) {
        if (!simpleClassName.startsWith("Bs")) {
            return simpleClassName;
        }
        int prefixLength = "Bs".length();
        if (!Character.isUpperCase(simpleClassName.substring(prefixLength).charAt(0))) {
            return simpleClassName;
        }
        if (simpleClassName.length() <= prefixLength) {
            return simpleClassName;
        }
        return simpleClassName.substring(prefixLength);
    }

    protected void logSqlCommand(MethodInvocation invocation, SqlCommand cmd, long beforeCmd, long afterCmd) {
        this.log("SqlCommand Initialization Cost: [" + TraceViewUtil.convertToPerformanceView(afterCmd - beforeCmd) + "]");
    }

    protected void assertRetType(Class<?> retType, Object ret) {
        if (List.class.isAssignableFrom(retType)) {
            if (ret != null && !(ret instanceof List)) {
                String msg = "The retType is difference from actual return: ";
                msg = String.valueOf(msg) + "retType=" + retType + " ret.getClass()=" + ret.getClass() + " ref=" + ret;
                throw new IllegalStateException(msg);
            }
        } else if (Entity.class.isAssignableFrom(retType) && ret != null && !(ret instanceof Entity)) {
            String msg = "The retType is difference from actual return: ";
            msg = String.valueOf(msg) + "retType=" + retType + " ret.getClass()=" + ret.getClass() + " ref=" + ret;
            throw new IllegalStateException(msg);
        }
    }

    protected void logReturn(MethodInvocation invocation, Class<?> retType, Object ret, long before, long after) throws Throwable {
        try {
            String daoResultPrefix = "===========/ [" + TraceViewUtil.convertToPerformanceView(after - before) + " - ";
            if (List.class.isAssignableFrom(retType)) {
                if (ret == null) {
                    this.log(String.valueOf(daoResultPrefix) + "Selected list: null]");
                } else {
                    List ls = (List)ret;
                    if (ls.isEmpty()) {
                        this.log(String.valueOf(daoResultPrefix) + "Selected list: 0]");
                    } else if (ls.size() == 1 && ls.get(0) instanceof Number) {
                        this.log(String.valueOf(daoResultPrefix) + "Selected count: " + ls.get(0) + "]");
                    } else {
                        this.log(String.valueOf(daoResultPrefix) + "Selected list: " + ls.size() + " first=" + ls.get(0) + "]");
                    }
                }
            } else if (Entity.class.isAssignableFrom(retType)) {
                if (ret == null) {
                    this.log(String.valueOf(daoResultPrefix) + "Selected entity: null" + "]");
                } else {
                    Entity entity = (Entity)ret;
                    this.log(String.valueOf(daoResultPrefix) + "Selected entity: " + entity + "]");
                }
            } else if (Entity.class.isAssignableFrom(retType)) {
                if (ret == null) {
                    this.log(String.valueOf(daoResultPrefix) + "Selected entity: null" + "]");
                } else {
                    Entity entity = (Entity)ret;
                    this.log(String.valueOf(daoResultPrefix) + "Selected entity: " + entity + "]");
                }
            } else if (int[].class.isAssignableFrom(retType)) {
                if (ret == null) {
                    this.log(String.valueOf(daoResultPrefix) + "Selected entity: null" + "]");
                } else {
                    int[] resultArray = (int[])ret;
                    if (resultArray.length == 0) {
                        this.log(String.valueOf(daoResultPrefix) + "All updated count: 0]");
                    } else {
                        StringBuilder sb = new StringBuilder();
                        boolean resultExpressionScope = true;
                        int resultCount = 0;
                        int loopCount = 0;
                        int[] nArray = resultArray;
                        int n = resultArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            int element = nArray[n2];
                            resultCount += element;
                            if (resultExpressionScope) {
                                if (loopCount <= 10) {
                                    if (sb.length() == 0) {
                                        sb.append(element);
                                    } else {
                                        sb.append(",").append(element);
                                    }
                                } else {
                                    sb.append(",").append("...");
                                    resultExpressionScope = false;
                                }
                            }
                            ++loopCount;
                            ++n2;
                        }
                        sb.insert(0, "{").append("}");
                        this.log(String.valueOf(daoResultPrefix) + "All updated count: " + resultCount + " result=" + sb + "]");
                    }
                }
            } else if (this.isSelectCountIgnoreFetchScopeMethod(invocation)) {
                this.log(String.valueOf(daoResultPrefix) + "Selected count: " + ret + "]");
            } else {
                this.log(String.valueOf(daoResultPrefix) + "Result: " + ret + "]");
            }
            this.log(" ");
        }
        catch (Exception e) {
            String msg = "Result object debug threw the exception: methodName=";
            msg = String.valueOf(msg) + invocation.getMethod().getName() + " retType=" + retType;
            msg = String.valueOf(msg) + " ret=" + ret;
            _log.warn((Object)msg, (Throwable)e);
            throw e;
        }
    }

    protected void preprocessOutsideSql(MethodInvocation invocation) {
        Class<OutsideSql> outsideSqlType = OutsideSql.class;
        OutsideSql outsideSql = invocation.getMethod().getAnnotation(outsideSqlType);
        if (outsideSql != null && (outsideSql.dynamicBinding() || outsideSql.offsetByCursor() || outsideSql.offsetByCursor() || outsideSql.limitByCursor())) {
            OutsideSqlContext outsideSqlContext = new OutsideSqlContext();
            outsideSqlContext.setDynamicBinding(outsideSql.dynamicBinding());
            outsideSqlContext.setOffsetByCursorForcedly(outsideSql.offsetByCursor());
            outsideSqlContext.setLimitByCursorForcedly(outsideSql.limitByCursor());
            OutsideSqlContext.setOutsideSqlContextOnThread(outsideSqlContext);
            Object[] args = invocation.getArguments();
            if (args == null || args.length == 0) {
                return;
            }
            if (FetchNarrowingBeanContext.isTheTypeFetchNarrowingBean(args[0].getClass())) {
                FetchNarrowingBeanContext.setFetchNarrowingBeanOnThread((FetchNarrowingBean)args[0]);
            }
            return;
        }
        if (this.isSpecifiedOutsideSql(invocation)) {
            if (this.isOutsideSqlDaoMethodSelect(invocation)) {
                this.setupOutsideSqlContextSelect(invocation);
            } else {
                this.setupOutsideSqlContextExecute(invocation);
            }
            return;
        }
    }

    protected boolean isSpecifiedOutsideSql(MethodInvocation invocation) {
        return OutsideSqlDao.class.isAssignableFrom(this.getTargetClass(invocation));
    }

    protected boolean isOutsideSqlDaoMethodSelect(MethodInvocation invocation) {
        return invocation.getMethod().getName().startsWith("select");
    }

    protected void setupOutsideSqlContextSelect(MethodInvocation invocation) {
        Object[] args = invocation.getArguments();
        if (args.length != 4) {
            String msg = "Internal Error! OutsideSqlDao.selectXxx() should have 4 arguements: args.length=" + args.length;
            throw new IllegalStateException(msg);
        }
        String path = this.getOutsideSqlPath(args);
        Object pmb = this.getOutsideSqlParameterBean(args);
        OutsideSqlOption option = this.getOutsideSqlOption(args);
        Object resultTypeSpecification = args[3];
        OutsideSqlContext outsideSqlContext = new OutsideSqlContext();
        outsideSqlContext.setDynamicBinding(option.isDynamicBinding());
        outsideSqlContext.setOffsetByCursorForcedly(option.isAutoPaging());
        outsideSqlContext.setLimitByCursorForcedly(option.isAutoPaging());
        outsideSqlContext.setOutsideSqlPath(path);
        outsideSqlContext.setParameterBean(pmb);
        outsideSqlContext.setResultTypeSpecification(resultTypeSpecification);
        outsideSqlContext.setMethodName(invocation.getMethod().getName());
        outsideSqlContext.setStatementConfig(option.getStatementConfig());
        outsideSqlContext.setTableDbName(option.getTableDbName());
        outsideSqlContext.setupBehaviorQueryPathIfNeeds();
        OutsideSqlContext.setOutsideSqlContextOnThread(outsideSqlContext);
        this.setupOutsideSqlFetchNarrowingBean(pmb, option);
    }

    protected void setupOutsideSqlContextExecute(MethodInvocation invocation) {
        Object[] args = invocation.getArguments();
        if (args.length != 3) {
            String msg = "Internal Error! OutsideSqlDao.execute() should have 3 arguements: args.length=" + args.length;
            throw new IllegalStateException(msg);
        }
        String path = this.getOutsideSqlPath(args);
        Object pmb = this.getOutsideSqlParameterBean(args);
        OutsideSqlOption option = this.getOutsideSqlOption(args);
        OutsideSqlContext outsideSqlContext = new OutsideSqlContext();
        outsideSqlContext.setDynamicBinding(option.isDynamicBinding());
        outsideSqlContext.setOffsetByCursorForcedly(option.isAutoPaging());
        outsideSqlContext.setLimitByCursorForcedly(option.isAutoPaging());
        outsideSqlContext.setOutsideSqlPath(path);
        outsideSqlContext.setParameterBean(pmb);
        outsideSqlContext.setMethodName(invocation.getMethod().getName());
        outsideSqlContext.setStatementConfig(option.getStatementConfig());
        outsideSqlContext.setTableDbName(option.getTableDbName());
        outsideSqlContext.setupBehaviorQueryPathIfNeeds();
        OutsideSqlContext.setOutsideSqlContextOnThread(outsideSqlContext);
        this.setupOutsideSqlFetchNarrowingBean(pmb, option);
    }

    protected String getOutsideSqlPath(Object[] args) {
        return (String)args[0];
    }

    protected Object getOutsideSqlParameterBean(Object[] args) {
        return args[1];
    }

    protected OutsideSqlOption getOutsideSqlOption(Object[] args) {
        return (OutsideSqlOption)args[2];
    }

    protected void setupOutsideSqlFetchNarrowingBean(Object pmb, OutsideSqlOption option) {
        if (pmb == null || !FetchNarrowingBeanContext.isTheTypeFetchNarrowingBean(pmb.getClass())) {
            return;
        }
        FetchNarrowingBean fetchNarrowingBean = (FetchNarrowingBean)pmb;
        if (option.isManualPaging()) {
            fetchNarrowingBean.ignoreFetchNarrowing();
        }
        FetchNarrowingBeanContext.setFetchNarrowingBeanOnThread(fetchNarrowingBean);
    }

    protected ConditionBean preprocessConditionBean(MethodInvocation invocation) {
        OutsideSqlContext outsideSqlContext = this.getOutsideSqlContext();
        if (outsideSqlContext != null) {
            return null;
        }
        Object[] args = invocation.getArguments();
        if (args == null || args.length == 0) {
            return null;
        }
        Object arg0 = args[0];
        if (arg0 == null) {
            return null;
        }
        if (!ConditionBeanContext.isTheTypeConditionBean(arg0.getClass())) {
            if (FetchNarrowingBeanContext.isTheTypeFetchNarrowingBean(arg0.getClass()) && !this.isSelectCountIgnoreFetchScopeMethod(invocation)) {
                FetchNarrowingBeanContext.setFetchNarrowingBeanOnThread((FetchNarrowingBean)arg0);
            }
            return null;
        }
        ConditionBean cb = (ConditionBean)arg0;
        if (this.isSelectCountIgnoreFetchScopeMethod(invocation)) {
            cb.xsetupSelectCountIgnoreFetchScope();
        } else {
            FetchNarrowingBeanContext.setFetchNarrowingBeanOnThread(cb);
        }
        ConditionBeanContext.setConditionBeanOnThread(cb);
        return cb;
    }

    protected void postprocessConditionBean(MethodInvocation invocation, ConditionBean cb) {
        if (cb == null) {
            return;
        }
        if (this.isSelectCountIgnoreFetchScopeMethod(invocation)) {
            cb.xafterCareSelectCountIgnoreFetchScope();
        }
    }

    protected void clearThreadLocal() {
        if (OutsideSqlContext.isExistOutsideSqlContextOnThread()) {
            OutsideSqlContext.clearOutsideSqlContextOnThread();
        }
        if (FetchNarrowingBeanContext.isExistFetchNarrowingBeanOnThread()) {
            FetchNarrowingBeanContext.getFetchNarrowingBeanOnThread().restoreIgnoredFetchNarrowing();
            FetchNarrowingBeanContext.clearFetchNarrowingBeanOnThread();
        }
        if (ConditionBeanContext.isExistConditionBeanOnThread()) {
            ConditionBeanContext.clearConditionBeanOnThread();
        }
        if (InternalMapContext.isExistInternalMapContextOnThread()) {
            InternalMapContext.clearInternalMapContextOnThread();
        }
    }

    protected OutsideSqlContext getOutsideSqlContext() {
        if (!OutsideSqlContext.isExistOutsideSqlContextOnThread()) {
            return null;
        }
        return OutsideSqlContext.getOutsideSqlContextOnThread();
    }

    protected boolean isSpecifiedOutsideSql() {
        OutsideSqlContext outsideSqlContext = this.getOutsideSqlContext();
        return outsideSqlContext != null && outsideSqlContext.isSpecifiedOutsideSql();
    }

    protected void putObjectToMapContext(String key, Object value) {
        InternalMapContext.setObject(key, value);
    }

    protected boolean isSelectCountIgnoreFetchScopeMethod(MethodInvocation invocation) {
        String name = invocation.getMethod().getName();
        return name.startsWith("readCount") || name.startsWith("selectCount");
    }

    public boolean isAbstract(Method method) {
        int mod = method.getModifiers();
        return Modifier.isAbstract(mod);
    }

    protected String getLineSeparator() {
        return System.getProperty("line.separator");
    }
}

