/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.ea2ddl.dao.allcommon.s2dao;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import jp.sourceforge.ea2ddl.dao.allcommon.s2dao.internal.sqlhandler.InternalBasicHandler;
import org.seasar.extension.jdbc.ResultSetFactory;

public class FetchNarrowingResultSetFactory
implements ResultSetFactory {
    public ResultSet getResultSet(Statement statement) {
        return this.doGetResultSet(statement);
    }

    public ResultSet createResultSet(PreparedStatement ps) {
        return this.executeQuery(ps);
    }

    protected ResultSet doGetResultSet(Statement statement) {
        try {
            return statement.getResultSet();
        }
        catch (SQLException e) {
            this.handleSQLException(e, statement);
            return null;
        }
    }

    protected ResultSet executeQuery(PreparedStatement ps) {
        try {
            return ps.executeQuery();
        }
        catch (SQLException e) {
            this.handleSQLException(e, ps);
            return null;
        }
    }

    protected void handleSQLException(SQLException e, Statement statement) {
        new InternalBasicHandler.SQLExceptionHandler().handleSQLException(e, statement);
    }
}

