/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.ea2ddl.dao.allcommon.helper.token.line.impl;

import java.util.ArrayList;
import java.util.List;
import jp.sourceforge.ea2ddl.dao.allcommon.helper.token.line.LineMakingOption;
import jp.sourceforge.ea2ddl.dao.allcommon.helper.token.line.LineToken;
import jp.sourceforge.ea2ddl.dao.allcommon.helper.token.line.LineTokenizingOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LineTokenImpl
implements LineToken {
    @Override
    public List<String> tokenize(String lineString, LineTokenizingOption lineTokenizingOption) {
        String delimiter = lineTokenizingOption.getDelimiter();
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        int j = lineString.indexOf(delimiter);
        int h = 0;
        while (j >= 0) {
            String pureValue = lineString.substring(i, j);
            if (lineTokenizingOption.isTrimDoubleQuotation()) {
                String before = pureValue;
                if (before.length() > 1 && before.startsWith("\"") && before.endsWith("\"")) {
                    String after = before.substring(1, before.length() - 1);
                    list.add(this.filterHandlingEmptyAsNull(after, lineTokenizingOption));
                } else {
                    list.add(this.filterHandlingEmptyAsNull(before, lineTokenizingOption));
                }
            } else {
                list.add(this.filterHandlingEmptyAsNull(pureValue, lineTokenizingOption));
            }
            i = j + 1;
            j = lineString.indexOf(delimiter, i);
            ++h;
        }
        list.add(this.filterHandlingEmptyAsNull(lineString.substring(i), lineTokenizingOption));
        return list;
    }

    protected String filterHandlingEmptyAsNull(String target, LineTokenizingOption lineTokenizingOption) {
        if (target == null) {
            return null;
        }
        if (lineTokenizingOption.isHandleEmtpyAsNull() && "".equals(target)) {
            return null;
        }
        return target;
    }

    @Override
    public String make(List<String> valueList, LineMakingOption lineMakingOption) {
        this.assertObjectNotNull("valueList", valueList);
        this.assertObjectNotNull("lineMakingOption", lineMakingOption);
        String delimiter = lineMakingOption.getDelimiter();
        this.assertObjectNotNull("lineMakingOption.getDelimiter()", delimiter);
        return this.createLineString(valueList, delimiter, lineMakingOption.isQuoteByDoubleQuotation(), lineMakingOption.isTrimSpace());
    }

    protected String createLineString(List<String> valueList, String delimiter, boolean quoteByDoubleQuotation, boolean trimSpace) {
        StringBuffer sb = new StringBuffer();
        for (String value : valueList) {
            String string = value = value != null ? value : "";
            if (trimSpace) {
                value = value.trim();
            }
            if (quoteByDoubleQuotation) {
                sb.append(delimiter).append("\"").append(value).append("\"");
                continue;
            }
            sb.append(delimiter).append(value);
        }
        sb.delete(0, delimiter.length());
        return sb.toString();
    }

    protected void assertObjectNotNull(String variableName, Object value) {
        if (variableName == null) {
            String msg = "The value should not be null: variableName=" + variableName + " value=" + value;
            throw new IllegalArgumentException(msg);
        }
        if (value == null) {
            String msg = "The value should not be null: variableName=" + variableName;
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertStringNotNullAndNotTrimmedEmpty(String variableName, String value) {
        this.assertObjectNotNull("variableName", variableName);
        this.assertObjectNotNull(variableName, value);
        if (value.trim().length() == 0) {
            String msg = "The value should not be empty: variableName=" + variableName + " value=" + value;
            throw new IllegalArgumentException(msg);
        }
    }
}

