/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.ea2ddl.dao.allcommon.dbmeta.info;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.sourceforge.ea2ddl.dao.allcommon.dbmeta.DBMeta;
import jp.sourceforge.ea2ddl.dao.allcommon.dbmeta.info.ColumnInfo;
import jp.sourceforge.ea2ddl.dao.allcommon.dbmeta.info.RelationInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForeignInfo
implements RelationInfo {
    protected String foreignPropertyName;
    protected DBMeta localDBMeta;
    protected DBMeta foreignDBMeta;
    protected Map<ColumnInfo, ColumnInfo> localForeignColumnInfoMap;
    protected Map<ColumnInfo, ColumnInfo> foreignLocalColumnInfoMap;
    protected int relationNo;
    protected boolean oneToOne;

    public ColumnInfo findLocalByForeign(String foreignColumnDbName) {
        ColumnInfo keyColumnInfo = new ColumnInfo(this.foreignDBMeta, foreignColumnDbName);
        ColumnInfo resultColumnInfo = this.foreignLocalColumnInfoMap.get(keyColumnInfo);
        if (resultColumnInfo == null) {
            String msg = "Not found by foreignColumnDbName in foreignLocalColumnInfoMap:";
            msg = String.valueOf(msg) + " foreignColumnDbName=" + foreignColumnDbName + " foreignLocalColumnInfoMap=" + this.foreignLocalColumnInfoMap;
            throw new IllegalArgumentException(msg);
        }
        return resultColumnInfo;
    }

    public String buildInitCapPropertyName() {
        return this.initCap(this.foreignPropertyName);
    }

    public Method findSetter() {
        return this.findMethod(this.localDBMeta.getEntityType(), "set" + this.buildInitCapPropertyName(), new Class[]{List.class});
    }

    public Method findGetter() {
        return this.findMethod(this.localDBMeta.getEntityType(), "get" + this.buildInitCapPropertyName(), new Class[0]);
    }

    @Override
    public String getRelationPropertyName() {
        return this.getForeignPropertyName();
    }

    @Override
    public DBMeta getTargetDBMeta() {
        return this.getForeignDBMeta();
    }

    @Override
    public Map<ColumnInfo, ColumnInfo> getLocalTargetColumnInfoMap() {
        return this.getLocalForeignColumnInfoMap();
    }

    @Override
    public boolean isReferrer() {
        return false;
    }

    public String getForeignPropertyName() {
        return this.foreignPropertyName;
    }

    public void setForeignPropertyName(String foreignPropertyName) {
        this.foreignPropertyName = foreignPropertyName;
    }

    @Override
    public DBMeta getLocalDBMeta() {
        return this.localDBMeta;
    }

    public void setLocalDBMeta(DBMeta localDBMeta) {
        this.localDBMeta = localDBMeta;
    }

    public DBMeta getForeignDBMeta() {
        return this.foreignDBMeta;
    }

    public void setForeignDBMeta(DBMeta foreignDBMeta) {
        this.foreignDBMeta = foreignDBMeta;
    }

    public Map<ColumnInfo, ColumnInfo> getLocalForeignColumnInfoMap() {
        return this.localForeignColumnInfoMap;
    }

    public void setLocalForeignColumnInfoMap(Map<ColumnInfo, ColumnInfo> localForeignColumnInfoMap) {
        this.localForeignColumnInfoMap = localForeignColumnInfoMap;
        Set<ColumnInfo> keySet = localForeignColumnInfoMap.keySet();
        this.foreignLocalColumnInfoMap = new LinkedHashMap<ColumnInfo, ColumnInfo>();
        for (ColumnInfo key : keySet) {
            ColumnInfo value = localForeignColumnInfoMap.get(key);
            this.foreignLocalColumnInfoMap.put(value, key);
        }
    }

    public Map<ColumnInfo, ColumnInfo> getForeignLocalColumnInfoMap() {
        return this.foreignLocalColumnInfoMap;
    }

    public int getRelationNo() {
        return this.relationNo;
    }

    public void setRelationNo(int relationNo) {
        this.relationNo = relationNo;
    }

    @Override
    public boolean isOneToOne() {
        return this.oneToOne;
    }

    public void setOneToOne(boolean oneToOne) {
        this.oneToOne = oneToOne;
    }

    protected Method findMethod(Class clazz, String methodName, Class[] argTypes) {
        try {
            return clazz.getMethod(methodName, argTypes);
        }
        catch (NoSuchMethodException ex) {
            String msg = "class=" + clazz + " method=" + methodName + "-" + Arrays.asList(argTypes);
            throw new RuntimeException(msg, ex);
        }
    }

    protected String initCap(String name) {
        return String.valueOf(name.substring(0, 1).toUpperCase()) + name.substring(1);
    }
}

