/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.ea2ddl.dao.allcommon.dbmeta;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.sourceforge.ea2ddl.dao.allcommon.Entity;
import jp.sourceforge.ea2ddl.dao.allcommon.dbmeta.DBMeta;
import jp.sourceforge.ea2ddl.dao.allcommon.dbmeta.info.ColumnInfo;
import jp.sourceforge.ea2ddl.dao.allcommon.dbmeta.info.ForeignInfo;
import jp.sourceforge.ea2ddl.dao.allcommon.dbmeta.info.ReferrerInfo;
import jp.sourceforge.ea2ddl.dao.allcommon.dbmeta.info.RelationInfo;
import jp.sourceforge.ea2ddl.dao.allcommon.dbmeta.info.UniqueInfo;
import jp.sourceforge.ea2ddl.dao.allcommon.helper.MapListString;
import jp.sourceforge.ea2ddl.dao.allcommon.helper.MapListStringImpl;
import jp.sourceforge.ea2ddl.dao.allcommon.helper.MapStringBuilder;
import jp.sourceforge.ea2ddl.dao.allcommon.helper.MapStringBuilderImpl;
import jp.sourceforge.ea2ddl.dao.allcommon.util.SimpleAssertUtil;
import jp.sourceforge.ea2ddl.dao.allcommon.util.SimpleStringUtil;
import jp.sourceforge.ea2ddl.dao.allcommon.util.SimpleSystemUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDBMeta
implements DBMeta {
    protected List<ColumnInfo> _columnInfoList;
    private Set<String> _cachedMethodNames = new HashSet<String>();

    @Override
    public boolean hasColumn(String columnFlexibleName) {
        if (!this.hasFlexibleName(columnFlexibleName)) {
            return false;
        }
        String propertyName = this.findPropertyName(columnFlexibleName);
        return this.hasMethod("column" + this.initCap(propertyName));
    }

    @Override
    public ColumnInfo findColumnInfo(String columnFlexibleName) {
        this.assertStringNotNullAndNotTrimmedEmpty("columnFlexibleName", columnFlexibleName);
        if (!this.hasColumn(columnFlexibleName)) {
            String msg = "Not found column by columnFlexibleName: " + columnFlexibleName;
            msg = String.valueOf(msg) + " tableName=" + this.getTableDbName();
            throw new IllegalArgumentException(msg);
        }
        String methodName = "column" + this.initCap(this.findPropertyName(columnFlexibleName));
        Method method = null;
        try {
            method = this.getClass().getMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            String msg = "Not found column by columnFlexibleName: " + columnFlexibleName;
            msg = String.valueOf(msg) + " tableName=" + this.getTableDbName() + " methodName=" + methodName;
            throw new RuntimeException(msg, e);
        }
        try {
            return (ColumnInfo)method.invoke((Object)this, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    protected ColumnInfo cci(String columnDbName, String propertyName, Class<?> propertyType, boolean primary, Integer columnSize, Integer columnDecimalDigits) {
        return new ColumnInfo(this, columnDbName, propertyName, propertyType, primary, columnSize, columnDecimalDigits);
    }

    protected ColumnInfo cci(String columnDbName, String propertyName, Class<?> propertyType, boolean primary, Integer columnSize, Integer columnDecimalDigits, DBMeta.OptimisticLockType optimisticLockType) {
        return new ColumnInfo(this, columnDbName, propertyName, propertyType, primary, columnSize, columnDecimalDigits, optimisticLockType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ColumnInfo> getColumnInfoList() {
        if (this._columnInfoList != null) {
            return this._columnInfoList;
        }
        AbstractDBMeta abstractDBMeta = this;
        synchronized (abstractDBMeta) {
            if (this._columnInfoList != null) {
                return this._columnInfoList;
            }
            Method[] methods = this.getClass().getMethods();
            this._columnInfoList = this.newArrayList();
            String prefix = "column";
            Class<ColumnInfo> returnType = ColumnInfo.class;
            Object[] args = new Object[]{};
            try {
                Method[] methodArray = methods;
                int n = methods.length;
                int n2 = 0;
                while (n2 < n) {
                    Method method = methodArray[n2];
                    if (method.getName().startsWith(prefix) && returnType.equals(method.getReturnType())) {
                        this._columnInfoList.add((ColumnInfo)method.invoke((Object)this, args));
                    }
                    ++n2;
                }
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            return this._columnInfoList;
        }
    }

    protected void initializeColumnInfoList() {
        this.getColumnInfoList();
    }

    @Override
    public boolean hasFlexibleName(String flexibleName) {
        String key = flexibleName.toLowerCase();
        if (this.getDbNamePropertyNameKeyToLowerMap().containsKey(key)) {
            return true;
        }
        return this.getPropertyNameDbNameKeyToLowerMap().containsKey(key);
    }

    @Override
    public String findDbName(String flexibleName) {
        String key = flexibleName.toLowerCase();
        if (this.getPropertyNameDbNameKeyToLowerMap().containsKey(key)) {
            return this.getPropertyNameDbNameKeyToLowerMap().get(key);
        }
        if (this.getDbNamePropertyNameKeyToLowerMap().containsKey(key)) {
            String dbNameKeyToLower = this.getDbNamePropertyNameKeyToLowerMap().get(key).toLowerCase();
            if (this.getPropertyNameDbNameKeyToLowerMap().containsKey(dbNameKeyToLower)) {
                return this.getPropertyNameDbNameKeyToLowerMap().get(dbNameKeyToLower);
            }
        }
        String msg = "Not found object by the flexible name: flexibleName=" + flexibleName;
        throw new IllegalStateException(msg);
    }

    @Override
    public String findPropertyName(String flexibleName) {
        String key = flexibleName.toLowerCase();
        if (this.getDbNamePropertyNameKeyToLowerMap().containsKey(key)) {
            return this.getDbNamePropertyNameKeyToLowerMap().get(key);
        }
        if (this.getPropertyNameDbNameKeyToLowerMap().containsKey(key)) {
            String dbNameToLower = this.getPropertyNameDbNameKeyToLowerMap().get(key).toLowerCase();
            if (this.getDbNamePropertyNameKeyToLowerMap().containsKey(dbNameToLower)) {
                return this.getDbNamePropertyNameKeyToLowerMap().get(dbNameToLower);
            }
        }
        String msg = "Not found object by the flexible name: flexibleName=" + flexibleName;
        throw new IllegalStateException(msg);
    }

    protected UniqueInfo createPrimaryUniqueInfo() {
        UniqueInfo uniqueInfo = new UniqueInfo();
        uniqueInfo.setDBMeta(this);
        uniqueInfo.setPrimary(true);
        return uniqueInfo;
    }

    protected UniqueInfo createPrimaryUniqueInfo(ColumnInfo uniqueColumnInfo) {
        UniqueInfo uniqueInfo = new UniqueInfo();
        uniqueInfo.setDBMeta(this);
        uniqueInfo.setPrimary(true);
        uniqueInfo.addUniqueColumnList(uniqueColumnInfo);
        return uniqueInfo;
    }

    @Override
    public RelationInfo findRelationInfo(String relationPropertyName) {
        this.assertStringNotNullAndNotTrimmedEmpty("relationPropertyName", relationPropertyName);
        return this.hasForeign(relationPropertyName) ? this.findForeignInfo(relationPropertyName) : this.findReferrerInfo(relationPropertyName);
    }

    @Override
    public boolean hasForeign(String foreignPropertyName) {
        this.assertStringNotNullAndNotTrimmedEmpty("foreignPropertyName", foreignPropertyName);
        String methodName = this.buildRelationInfoGetterMethodNameInitCap("foreign", foreignPropertyName);
        return this.hasMethod(methodName);
    }

    @Override
    public DBMeta findForeignDBMeta(String foreignPropertyName) {
        return this.findForeignInfo(foreignPropertyName).getForeignDBMeta();
    }

    @Override
    public ForeignInfo findForeignInfo(String foreignPropertyName) {
        this.assertStringNotNullAndNotTrimmedEmpty("foreignPropertyName", foreignPropertyName);
        String methodName = this.buildRelationInfoGetterMethodNameInitCap("foreign", foreignPropertyName);
        Method method = null;
        try {
            method = this.getClass().getMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            String msg = "Not found foreign by foreignPropertyName: foreignPropertyName=" + foreignPropertyName;
            msg = String.valueOf(msg) + " tableName=" + this.getTableDbName() + " methodName=" + methodName;
            throw new RuntimeException(msg, e);
        }
        try {
            return (ForeignInfo)method.invoke((Object)this, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    protected ForeignInfo cfi(String propName, DBMeta localDbm, DBMeta foreignDbm, Map<ColumnInfo, ColumnInfo> localForeignColumnInfoMap, int relNo, boolean oneToOne) {
        ForeignInfo foreignInfo = new ForeignInfo();
        foreignInfo.setForeignPropertyName(propName);
        foreignInfo.setLocalDBMeta(localDbm);
        foreignInfo.setForeignDBMeta(foreignDbm);
        foreignInfo.setLocalForeignColumnInfoMap(localForeignColumnInfoMap);
        foreignInfo.setRelationNo(relNo);
        foreignInfo.setOneToOne(oneToOne);
        return foreignInfo;
    }

    @Override
    public boolean hasReferrer(String referrerPropertyName) {
        this.assertStringNotNullAndNotTrimmedEmpty("referrerPropertyName", referrerPropertyName);
        String methodName = this.buildRelationInfoGetterMethodNameInitCap("referrer", referrerPropertyName);
        return this.hasMethod(methodName);
    }

    @Override
    public DBMeta findReferrerDBMeta(String referrerPropertyName) {
        this.assertStringNotNullAndNotTrimmedEmpty("referrerPropertyName", referrerPropertyName);
        return this.findReferrerInfo(referrerPropertyName).getReferrerDBMeta();
    }

    @Override
    public ReferrerInfo findReferrerInfo(String referrerPropertyName) {
        this.assertStringNotNullAndNotTrimmedEmpty("referrerPropertyName", referrerPropertyName);
        String methodName = this.buildRelationInfoGetterMethodNameInitCap("referrer", referrerPropertyName);
        Method method = null;
        try {
            method = this.getClass().getMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            String msg = "Not found referrer by referrerPropertyName: referrerPropertyName=" + referrerPropertyName;
            msg = String.valueOf(msg) + " tableName=" + this.getTableDbName() + " methodName=" + methodName;
            throw new RuntimeException(msg, e);
        }
        try {
            return (ReferrerInfo)method.invoke((Object)this, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    protected ReferrerInfo cri(String propName, DBMeta localDbm, DBMeta referrerDbm, Map<ColumnInfo, ColumnInfo> localReferrerColumnInfoMap, boolean oneToOne) {
        ReferrerInfo referrerInfo = new ReferrerInfo();
        referrerInfo.setReferrerPropertyName(propName);
        referrerInfo.setLocalDBMeta(localDbm);
        referrerInfo.setReferrerDBMeta(referrerDbm);
        referrerInfo.setLocalReferrerColumnInfoMap(localReferrerColumnInfoMap);
        referrerInfo.setOneToOne(oneToOne);
        return referrerInfo;
    }

    protected String buildRelationInfoGetterMethodNameInitCap(String targetName, String relationPropertyName) {
        return String.valueOf(targetName) + relationPropertyName.substring(0, 1).toUpperCase() + relationPropertyName.substring(1);
    }

    @Override
    public MapListString createMapListString() {
        return MapStringUtil.createMapListString();
    }

    @Override
    public MapStringBuilder createMapStringBuilder() {
        ArrayList<String> columnDbNameList = new ArrayList<String>();
        for (ColumnInfo columnInfo : this.getColumnInfoList()) {
            columnDbNameList.add(columnInfo.getColumnDbName());
        }
        return MapStringUtil.createMapStringBuilder(columnDbNameList);
    }

    @Override
    public boolean hasSequence() {
        return false;
    }

    @Override
    public String getSequenceNextValSql() {
        return null;
    }

    @Override
    public boolean hasVersionNo() {
        return false;
    }

    @Override
    public ColumnInfo getVersionNoColumnInfo() {
        return null;
    }

    @Override
    public boolean hasUpdateDate() {
        return false;
    }

    @Override
    public ColumnInfo getUpdateDateColumnInfo() {
        return null;
    }

    @Override
    public boolean hasCommonColumn() {
        return false;
    }

    protected <ENTITY extends Entity> void doAcceptPrimaryKeyMap(ENTITY entity, Map<String, ? extends Object> columnValueMap, Map<String, DBMeta.Eps<ENTITY>> entityPropertySetupperMap) {
        MapAssertUtil.assertColumnValueMapNotNullAndNotEmpty(columnValueMap);
        MapStringValueAnalyzer analyzer = new MapStringValueAnalyzer(columnValueMap, entity.getModifiedPropertyNames());
        List<ColumnInfo> columnInfoList = this.getPrimaryUniqueInfo().getUniqueColumnList();
        for (ColumnInfo columnInfo : columnInfoList) {
            String columnName = columnInfo.getColumnDbName();
            String propertyName = columnInfo.getPropertyName();
            String uncapPropName = this.initUncap(propertyName);
            Class<?> propertyType = columnInfo.getPropertyType();
            if (!analyzer.init(columnName, uncapPropName, propertyName)) continue;
            Object value = String.class.isAssignableFrom(propertyType) ? analyzer.analyzeString(propertyType) : (Number.class.isAssignableFrom(propertyType) ? analyzer.analyzeNumber(propertyType) : (Date.class.isAssignableFrom(propertyType) ? analyzer.analyzeDate(propertyType) : analyzer.analyzeOther(propertyType)));
            this.findEps(entityPropertySetupperMap, propertyName).setup(entity, value);
        }
    }

    protected <ENTITY extends Entity> void doAcceptColumnValueMap(ENTITY entity, Map<String, ? extends Object> columnValueMap, Map<String, DBMeta.Eps<ENTITY>> entityPropertySetupperMap) {
        MapAssertUtil.assertColumnValueMapNotNullAndNotEmpty(columnValueMap);
        MapStringValueAnalyzer analyzer = new MapStringValueAnalyzer(columnValueMap, entity.getModifiedPropertyNames());
        List<ColumnInfo> columnInfoList = this.getColumnInfoList();
        for (ColumnInfo columnInfo : columnInfoList) {
            String columnName = columnInfo.getColumnDbName();
            String propertyName = columnInfo.getPropertyName();
            String uncapPropName = this.initUncap(propertyName);
            Class<?> propertyType = columnInfo.getPropertyType();
            if (!analyzer.init(columnName, uncapPropName, propertyName)) continue;
            Object value = String.class.isAssignableFrom(propertyType) ? analyzer.analyzeString(propertyType) : (Number.class.isAssignableFrom(propertyType) ? analyzer.analyzeNumber(propertyType) : (Date.class.isAssignableFrom(propertyType) ? analyzer.analyzeDate(propertyType) : analyzer.analyzeOther(propertyType)));
            this.findEps(entityPropertySetupperMap, propertyName).setup(entity, value);
        }
    }

    protected String doExtractPrimaryKeyMapString(Entity entity, String startBrace, String endBrace, String delimiter, String equal) {
        String mapMarkAndStartBrace = "map:" + startBrace;
        StringBuilder sb = new StringBuilder();
        List<ColumnInfo> columnInfoList = this.getPrimaryUniqueInfo().getUniqueColumnList();
        try {
            for (ColumnInfo columnInfo : columnInfoList) {
                String columnName = columnInfo.getColumnDbName();
                Method getterMethod = columnInfo.findGetter();
                Object value = getterMethod.invoke((Object)entity, null);
                this.helpAppendingColumnValueString(sb, delimiter, equal, columnName, value);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        sb.delete(0, delimiter.length()).insert(0, mapMarkAndStartBrace).append(endBrace);
        return sb.toString();
    }

    protected String doExtractColumnValueMapString(Entity entity, String startBrace, String endBrace, String delimiter, String equal) {
        String mapMarkAndStartBrace = "map:" + startBrace;
        StringBuilder sb = new StringBuilder();
        List<ColumnInfo> columnInfoList = this.getColumnInfoList();
        try {
            for (ColumnInfo columnInfo : columnInfoList) {
                String columnName = columnInfo.getColumnDbName();
                Method getterMethod = columnInfo.findGetter();
                Object value = getterMethod.invoke((Object)entity, null);
                this.helpAppendingColumnValueString(sb, delimiter, equal, columnName, value);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        sb.delete(0, delimiter.length()).insert(0, mapMarkAndStartBrace).append(endBrace);
        return sb.toString();
    }

    protected Map<String, Object> doConvertToColumnValueMap(Entity entity) {
        Map valueMap = this.newLinkedHashMap();
        try {
            List<ColumnInfo> columnInfoList = this.getColumnInfoList();
            for (ColumnInfo columnInfo : columnInfoList) {
                String columnName = columnInfo.getColumnDbName();
                Method getterMethod = columnInfo.findGetter();
                Object value = getterMethod.invoke((Object)entity, null);
                valueMap.put(columnName, value);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return valueMap;
    }

    protected Map<String, String> doConvertToColumnStringValueMap(Entity entity) {
        Map valueMap = this.newLinkedHashMap();
        try {
            List<ColumnInfo> columnInfoList = this.getColumnInfoList();
            for (ColumnInfo columnInfo : columnInfoList) {
                String columnName = columnInfo.getColumnDbName();
                Method getterMethod = columnInfo.findGetter();
                Object value = getterMethod.invoke((Object)entity, null);
                valueMap.put(columnName, this.helpGettingColumnStringValue(value));
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return valueMap;
    }

    protected <ENTITY extends Entity> void setupEps(Map<String, DBMeta.Eps<ENTITY>> entityPropertySetupperMap, DBMeta.Eps<ENTITY> setupper, ColumnInfo columnInfo) {
        String columnName = columnInfo.getColumnDbName();
        String propertyName = columnInfo.getPropertyName();
        this.registerEntityPropertySetupper(columnName, propertyName, setupper, entityPropertySetupperMap);
    }

    protected <ENTITY extends Entity> void registerEntityPropertySetupper(String columnName, String propertyName, DBMeta.Eps<ENTITY> setupper, Map<String, DBMeta.Eps<ENTITY>> entityPropertySetupperMap) {
        entityPropertySetupperMap.put(columnName, setupper);
        entityPropertySetupperMap.put(propertyName, setupper);
        entityPropertySetupperMap.put(columnName.toLowerCase(), setupper);
        entityPropertySetupperMap.put(propertyName.toLowerCase(), setupper);
    }

    protected <ENTITY extends Entity> DBMeta.Eps<ENTITY> findEps(Map<String, DBMeta.Eps<ENTITY>> entityPropertySetupperMap, String propertyName) {
        DBMeta.Eps<ENTITY> setupper = entityPropertySetupperMap.get(propertyName);
        if (setupper == null) {
            String msg = "The propertyName was Not Found in the map of setupper of entity property:";
            msg = String.valueOf(msg) + " propertyName=" + propertyName + " _entityPropertySetupperMap.keySet()=" + entityPropertySetupperMap.keySet();
            throw new IllegalStateException(msg);
        }
        return setupper;
    }

    protected <ENTITY> ENTITY downcast(Entity entity) {
        this.checkDowncast(entity);
        return (ENTITY)entity;
    }

    protected void checkDowncast(Entity entity) {
        this.assertObjectNotNull("entity", entity);
        Class<? extends Entity> entityType = this.getEntityType();
        Class<?> targetType = entity.getClass();
        if (!entityType.isAssignableFrom(targetType)) {
            String name = entityType.getSimpleName();
            String msg = "The entity should be " + name + " but it was: " + targetType;
            throw new IllegalStateException(msg);
        }
    }

    protected void helpAppendingColumnValueString(StringBuilder sb, String delimiter, String equal, String colName, Object value) {
        sb.append(delimiter).append(colName).append(equal);
        sb.append(this.helpGettingColumnStringValue(value));
    }

    protected String helpGettingColumnStringValue(Object value) {
        if (value instanceof Timestamp) {
            return value != null ? this.helpFormatingTimestamp((Timestamp)value) : "";
        }
        if (value instanceof Date) {
            return value != null ? this.helpFormatingDate((Date)value) : "";
        }
        return value != null ? value.toString() : "";
    }

    protected String helpFormatingDate(Date date) {
        return MapStringUtil.formatDate(date);
    }

    protected String helpFormatingTimestamp(Timestamp timestamp) {
        return MapStringUtil.formatTimestamp(timestamp);
    }

    protected Map<String, String> setupKeyToLowerMap(boolean dbNameKey) {
        Map map = dbNameKey ? (Map)this.newLinkedHashMap(this.getTableDbName().toLowerCase(), this.getTablePropertyName()) : (Map)this.newLinkedHashMap(this.getTablePropertyName().toLowerCase(), this.getTableDbName());
        Method[] methods = this.getClass().getMethods();
        String columnInfoMethodPrefix = "column";
        try {
            Method[] methodArray = methods;
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                String name = method.getName();
                if (name.startsWith(columnInfoMethodPrefix)) {
                    ColumnInfo columnInfo = (ColumnInfo)method.invoke((Object)this, new Object[0]);
                    String dbName = columnInfo.getColumnDbName();
                    String propertyName = columnInfo.getPropertyName();
                    if (dbNameKey) {
                        map.put(dbName.toLowerCase(), propertyName);
                    } else {
                        map.put(propertyName.toLowerCase(), dbName);
                    }
                }
                ++n2;
            }
            return Collections.unmodifiableMap(map);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    protected final String replaceString(String text, String fromText, String toText) {
        return SimpleStringUtil.replace(text, fromText, toText);
    }

    protected String initCap(String str) {
        return SimpleStringUtil.initCap(str);
    }

    protected String initUncap(String str) {
        return SimpleStringUtil.initUncap(str);
    }

    protected String getLineSeparator() {
        return SimpleSystemUtil.getLineSeparator();
    }

    protected <KEY, VALUE> HashMap<KEY, VALUE> newHashMap() {
        return new HashMap();
    }

    protected <KEY, VALUE> LinkedHashMap<KEY, VALUE> newLinkedHashMap() {
        return new LinkedHashMap();
    }

    protected <KEY, VALUE> LinkedHashMap<KEY, VALUE> newLinkedHashMap(KEY key, VALUE value) {
        LinkedHashMap<KEY, VALUE> map = this.newLinkedHashMap();
        map.put(key, value);
        return map;
    }

    protected <ELEMENT> ArrayList<ELEMENT> newArrayList() {
        return new ArrayList();
    }

    protected <ELEMENT> ArrayList<ELEMENT> newArrayList(Collection<ELEMENT> collection) {
        return new ArrayList<ELEMENT>(collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasMethod(String methodName) {
        this.assertStringNotNullAndNotTrimmedEmpty("methodName", methodName);
        if (this._cachedMethodNames.isEmpty()) {
            Set<String> set = this._cachedMethodNames;
            synchronized (set) {
                if (this._cachedMethodNames.isEmpty()) {
                    Method[] methods;
                    Method[] methodArray = methods = this.getClass().getMethods();
                    int n = methods.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Method method = methodArray[n2];
                        this._cachedMethodNames.add(method.getName());
                        ++n2;
                    }
                }
            }
        }
        return this._cachedMethodNames.contains(methodName);
    }

    protected void assertObjectNotNull(String variableName, Object value) {
        SimpleAssertUtil.assertObjectNotNull(variableName, value);
    }

    protected void assertStringNotNullAndNotTrimmedEmpty(String variableName, String value) {
        SimpleAssertUtil.assertStringNotNullAndNotTrimmedEmpty(variableName, value);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class AbstractRelationTrace
    implements DBMeta.RelationTrace {
        protected List<RelationInfo> _relationList;
        protected List<AbstractRelationTrace> _relationTraceList;
        protected List<RelationInfo> _traceRelationInfoList;
        protected ColumnInfo _traceColumnInfo;
        protected DBMeta.RelationTraceFixHandler _relationTraceFixHandler;

        public AbstractRelationTrace(DBMeta.RelationTraceFixHandler relationTraceFixHandler) {
            this(new ArrayList<RelationInfo>(), new ArrayList<AbstractRelationTrace>());
            this._relationTraceFixHandler = relationTraceFixHandler;
        }

        public AbstractRelationTrace(List<RelationInfo> relationList, List<AbstractRelationTrace> relationTraceList) {
            this._relationList = relationList;
            this._relationTraceList = relationTraceList;
            this._relationTraceList.add(this);
        }

        @Override
        public List<RelationInfo> getTraceRelation() {
            return this._traceRelationInfoList;
        }

        @Override
        public ColumnInfo getTraceColumn() {
            return this._traceColumnInfo;
        }

        protected DBMeta.RelationTrace fixTrace(List<RelationInfo> traceRelationInfoList, ColumnInfo traceColumnInfo) {
            AbstractRelationTrace localRelationTrace = this._relationTraceList.get(0);
            localRelationTrace.setTraceRelation(traceRelationInfoList);
            localRelationTrace.setTraceColumn(traceColumnInfo);
            localRelationTrace.recycle();
            localRelationTrace.handleFixedRelationTrace();
            return localRelationTrace;
        }

        protected void setTraceRelation(List<RelationInfo> traceRelationInfoList) {
            this._traceRelationInfoList = traceRelationInfoList;
        }

        protected void setTraceColumn(ColumnInfo traceColumn) {
            this._traceColumnInfo = traceColumn;
        }

        protected void recycle() {
            this._relationList = new ArrayList<RelationInfo>();
            this._relationTraceList = new ArrayList<AbstractRelationTrace>();
            this._relationTraceList.add(this);
        }

        protected void handleFixedRelationTrace() {
            if (this._relationTraceFixHandler != null) {
                this._relationTraceFixHandler.handleFixedTrace(this);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class MapAssertUtil {
        protected MapAssertUtil() {
        }

        public static void assertPrimaryKeyMapNotNullAndNotEmpty(Map<String, ? extends Object> primaryKeyMap) {
            if (primaryKeyMap == null) {
                String msg = "The argument[primaryKeyMap] should not be null.";
                throw new IllegalArgumentException(msg);
            }
            if (primaryKeyMap.isEmpty()) {
                String msg = "The argument[primaryKeyMap] should not be empty.";
                throw new IllegalArgumentException(msg);
            }
        }

        public static void assertColumnExistingInPrimaryKeyMap(Map<String, ? extends Object> primaryKeyMap, String columnName) {
            if (!primaryKeyMap.containsKey(columnName)) {
                String msg = "The primaryKeyMap must have the value of " + columnName;
                throw new IllegalStateException(String.valueOf(msg) + ": primaryKeyMap --> " + primaryKeyMap);
            }
        }

        public static void assertColumnValueMapNotNullAndNotEmpty(Map<String, ? extends Object> columnValueMap) {
            if (columnValueMap == null) {
                String msg = "The argument[columnValueMap] should not be null.";
                throw new IllegalArgumentException(msg);
            }
            if (columnValueMap.isEmpty()) {
                String msg = "The argument[columnValueMap] should not be empty.";
                throw new IllegalArgumentException(msg);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class MapStringUtil {
        protected MapStringUtil() {
        }

        public static void acceptPrimaryKeyMapString(String primaryKeyMapString, Entity entity) {
            if (primaryKeyMapString == null) {
                String msg = "The argument[primaryKeyMapString] should not be null.";
                throw new IllegalArgumentException(msg);
            }
            String prefix = "map:@{";
            String suffix = "@}";
            if (!primaryKeyMapString.trim().startsWith("map:@{")) {
                primaryKeyMapString = "map:@{" + primaryKeyMapString;
            }
            if (!primaryKeyMapString.trim().endsWith("@}")) {
                primaryKeyMapString = String.valueOf(primaryKeyMapString) + "@}";
            }
            MapListString mapListString = MapStringUtil.createMapListString();
            entity.getDBMeta().acceptPrimaryKeyMap(entity, mapListString.generateMap(primaryKeyMapString));
        }

        public static void acceptColumnValueMapString(String columnValueMapString, Entity entity) {
            if (columnValueMapString == null) {
                String msg = "The argument[columnValueMapString] should not be null.";
                throw new IllegalArgumentException(msg);
            }
            String prefix = "map:@{";
            String suffix = "@}";
            if (!columnValueMapString.trim().startsWith("map:@{")) {
                columnValueMapString = "map:@{" + columnValueMapString;
            }
            if (!columnValueMapString.trim().endsWith("@}")) {
                columnValueMapString = String.valueOf(columnValueMapString) + "@}";
            }
            MapListString mapListString = MapStringUtil.createMapListString();
            entity.getDBMeta().acceptColumnValueMap(entity, mapListString.generateMap(columnValueMapString));
        }

        public static String extractPrimaryKeyMapString(Entity entity) {
            String startBrace = "@{";
            String endBrace = "@}";
            String delimiter = "@;";
            String equal = "@=";
            return entity.getDBMeta().extractPrimaryKeyMapString(entity, "@{", "@}", "@;", "@=");
        }

        public static String extractColumnValueMapString(Entity entity) {
            String startBrace = "@{";
            String endBrace = "@}";
            String delimiter = "@;";
            String equal = "@=";
            return entity.getDBMeta().extractColumnValueMapString(entity, "@{", "@}", "@;", "@=");
        }

        public static void checkTypeString(Object value, String propertyName, String typeName) {
            if (value == null) {
                throw new IllegalArgumentException("The value should not be null: " + propertyName);
            }
            if (!(value instanceof String)) {
                String msg = "The value of " + propertyName + " should be " + typeName + " or String: ";
                msg = String.valueOf(msg) + "valueType=" + value.getClass() + " value=" + value;
                throw new IllegalArgumentException(msg);
            }
        }

        public static long parseDateStringAsMillis(Object value, String propertyName, String typeName) {
            MapStringUtil.checkTypeString(value, propertyName, typeName);
            try {
                String valueString = MapStringUtil.filterTimestampValue(((String)value).trim());
                return Timestamp.valueOf(valueString).getTime();
            }
            catch (RuntimeException e) {
                String msg = "The value of " + propertyName + " should be " + typeName + ". but: " + value;
                throw new RuntimeException(String.valueOf(msg) + " threw the exception: value=[" + value + "]", e);
            }
        }

        public static String filterTimestampValue(String value) {
            if ((value = value.trim()).indexOf("/") == 4 && value.lastIndexOf("/") == 7) {
                value = value.replaceAll("/", "-");
            }
            if (value.indexOf("-") == 4 && value.lastIndexOf("-") == 7 && value.length() == "2007-07-09".length()) {
                value = String.valueOf(value) + " 00:00:00";
            }
            return value;
        }

        public static String formatDate(Date value) {
            return MapStringUtil.getFormatDateFormat().format(value);
        }

        public static String formatTimestamp(Timestamp value) {
            return MapStringUtil.getFormatDateFormat().format(value);
        }

        public static DateFormat getParseDateFormat() {
            return DateFormat.getDateInstance();
        }

        public static DateFormat getFormatDateFormat() {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        }

        public static MapListString createMapListString() {
            MapListStringImpl mapListString = new MapListStringImpl();
            mapListString.setMapMark("map:");
            mapListString.setListMark("list:");
            mapListString.setStartBrace("@{");
            mapListString.setEndBrace("@}");
            mapListString.setEqual("@=");
            mapListString.setDelimiter("@;");
            return mapListString;
        }

        public static MapStringBuilder createMapStringBuilder(List<String> columnNameList) {
            MapStringBuilderImpl mapStringBuilder = new MapStringBuilderImpl();
            mapStringBuilder.setMsMapMark("map:");
            mapStringBuilder.setMsStartBrace("@{");
            mapStringBuilder.setMsEndBrace("@}");
            mapStringBuilder.setMsEqual("@=");
            mapStringBuilder.setMsDelimiter("@;");
            mapStringBuilder.setColumnNameList(columnNameList);
            return mapStringBuilder;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class MapStringValueAnalyzer {
        protected Map<String, ? extends Object> _valueMap;
        protected Set<String> _modifiedPropertyNames;
        protected String _columnName;
        protected String _uncapPropName;
        protected String _propertyName;

        public MapStringValueAnalyzer(Map<String, ? extends Object> valueMap, Set<String> modifiedPropertyNames) {
            this._valueMap = valueMap;
            this._modifiedPropertyNames = modifiedPropertyNames;
        }

        public boolean init(String columnName, String uncapPropName, String propertyName) {
            this._columnName = columnName;
            this._uncapPropName = uncapPropName;
            this._propertyName = propertyName;
            return this._valueMap.containsKey(this._columnName);
        }

        public <COLUMN_TYPE> COLUMN_TYPE analyzeString(Class<COLUMN_TYPE> javaType) {
            Object obj = this._valueMap.get(this._columnName);
            if (obj == null) {
                this._modifiedPropertyNames.remove(this._propertyName);
                return null;
            }
            this.helpCheckingTypeString(obj, this._uncapPropName, javaType.getName());
            return (COLUMN_TYPE)obj;
        }

        public <COLUMN_TYPE> COLUMN_TYPE analyzeNumber(Class<COLUMN_TYPE> javaType) {
            Object obj = this._valueMap.get(this._columnName);
            if (obj == null) {
                this._modifiedPropertyNames.remove(this._propertyName);
                return null;
            }
            if (javaType.isAssignableFrom(obj.getClass())) {
                return (COLUMN_TYPE)obj;
            }
            return (COLUMN_TYPE)this.newInstanceByConstructor(javaType, String.class, obj.toString());
        }

        public <COLUMN_TYPE> COLUMN_TYPE analyzeDate(Class<COLUMN_TYPE> javaType) {
            Object obj = this._valueMap.get(this._columnName);
            if (obj == null) {
                this._modifiedPropertyNames.remove(this._propertyName);
                return null;
            }
            if (javaType.isAssignableFrom(obj.getClass())) {
                return (COLUMN_TYPE)obj;
            }
            return (COLUMN_TYPE)this.newInstanceByConstructor(javaType, Long.TYPE, this.helpParsingDateString(obj, this._uncapPropName, javaType.getName()));
        }

        public <COLUMN_TYPE> COLUMN_TYPE analyzeOther(Class<COLUMN_TYPE> javaType) {
            Object obj = this._valueMap.get(this._columnName);
            if (obj == null) {
                this._modifiedPropertyNames.remove(this._propertyName);
                return null;
            }
            return (COLUMN_TYPE)obj;
        }

        private void helpCheckingTypeString(Object value, String uncapPropName, String typeName) {
            MapStringUtil.checkTypeString(value, uncapPropName, typeName);
        }

        private long helpParsingDateString(Object value, String uncapPropName, String typeName) {
            return MapStringUtil.parseDateStringAsMillis(value, uncapPropName, typeName);
        }

        protected Object newInstanceByConstructor(Class targetType, Class argType, Object arg) {
            Constructor constructor;
            try {
                constructor = targetType.getConstructor(argType);
            }
            catch (SecurityException e) {
                String msg = "targetType=" + targetType + " argType=" + argType + " arg=" + arg;
                throw new RuntimeException(msg, e);
            }
            catch (NoSuchMethodException e) {
                String msg = "targetType=" + targetType + " argType=" + argType + " arg=" + arg;
                throw new RuntimeException(msg, e);
            }
            try {
                return constructor.newInstance(arg);
            }
            catch (IllegalArgumentException e) {
                String msg = "targetType=" + targetType + " argType=" + argType + " arg=" + arg;
                throw new RuntimeException(msg, e);
            }
            catch (InstantiationException e) {
                String msg = "targetType=" + targetType + " argType=" + argType + " arg=" + arg;
                throw new RuntimeException(msg, e);
            }
            catch (IllegalAccessException e) {
                String msg = "targetType=" + targetType + " argType=" + argType + " arg=" + arg;
                throw new RuntimeException(msg, e);
            }
            catch (InvocationTargetException e) {
                String msg = "targetType=" + targetType + " argType=" + argType + " arg=" + arg;
                throw new RuntimeException(msg, e);
            }
        }
    }
}

