/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.ea2ddl.dao.allcommon.cbean.sqlclause;

import jp.sourceforge.ea2ddl.dao.allcommon.cbean.sqlclause.AbstractSqlClause;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.sqlclause.SqlClause;
import jp.sourceforge.ea2ddl.dao.allcommon.dbmeta.DBMeta;
import jp.sourceforge.ea2ddl.dao.allcommon.dbmeta.DBMetaInstanceHandler;

public class SqlClauseOracle
extends AbstractSqlClause {
    protected String _fetchScopeSelectHint = "";
    protected String _fetchScopeSqlSuffix = "";
    protected String _lockSqlSuffix = "";

    public SqlClauseOracle(String tableName) {
        super(tableName);
    }

    protected String buildUnionClause(String selectClause) {
        selectClause = this.replaceString(selectClause, "/*$dto.selectHint*/", "");
        return super.buildUnionClause(selectClause);
    }

    protected void doFetchFirst() {
        this.doFetchPage();
    }

    protected void doFetchPage() {
        if (!this.isFetchStartIndexSupported() && !this.isFetchSizeSupported()) {
            return;
        }
        String ln = null;
        ln = this.isFormatClauseEffective() ? this.getLineSeparator() : "";
        this._fetchScopeSelectHint = " * from (select base.*, rownum as rn from (" + ln + "select";
        this._fetchScopeSqlSuffix = "";
        if (this.isFetchStartIndexSupported()) {
            this._fetchScopeSqlSuffix = ") base )" + ln + " where rn > " + this.getPageStartIndex();
        }
        if (this.isFetchSizeSupported()) {
            this._fetchScopeSqlSuffix = this.isFetchStartIndexSupported() ? String.valueOf(this._fetchScopeSqlSuffix) + " and rn <= " + this.getPageEndIndex() : ") base )" + ln + " where rn <= " + this.getPageEndIndex();
        }
    }

    protected void doClearFetchPageClause() {
        this._fetchScopeSelectHint = "";
        this._fetchScopeSqlSuffix = "";
    }

    public SqlClause lockForUpdate() {
        DBMeta dbmeta = DBMetaInstanceHandler.findDBMeta(this._tableName);
        if (dbmeta.hasPrimaryKey()) {
            String primaryKeyColumnName = dbmeta.getPrimaryUniqueInfo().getFirstColumn().getColumnDbName();
            this._lockSqlSuffix = " for update of " + this.getLocalTableAliasName() + "." + primaryKeyColumnName;
        } else {
            String randomColumnName = dbmeta.getColumnInfoList().get(0).getColumnDbName();
            this._lockSqlSuffix = " for update of " + this.getLocalTableAliasName() + "." + randomColumnName;
        }
        return this;
    }

    protected String createSelectHint() {
        return this._fetchScopeSelectHint;
    }

    protected String createFromBaseTableHint() {
        return "";
    }

    protected String createFromHint() {
        return "";
    }

    protected String createSqlSuffix() {
        return String.valueOf(this._fetchScopeSqlSuffix) + this._lockSqlSuffix;
    }

    public boolean isUniqueConstraintException(String sqlState, Integer errorCode) {
        return errorCode != null && errorCode == 1;
    }
}

