/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.ea2ddl.dao.allcommon.cbean.pagenavi.range;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.pagenavi.PageNumberLink;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.pagenavi.PageNumberLinkSetupper;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.pagenavi.range.PageRangeOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageRangeBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected int _currentPageNumber;
    protected int _allPageCount;
    protected PageRangeOption _pageRangeOption;

    public <LINK extends PageNumberLink> List<LINK> buildPageNumberLinkList(PageNumberLinkSetupper<LINK> pageNumberLinkSetupper) {
        List<Integer> pageNumberList = this.createPageNumberList();
        ArrayList<LINK> pageNumberLinkList = new ArrayList<LINK>();
        for (Integer pageNumber : pageNumberList) {
            pageNumberLinkList.add(pageNumberLinkSetupper.setup(pageNumber, pageNumber.equals(this._currentPageNumber)));
        }
        return pageNumberLinkList;
    }

    public List<Integer> createPageNumberList() {
        this.assertPageRangeValid();
        int pageRangeSize = this._pageRangeOption.getPageRangeSize();
        int allPageCount = this._allPageCount;
        int currentPageNumber = this._currentPageNumber;
        ArrayList<Integer> resultList = new ArrayList<Integer>();
        int i = currentPageNumber - pageRangeSize;
        while (i < currentPageNumber) {
            if (i >= 1) {
                resultList.add(new Integer(i));
            }
            ++i;
        }
        resultList.add(new Integer(currentPageNumber));
        int endPageNumber = currentPageNumber + pageRangeSize;
        int i2 = currentPageNumber + 1;
        while (i2 <= endPageNumber && i2 <= allPageCount) {
            resultList.add(new Integer(i2));
            ++i2;
        }
        boolean fillLimit = this._pageRangeOption.isFillLimit();
        int limitSize = pageRangeSize * 2 + 1;
        if (fillLimit && !resultList.isEmpty() && resultList.size() < limitSize) {
            int i3;
            Integer firstElements = (Integer)resultList.get(0);
            Integer lastElements = (Integer)resultList.get(resultList.size() - 1);
            if (firstElements > 1) {
                i3 = firstElements - 1;
                while (resultList.size() < limitSize && i3 > 0) {
                    resultList.add(0, new Integer(i3));
                    --i3;
                }
            }
            i3 = lastElements + 1;
            while (resultList.size() < limitSize && i3 <= allPageCount) {
                resultList.add(new Integer(i3));
                ++i3;
            }
        }
        return resultList;
    }

    public int[] createPageNumberArray() {
        this.assertPageRangeValid();
        return this.convertListToIntArray(this.createPageNumberList());
    }

    public boolean isExistPrePageRange() {
        this.assertPageRangeValid();
        int[] array = this.createPageNumberArray();
        if (array.length == 0) {
            return false;
        }
        return array[0] > 1;
    }

    public boolean isExistNextPageRange() {
        this.assertPageRangeValid();
        int[] array = this.createPageNumberArray();
        if (array.length == 0) {
            return false;
        }
        return array[array.length - 1] < this._allPageCount;
    }

    protected int[] convertListToIntArray(List<Integer> ls) {
        int[] resultArray = new int[ls.size()];
        int arrayIndex = 0;
        for (Integer tmpPageNumber : ls) {
            resultArray[arrayIndex] = tmpPageNumber;
            ++arrayIndex;
        }
        return resultArray;
    }

    protected void assertPageRangeValid() {
        if (this._pageRangeOption == null) {
            String msg = "The pageRangeOption should not be null. Please invoke setPageRangeOption().";
            throw new IllegalStateException(msg);
        }
        int pageRangeSize = this._pageRangeOption.getPageRangeSize();
        if (pageRangeSize == 0) {
            String msg = "The pageRangeSize should be greater than 1. But the value is zero.";
            throw new IllegalStateException(msg);
        }
    }

    public void setCurrentPageNumber(int currentPageNumber) {
        this._currentPageNumber = currentPageNumber;
    }

    public void setAllPageCount(int allPageCount) {
        this._allPageCount = allPageCount;
    }

    public void setPageRangeOption(PageRangeOption pageRangeOption) {
        this._pageRangeOption = pageRangeOption;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(" currentPageNumber=").append(this._currentPageNumber);
        sb.append(" allPageCount=").append(this._allPageCount);
        sb.append(" pageRangeOption=").append(this._pageRangeOption);
        return sb.toString();
    }
}

