/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.ea2ddl.dao.allcommon.cbean.outsidesql.executor;

import java.util.List;
import jp.sourceforge.ea2ddl.dao.allcommon.DBFluteConfig;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.ListResultBean;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.PagingBean;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.PagingHandler;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.PagingInvoker;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.PagingResultBean;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.ResultBeanBuilder;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.outsidesql.OutsideSqlDao;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.outsidesql.OutsideSqlOption;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.outsidesql.executor.OutsideSqlEntityExecutor;
import jp.sourceforge.ea2ddl.dao.allcommon.jdbc.StatementConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutsideSqlPagingExecutor {
    protected final OutsideSqlDao _outsideSqlDao;
    protected final OutsideSqlOption _outsideSqlOption;
    protected final String _tableDbName;

    public OutsideSqlPagingExecutor(OutsideSqlDao outsideSqlDao, OutsideSqlOption outsideSqlOption, String tableDbName) {
        this._outsideSqlDao = outsideSqlDao;
        this._outsideSqlOption = outsideSqlOption;
        this._tableDbName = tableDbName;
    }

    public <ENTITY> ListResultBean<ENTITY> selectList(String path, PagingBean pmb, Class<ENTITY> entityType) {
        this.setupScrollableCursorIfNeeds();
        List<ENTITY> resultList = this._outsideSqlDao.selectList(path, pmb, this._outsideSqlOption, entityType);
        return new ResultBeanBuilder<ENTITY>(this._tableDbName).buildListResultBean(resultList);
    }

    public <ENTITY> PagingResultBean<ENTITY> selectPage(final String path, final PagingBean pmb, final Class<ENTITY> entityType) {
        OutsideSqlOption countOption = this._outsideSqlOption.copyOptionWithoutPaging();
        final OutsideSqlEntityExecutor countExecutor = new OutsideSqlEntityExecutor(this._outsideSqlDao, countOption);
        PagingHandler handler = new PagingHandler<ENTITY>(){

            @Override
            public PagingBean getPagingBean() {
                return pmb;
            }

            @Override
            public int count() {
                pmb.xsetPaging(false);
                return countExecutor.selectEntityWithDeletedCheck(path, pmb, Integer.class);
            }

            @Override
            public List<ENTITY> paging() {
                pmb.xsetPaging(true);
                return OutsideSqlPagingExecutor.this.selectList(path, pmb, entityType);
            }
        };
        PagingInvoker invoker = new PagingInvoker(this._tableDbName);
        if (pmb.isCountLater()) {
            invoker.countLater();
        }
        return invoker.invokePaging(handler);
    }

    protected void setupScrollableCursorIfNeeds() {
        if (!this._outsideSqlOption.isAutoPaging()) {
            return;
        }
        StatementConfig statementConfig = this._outsideSqlOption.getStatementConfig();
        if (statementConfig != null && statementConfig.getResultSetType() != null) {
            return;
        }
        StatementConfig defaultStatementConfig = DBFluteConfig.getInstance().getDefaultStatementConfig();
        if (defaultStatementConfig != null && defaultStatementConfig.hasResultSetType()) {
            return;
        }
        if (statementConfig == null) {
            statementConfig = new StatementConfig();
            this.configure(statementConfig);
        }
        statementConfig.typeScrollInsensitive();
    }

    public OutsideSqlPagingExecutor configure(StatementConfig statementConfig) {
        this._outsideSqlOption.setStatementConfig(statementConfig);
        return this;
    }

    public OutsideSqlPagingExecutor dynamicBinding() {
        this._outsideSqlOption.dynamicBinding();
        return this;
    }
}

