/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.ea2ddl.dao.allcommon.cbean.outsidesql;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import jp.sourceforge.ea2ddl.dao.allcommon.DBFluteConfig;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.outsidesql.OutsideSqlOption;
import jp.sourceforge.ea2ddl.dao.allcommon.dbmeta.DBMeta;
import jp.sourceforge.ea2ddl.dao.allcommon.dbmeta.DBMetaInstanceHandler;
import jp.sourceforge.ea2ddl.dao.allcommon.exception.OutsideSqlNotFoundException;
import jp.sourceforge.ea2ddl.dao.allcommon.jdbc.StatementConfig;
import jp.sourceforge.ea2ddl.dao.allcommon.util.SimpleStringUtil;
import jp.sourceforge.ea2ddl.dao.allcommon.util.SimpleSystemUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.framework.util.InputStreamReaderUtil;
import org.seasar.framework.util.ReaderUtil;
import org.seasar.framework.util.ResourceUtil;

public class OutsideSqlContext {
    private static final Log _log = LogFactory.getLog(OutsideSqlContext.class);
    private static final ThreadLocal<OutsideSqlContext> _threadLocal = new ThreadLocal();
    protected boolean _dynamicBinding;
    protected boolean _offsetByCursorForcedly;
    protected boolean _limitByCursorForcedly;
    protected String _outsideSqlPath;
    protected Object _parameterBean;
    protected Object _resultTypeSpecification;
    protected String _methodName;
    protected StatementConfig _statementConfig;
    protected String _tableDbName;

    public static OutsideSqlContext getOutsideSqlContextOnThread() {
        return _threadLocal.get();
    }

    public static void setOutsideSqlContextOnThread(OutsideSqlContext outsideSqlContext) {
        if (outsideSqlContext == null) {
            String msg = "The argument[outsideSqlContext] must not be null.";
            throw new IllegalArgumentException(msg);
        }
        _threadLocal.set(outsideSqlContext);
    }

    public static boolean isExistOutsideSqlContextOnThread() {
        return _threadLocal.get() != null;
    }

    public static void clearOutsideSqlContextOnThread() {
        _threadLocal.set(null);
    }

    public static String generateSpecifiedOutsideSqlUniqueKey(String methodName, String path, Object pmb, OutsideSqlOption option, Object resultTypeSpecification) {
        String pmbKey = pmb != null ? pmb.getClass().getName() : "null";
        String resultKey = resultTypeSpecification != null ? ":" + resultTypeSpecification : "null";
        String tableDbName = option.getTableDbName();
        String generatedUniqueKey = option.generateUniqueKey();
        return String.valueOf(methodName) + "():" + tableDbName + ":" + path + ":" + pmbKey + ":" + generatedUniqueKey + resultKey;
    }

    public static void throwOutsideSqlNotFoundException(String path) {
        String msg = "Look! Read the message below." + OutsideSqlContext.getLineSeparator();
        msg = String.valueOf(msg) + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + OutsideSqlContext.getLineSeparator();
        msg = String.valueOf(msg) + "The outsideSql was Not Found!" + OutsideSqlContext.getLineSeparator();
        msg = String.valueOf(msg) + OutsideSqlContext.getLineSeparator();
        msg = String.valueOf(msg) + "[Advice]" + OutsideSqlContext.getLineSeparator();
        msg = String.valueOf(msg) + "Please confirm the existence of your target file of outsideSql on your classpath." + OutsideSqlContext.getLineSeparator();
        msg = String.valueOf(msg) + "And please confirm the file name and the file path STRICTLY!" + OutsideSqlContext.getLineSeparator();
        msg = String.valueOf(msg) + OutsideSqlContext.getLineSeparator();
        msg = String.valueOf(msg) + "[Specified OutsideSql Path]" + OutsideSqlContext.getLineSeparator() + path + OutsideSqlContext.getLineSeparator();
        msg = String.valueOf(msg) + "* * * * * * * * * */" + OutsideSqlContext.getLineSeparator();
        throw new OutsideSqlNotFoundException(msg);
    }

    public String readFilteredOutsideSql(String sqlFileEncoding, String dbmsSuffix) {
        String sql = this.readOutsideSql(sqlFileEncoding, dbmsSuffix);
        return this.replaceOutsideSqlBindCharacterOnLineComment(sql);
    }

    protected String replaceOutsideSqlBindCharacterOnLineComment(String sql) {
        String[] lines;
        String bindCharacter = "?";
        if (sql.indexOf("?") < 0) {
            return sql;
        }
        String lineSeparator = "\n";
        if (sql.indexOf("\n") < 0) {
            return sql;
        }
        String lineCommentMark = "--";
        if (sql.indexOf("--") < 0) {
            return sql;
        }
        StringBuilder sb = new StringBuilder();
        String[] stringArray = lines = sql.split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            int lineCommentIndex = line.indexOf("--");
            if (lineCommentIndex < 0) {
                sb.append(line).append("\n");
            } else {
                String lineComment = line.substring(lineCommentIndex);
                if (lineComment.contains("ELSE") || !lineComment.contains("?")) {
                    sb.append(line).append("\n");
                } else {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)("...Replacing bind character on line comment: " + lineComment));
                    }
                    String filteredLineComment = OutsideSqlContext.replaceString(lineComment, "?", "Q");
                    sb.append(line.substring(0, lineCommentIndex)).append(filteredLineComment).append("\n");
                }
            }
            ++n2;
        }
        return sb.toString();
    }

    public String readOutsideSql(String sqlFileEncoding, String dbmsSuffix) {
        String sql;
        String standardPath = this._outsideSqlPath;
        String dbmsPath = this.buildDbmsPath(standardPath, dbmsSuffix);
        if (this.isExistResource(dbmsPath)) {
            sql = this.readText(dbmsPath, sqlFileEncoding);
        } else if (this.isExistResource(standardPath)) {
            sql = this.readText(standardPath, sqlFileEncoding);
        } else {
            OutsideSqlContext.throwOutsideSqlNotFoundException(standardPath);
            return null;
        }
        return this.removeInitialUnicodeBomIfNeeds(sqlFileEncoding, sql);
    }

    protected String buildDbmsPath(String standardPath, String dbmsSuffix) {
        String dbmsPath;
        int lastIndexOfDot = standardPath.lastIndexOf(".");
        if (lastIndexOfDot >= 0 && !standardPath.substring(lastIndexOfDot).contains("/")) {
            String base = standardPath.substring(0, lastIndexOfDot);
            dbmsPath = String.valueOf(base) + dbmsSuffix + standardPath.substring(lastIndexOfDot);
        } else {
            dbmsPath = String.valueOf(standardPath) + dbmsSuffix;
        }
        return dbmsPath;
    }

    protected String removeInitialUnicodeBomIfNeeds(String sqlFileEncoding, String sql) {
        if ("UTF-8".equalsIgnoreCase(sqlFileEncoding) && sql.length() > 0 && sql.charAt(0) == '\ufeff') {
            sql = sql.substring(1);
        }
        return sql;
    }

    public void setupBehaviorQueryPathIfNeeds() {
        if (!this.isBehaviorQueryPathEnabled()) {
            return;
        }
        if (this._outsideSqlPath.contains(":")) {
            String subDirectoryValue = this._outsideSqlPath.substring(0, this._outsideSqlPath.lastIndexOf(":"));
            String subDirectoryPath = OutsideSqlContext.replaceString(subDirectoryValue, ":", "/");
            String behaviorQueryPath = this._outsideSqlPath.substring(this._outsideSqlPath.lastIndexOf(":") + ":".length());
            String behaviorClassPath = OutsideSqlContext.replaceString(this.buildBehaviorSqlPackageName(), ".", "/");
            String behaviorPackagePath = behaviorClassPath.substring(0, behaviorClassPath.lastIndexOf("/"));
            String behaviorClassName = behaviorClassPath.substring(behaviorClassPath.lastIndexOf("/") + "/".length());
            this._outsideSqlPath = String.valueOf(behaviorPackagePath) + "/" + subDirectoryPath + "/" + behaviorClassName + "_" + behaviorQueryPath + ".sql";
        } else {
            this._outsideSqlPath = String.valueOf(OutsideSqlContext.replaceString(this.buildBehaviorSqlPackageName(), ".", "/")) + "_" + this._outsideSqlPath + ".sql";
        }
    }

    protected String buildBehaviorSqlPackageName() {
        DBMeta dbmeta = DBMetaInstanceHandler.findDBMeta(this._tableDbName);
        String behaviorTypeName = dbmeta.getBehaviorTypeName();
        String outsideSqlPackage = DBFluteConfig.getInstance().getOutsideSqlPackage();
        if (outsideSqlPackage != null && outsideSqlPackage.trim().length() > 0) {
            String behaviorClassName = behaviorTypeName.substring(behaviorTypeName.lastIndexOf(".") + ".".length());
            String tmp = behaviorTypeName.substring(0, behaviorTypeName.lastIndexOf("."));
            String exbhvName = tmp.contains(".") ? tmp.substring(tmp.lastIndexOf(".") + ".".length()) : tmp;
            return String.valueOf(outsideSqlPackage) + "." + exbhvName + "." + behaviorClassName;
        }
        return behaviorTypeName;
    }

    protected boolean isBehaviorQueryPathEnabled() {
        if (this.isProcedure()) {
            return false;
        }
        return this._outsideSqlPath != null && !this._outsideSqlPath.contains("/") && !this._outsideSqlPath.contains(".") && this._tableDbName != null;
    }

    public boolean isSpecifiedOutsideSql() {
        return this._outsideSqlPath != null;
    }

    public boolean isProcedure() {
        return this._methodName != null && this._methodName.startsWith("call");
    }

    protected boolean isExistResource(String path) {
        return ResourceUtil.isExist((String)path);
    }

    protected String readText(String path, String sqlFileEncoding) {
        InputStream is = ResourceUtil.getResourceAsStream((String)path);
        InputStreamReader reader = InputStreamReaderUtil.create((InputStream)is, (String)sqlFileEncoding);
        return ReaderUtil.readText((Reader)reader);
    }

    protected static String replaceString(String text, String fromText, String toText) {
        return SimpleStringUtil.replace(text, fromText, toText);
    }

    protected static String getLineSeparator() {
        return SimpleSystemUtil.getLineSeparator();
    }

    public boolean isDynamicBinding() {
        return this._dynamicBinding;
    }

    public void setDynamicBinding(boolean dynamicBinding) {
        this._dynamicBinding = dynamicBinding;
    }

    public boolean isOffsetByCursorForcedly() {
        return this._offsetByCursorForcedly;
    }

    public void setOffsetByCursorForcedly(boolean offsetByCursorForcedly) {
        this._offsetByCursorForcedly = offsetByCursorForcedly;
    }

    public boolean isLimitByCursorForcedly() {
        return this._limitByCursorForcedly;
    }

    public void setLimitByCursorForcedly(boolean limitByCursorForcedly) {
        this._limitByCursorForcedly = limitByCursorForcedly;
    }

    public String getOutsideSqlPath() {
        return this._outsideSqlPath;
    }

    public void setOutsideSqlPath(String outsideSqlPath) {
        this._outsideSqlPath = outsideSqlPath;
    }

    public Object getParameterBean() {
        return this._parameterBean;
    }

    public void setParameterBean(Object parameterBean) {
        this._parameterBean = parameterBean;
    }

    public Object getResultTypeSpecification() {
        return this._resultTypeSpecification;
    }

    public void setResultTypeSpecification(Object resultTypeSpecification) {
        this._resultTypeSpecification = resultTypeSpecification;
    }

    public String getMethodName() {
        return this._methodName;
    }

    public void setMethodName(String methodName) {
        this._methodName = methodName;
    }

    public StatementConfig getStatementConfig() {
        return this._statementConfig;
    }

    public void setStatementConfig(StatementConfig statementConfig) {
        this._statementConfig = statementConfig;
    }

    public String getTableDbName() {
        return this._tableDbName;
    }

    public void setTableDbName(String tableDbName) {
        this._tableDbName = tableDbName;
    }
}

