/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.ea2ddl.dao.allcommon.cbean.coption;

import java.util.Calendar;
import java.util.Date;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.ckey.ConditionKey;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.coption.ConditionOption;

public class FromToOption
implements ConditionOption {
    protected boolean _fromDateGreaterThan;
    protected boolean _toDateLessThan;
    protected boolean _compareAsDate;

    public String getRearOption() {
        String msg = "Thie option does not use getRearOption()!";
        throw new UnsupportedOperationException(msg);
    }

    public FromToOption greaterThan() {
        this._fromDateGreaterThan = true;
        return this;
    }

    public FromToOption lessThan() {
        this._toDateLessThan = true;
        return this;
    }

    public FromToOption compareAsDate() {
        this._compareAsDate = true;
        return this;
    }

    public Date filterFromDate(Date fromDate) {
        if (fromDate == null) {
            return null;
        }
        if (this._compareAsDate) {
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(fromDate.getTime());
            this.clearCalendarHourMinuteSecondMilli(cal);
            Date cloneDate = (Date)fromDate.clone();
            cloneDate.setTime(cal.getTimeInMillis());
            return cloneDate;
        }
        return fromDate;
    }

    public Date filterToDate(Date toDate) {
        if (toDate == null) {
            return null;
        }
        if (this._compareAsDate) {
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(toDate.getTime());
            this.clearCalendarHourMinuteSecondMilli(cal);
            this.addCalendarNextDay(cal);
            Date cloneDate = (Date)toDate.clone();
            cloneDate.setTime(cal.getTimeInMillis());
            return cloneDate;
        }
        return toDate;
    }

    public ConditionKey getFromDateConditionKey() {
        if (this._compareAsDate) {
            return ConditionKey.CK_GREATER_EQUAL;
        }
        if (this._fromDateGreaterThan) {
            return ConditionKey.CK_GREATER_THAN;
        }
        return ConditionKey.CK_GREATER_EQUAL;
    }

    public ConditionKey getToDateConditionKey() {
        if (this._compareAsDate) {
            return ConditionKey.CK_LESS_THAN;
        }
        if (this._toDateLessThan) {
            return ConditionKey.CK_LESS_THAN;
        }
        return ConditionKey.CK_LESS_EQUAL;
    }

    protected void addCalendarNextDay(Calendar cal) {
        cal.add(5, 1);
    }

    protected void clearCalendarHourMinuteSecondMilli(Calendar cal) {
        cal.clear(14);
        cal.clear(13);
        cal.clear(12);
        cal.set(11, cal.getActualMinimum(11));
    }
}

