/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.ea2ddl.dao.allcommon.cbean;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.ConditionQuery;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.ckey.ConditionKey;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.coption.ConditionOption;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.coption.FromToOption;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.coption.InScopeOption;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.coption.LikeSearchOption;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.cvalue.ConditionValue;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.sqlclause.SqlClause;
import jp.sourceforge.ea2ddl.dao.allcommon.dbmeta.DBMeta;
import jp.sourceforge.ea2ddl.dao.allcommon.dbmeta.DBMetaInstanceHandler;
import jp.sourceforge.ea2ddl.dao.allcommon.exception.RequiredOptionNotFoundException;
import jp.sourceforge.ea2ddl.dao.allcommon.util.SimpleStringUtil;
import jp.sourceforge.ea2ddl.dao.allcommon.util.SimpleSystemUtil;
import jp.sourceforge.ea2ddl.dao.allcommon.util.TraceViewUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConditionQuery
implements ConditionQuery {
    protected static final ConditionKey CK_EQ = ConditionKey.CK_EQUAL;
    protected static final ConditionKey CK_NE = ConditionKey.CK_NOT_EQUAL;
    protected static final ConditionKey CK_GE = ConditionKey.CK_GREATER_EQUAL;
    protected static final ConditionKey CK_GT = ConditionKey.CK_GREATER_THAN;
    protected static final ConditionKey CK_LE = ConditionKey.CK_LESS_EQUAL;
    protected static final ConditionKey CK_LT = ConditionKey.CK_LESS_THAN;
    protected static final ConditionKey CK_PS = ConditionKey.CK_PREFIX_SEARCH;
    protected static final ConditionKey CK_LS = ConditionKey.CK_LIKE_SEARCH;
    protected static final ConditionKey CK_INS = ConditionKey.CK_IN_SCOPE;
    protected static final ConditionKey CK_NINS = ConditionKey.CK_NOT_IN_SCOPE;
    protected static final ConditionKey CK_ISN = ConditionKey.CK_IS_NULL;
    protected static final ConditionKey CK_ISNN = ConditionKey.CK_IS_NOT_NULL;
    protected static final ConditionValue DUMMY_CONDITION_VALUE = new ConditionValue();
    protected static final Object DUMMY_OBJECT = new Object();
    protected static final String CQ_PROPERTY = "conditionQuery";
    protected final SqlClause _sqlClause;
    protected final String _aliasName;
    protected final int _nestLevel;
    protected int _subQueryLevel;
    protected String _foreignPropertyName;
    protected String _relationPath;
    protected final ConditionQuery _childQuery;
    protected boolean _onClauseInline;
    protected Map<String, ConditionQuery> _unionQueryMap;
    protected Map<String, ConditionQuery> _unionAllQueryMap;

    public AbstractConditionQuery(ConditionQuery childQuery, SqlClause sqlClause, String aliasName, int nestLevel) {
        this._childQuery = childQuery;
        this._sqlClause = sqlClause;
        this._aliasName = aliasName;
        this._nestLevel = nestLevel;
    }

    @Override
    public ConditionQuery getChildQuery() {
        return this._childQuery;
    }

    @Override
    public SqlClause getSqlClause() {
        return this._sqlClause;
    }

    @Override
    public String getAliasName() {
        return this._aliasName;
    }

    @Override
    public int getNestLevel() {
        return this._nestLevel;
    }

    @Override
    public int getNextNestLevel() {
        return this._nestLevel + 1;
    }

    @Override
    public boolean isBaseQuery(ConditionQuery query) {
        return query.getChildQuery() == null;
    }

    @Override
    public int getSubQueryLevel() {
        return this._subQueryLevel;
    }

    @Override
    public String getRealAliasName() {
        return this.getAliasName();
    }

    @Override
    public String getRealColumnName(String columnName) {
        this.assertColumnName(columnName);
        return this.buildRealColumnName(this.getRealAliasName(), columnName);
    }

    protected String buildRealColumnName(String aliasName, String columnName) {
        return String.valueOf(aliasName) + "." + columnName;
    }

    @Override
    public String getForeignPropertyName() {
        return this._foreignPropertyName;
    }

    public void xsetForeignPropertyName(String foreignPropertyName) {
        this._foreignPropertyName = foreignPropertyName;
    }

    @Override
    public String getRelationPath() {
        return this._relationPath;
    }

    public void xsetRelationPath(String relationPath) {
        this._relationPath = relationPath;
    }

    public void xsetOnClauseInline(boolean onClauseInline) {
        this._onClauseInline = onClauseInline;
    }

    protected String getLocation(String columnPropertyName, ConditionKey key) {
        return String.valueOf(this.getLocationBase(columnPropertyName)) + "." + key.getConditionKey();
    }

    protected String getLocationBase() {
        StringBuffer sb = new StringBuffer();
        ConditionQuery query = this;
        while (true) {
            if (query.isBaseQuery(query)) break;
            String foreignPropertyName = query.getForeignPropertyName();
            if (foreignPropertyName == null) {
                String msg = "The foreignPropertyName of the query should not be null:";
                msg = String.valueOf(msg) + " query=" + query;
                throw new IllegalStateException(msg);
            }
            sb.insert(0, CQ_PROPERTY + this.initCap(foreignPropertyName) + ".");
            query = query.getChildQuery();
        }
        sb.insert(0, "conditionQuery.");
        return sb.toString();
    }

    protected String getLocationBase(String columnPropertyName) {
        return String.valueOf(this.getLocationBase()) + columnPropertyName;
    }

    public Map<String, ConditionQuery> getUnionQueryMap() {
        if (this._unionQueryMap == null) {
            this._unionQueryMap = new LinkedHashMap<String, ConditionQuery>();
        }
        return this._unionQueryMap;
    }

    public void xsetUnionQuery(ConditionQuery unionQuery) {
        this.xsetupUnion(unionQuery, false, this.getUnionQueryMap());
    }

    public Map<String, ConditionQuery> getUnionAllQueryMap() {
        if (this._unionAllQueryMap == null) {
            this._unionAllQueryMap = new LinkedHashMap<String, ConditionQuery>();
        }
        return this._unionAllQueryMap;
    }

    public void xsetUnionAllQuery(ConditionQuery unionAllQuery) {
        this.xsetupUnion(unionAllQuery, true, this.getUnionAllQueryMap());
    }

    protected void xsetupUnion(ConditionQuery unionQuery, boolean unionAll, Map<String, ConditionQuery> unionQueryMap) {
        if (unionQuery == null) {
            String msg = "The argument[unionQuery] should not be null.";
            throw new IllegalArgumentException(msg);
        }
        this.reflectRelationOnUnionQuery(this, unionQuery);
        this.getSqlClause().copyIncludedSelectColumn(unionQuery.getSqlClause());
        if (this.getSqlClause().isFormatClauseEffective()) {
            unionQuery.getSqlClause().makeFormatClauseEffective();
        }
        String key = String.valueOf(unionAll ? "unionAllQuery" : "unionQuery") + unionQueryMap.size();
        unionQueryMap.put(key, unionQuery);
        this.registerUnionQuery(unionQuery, unionAll, String.valueOf(unionAll ? "unionAllQueryMap" : "unionQueryMap") + "." + key);
    }

    protected abstract void reflectRelationOnUnionQuery(ConditionQuery var1, ConditionQuery var2);

    public boolean hasUnionQueryOrUnionAllQuery() {
        return this._unionQueryMap != null && !this._unionQueryMap.isEmpty() || this._unionAllQueryMap != null && !this._unionAllQueryMap.isEmpty();
    }

    public List<ConditionQuery> getUnionQueryList() {
        if (this._unionQueryMap == null) {
            return new ArrayList<ConditionQuery>();
        }
        return new ArrayList<ConditionQuery>(this._unionQueryMap.values());
    }

    public List<ConditionQuery> getUnionAllQueryList() {
        if (this._unionAllQueryMap == null) {
            return new ArrayList<ConditionQuery>();
        }
        return new ArrayList<ConditionQuery>(this._unionAllQueryMap.values());
    }

    protected void registerIncludedSelectColumn(String aliasName, String realColumnName) {
        throw new UnsupportedOperationException();
    }

    protected void registerQuery(ConditionKey key, Object value, ConditionValue cvalue, String colName, String capPropName, String uncapPropName) {
        if (key.isValidRegistration(cvalue, value, String.valueOf(key.getConditionKey()) + " of " + this.getRealAliasName() + "." + colName)) {
            this.setupConditionValueAndRegisterWhereClause(key, value, cvalue, colName, capPropName, uncapPropName);
        }
    }

    protected void registerQuery(ConditionKey key, Object value, ConditionValue cvalue, String colName, String capPropName, String uncapPropName, ConditionOption option) {
        if (key.isValidRegistration(cvalue, value, String.valueOf(key.getConditionKey()) + " of " + this.getRealAliasName() + "." + colName)) {
            this.setupConditionValueAndRegisterWhereClause(key, value, cvalue, colName, capPropName, uncapPropName, option);
        }
    }

    protected void registerFromToQuery(Date fromDate, Date toDate, ConditionValue cvalue, String colName, String capPropName, String uncapPropName, FromToOption option) {
        Date filteredFromDate = option.filterFromDate(fromDate);
        ConditionKey fromKey = option.getFromDateConditionKey();
        if (fromKey.isValidRegistration(cvalue, filteredFromDate, String.valueOf(fromKey.getConditionKey()) + " of " + this.getRealAliasName() + "." + uncapPropName)) {
            this.setupConditionValueAndRegisterWhereClause(fromKey, filteredFromDate, cvalue, colName, capPropName, uncapPropName);
        }
        Date filteredToDate = option.filterToDate(toDate);
        ConditionKey toKey = option.getToDateConditionKey();
        if (toKey.isValidRegistration(cvalue, filteredToDate, String.valueOf(toKey.getConditionKey()) + " of " + this.getRealAliasName() + "." + uncapPropName)) {
            this.setupConditionValueAndRegisterWhereClause(toKey, filteredToDate, cvalue, colName, capPropName, uncapPropName);
        }
    }

    protected void registerLikeSearchQuery(ConditionKey key, String value, ConditionValue cvalue, String colName, String capPropName, String uncapPropName, LikeSearchOption option) {
        String validationMsg = String.valueOf(key.getConditionKey()) + " of " + this.getRealAliasName() + "." + colName;
        if (!key.isValidRegistration(cvalue, value, validationMsg)) {
            return;
        }
        if (option == null) {
            this.throwLikeSearchOptionNotFoundException(capPropName, value);
            return;
        }
        if (value == null || !option.isSplit()) {
            this.setupConditionValueAndRegisterWhereClause(key, value, cvalue, colName, capPropName, uncapPropName, option);
            return;
        }
        String[] strArray = option.generateSplitValueArray(value);
        if (!option.isAsOrSplit()) {
            int i = 0;
            while (i < strArray.length) {
                String currentValue = strArray[i];
                this.setupConditionValueAndRegisterWhereClause(key, currentValue, cvalue, colName, capPropName, uncapPropName, option);
                List<LikeSearchOption.LikeAsOrCallback> callbackList = option.getLikeAsOrCallbackList();
                if (!callbackList.isEmpty()) {
                    this.getSqlClause().makeAdditionalConditionAsOrEffective();
                    for (LikeSearchOption.LikeAsOrCallback likeAsOrCallback : callbackList) {
                        String additionalTargetPropertyName = likeAsOrCallback.getAdditionalTargetPropertyName();
                        String filteredValue = likeAsOrCallback.filterValue(currentValue);
                        LikeSearchOption optionDeepCopy = (LikeSearchOption)option.createDeepCopy();
                        optionDeepCopy.clearLikeAsOrCallback();
                        LikeSearchOption filteredOption = likeAsOrCallback.filterOption(optionDeepCopy);
                        this.invokeSetterLikeSearch(additionalTargetPropertyName, filteredValue, filteredOption);
                    }
                    this.getSqlClause().ignoreAdditionalConditionAsOr();
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < strArray.length) {
                String currentValue = strArray[i];
                if (i == 0) {
                    this.setupConditionValueAndRegisterWhereClause(key, currentValue, cvalue, colName, capPropName, uncapPropName, option);
                } else {
                    this.getSqlClause().makeAdditionalConditionAsOrEffective();
                    this.invokeSetterLikeSearch(uncapPropName, currentValue, option);
                }
                ++i;
            }
            this.getSqlClause().ignoreAdditionalConditionAsOr();
        }
    }

    protected void throwLikeSearchOptionNotFoundException(String capPropName, String value) {
        String msg = "Look! Read the message below." + this.getLineSeparator();
        msg = String.valueOf(msg) + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.getLineSeparator();
        msg = String.valueOf(msg) + "The likeSearchOption was Not Found! (Should not be null!)" + this.getLineSeparator();
        msg = String.valueOf(msg) + this.getLineSeparator();
        msg = String.valueOf(msg) + "[Advice]" + this.getLineSeparator();
        msg = String.valueOf(msg) + "Please confirm your method call:" + this.getLineSeparator();
        String beanName = this.getClass().getSimpleName();
        String methodName = "set" + capPropName + "_LikeSearch('" + value + "', likeSearchOption);";
        msg = String.valueOf(msg) + "    " + beanName + "." + methodName + this.getLineSeparator();
        msg = String.valueOf(msg) + "* * * * * * * * * */" + this.getLineSeparator();
        throw new RequiredOptionNotFoundException(msg);
    }

    protected void invokeSetterLikeSearch(String columnFlexibleName, Object value, LikeSearchOption option) {
        if (value == null) {
            return;
        }
        DBMeta dbmeta = DBMetaInstanceHandler.findDBMeta(this.getTableDbName());
        String columnCapPropName = this.initCap(dbmeta.findPropertyName(columnFlexibleName));
        String methodName = "set" + columnCapPropName + "_LikeSearch";
        Method method = null;
        try {
            method = this.getClass().getMethod(methodName, value.getClass(), LikeSearchOption.class);
        }
        catch (NoSuchMethodException e) {
            String msg = "The columnFlexibleName is not existing in this table: columnFlexibleName=" + columnFlexibleName;
            msg = String.valueOf(msg) + " tableName=" + this.getTableDbName() + " methodName=" + methodName;
            throw new RuntimeException(msg, e);
        }
        try {
            method.invoke((Object)this, value, option);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    protected void registerInScopeQuery(ConditionKey key, String value, ConditionValue cvalue, String colName, String capPropName, String uncapPropName, InScopeOption option) {
        if (key.isValidRegistration(cvalue, value, String.valueOf(key.getConditionKey()) + " of " + this.getRealAliasName() + "." + colName)) {
            if (value != null && option.isSplit()) {
                String[] strArray = option.generateSplitValueArray(value);
                ArrayList<String> realValueList = new ArrayList<String>();
                int i = 0;
                while (i < strArray.length) {
                    String currentValue = strArray[i];
                    realValueList.add(currentValue);
                    ++i;
                }
                this.setupConditionValueAndRegisterWhereClause(key, realValueList, cvalue, colName, capPropName, uncapPropName, option);
            } else {
                this.setupConditionValueAndRegisterWhereClause(key, value, cvalue, colName, capPropName, uncapPropName, option);
            }
        }
    }

    protected void registerInlineQuery(ConditionKey key, Object value, ConditionValue cvalue, String colName, String capPropName, String uncapPropName) {
        if (key.isValidRegistration(cvalue, value, String.valueOf(key.getConditionKey()) + " of " + this.getRealAliasName() + "." + colName)) {
            key.setupConditionValue(cvalue, value, this.getLocation(uncapPropName, key));
            if (this.isBaseQuery(this)) {
                this.getSqlClause().registerBaseTableInlineWhereClause(colName, key, cvalue);
            } else {
                this.getSqlClause().registerOuterJoinInlineWhereClause(this.getRealAliasName(), colName, key, cvalue, this._onClauseInline);
            }
        }
    }

    protected void registerInlineQuery(ConditionKey key, Object value, ConditionValue cvalue, String colName, String capPropName, String uncapPropName, ConditionOption option) {
        if (key.isValidRegistration(cvalue, value, String.valueOf(key.getConditionKey()) + " of " + this.getRealAliasName() + "." + colName)) {
            key.setupConditionValue(cvalue, value, this.getLocation(uncapPropName, key), option);
            if (this.isBaseQuery(this)) {
                this.getSqlClause().registerBaseTableInlineWhereClause(colName, key, cvalue, option);
            } else {
                this.getSqlClause().registerOuterJoinInlineWhereClause(this.getRealAliasName(), colName, key, cvalue, option, this._onClauseInline);
            }
        }
    }

    protected void registerInScopeSubQuery(ConditionQuery subQuery, String columnName, String relatedColumnName, String propertyName) {
        this.registerInScopeSubQuery(subQuery, columnName, relatedColumnName, propertyName, null);
    }

    protected void registerNotInScopeSubQuery(ConditionQuery subQuery, String columnName, String relatedColumnName, String propertyName) {
        this.registerInScopeSubQuery(subQuery, columnName, relatedColumnName, propertyName, "not");
    }

    protected void registerInScopeSubQuery(ConditionQuery subQuery, String columnName, String relatedColumnName, String propertyName, String inScopeOption) {
        this.assertObjectNotNull("InScopeSubQyery(" + columnName + ")", subQuery);
        inScopeOption = inScopeOption != null ? String.valueOf(inScopeOption) + " " : "";
        String realColumnName = this.getInScopeSubQueryRealColumnName(columnName);
        String subQueryClause = this.getInScopeSubQuerySql(subQuery, relatedColumnName, propertyName);
        String clause = null;
        if (this.getSqlClause().isFormatClauseEffective()) {
            String ln = this.getLineSeparator();
            int subQueryLevel = subQuery.getSubQueryLevel();
            String subQueryIdentity = String.valueOf(propertyName) + "[" + subQueryLevel + "]";
            String beginMark = String.valueOf(this.getSqlClause().resolveSubQueryBeginMark(subQueryIdentity)) + ln;
            String endMark = this.getSqlClause().resolveSubQueryEndMark(subQueryIdentity);
            String endIndent = "       ";
            clause = String.valueOf(realColumnName) + " " + inScopeOption + "in (" + beginMark + subQueryClause + ln + endIndent + ")" + endMark;
        } else {
            clause = String.valueOf(realColumnName) + " " + inScopeOption + "in (" + subQueryClause + ")";
        }
        this.registerWhereClause(clause);
    }

    protected String getInScopeSubQueryRealColumnName(String columnName) {
        return this.getRealColumnName(columnName);
    }

    protected String getInScopeSubQuerySql(ConditionQuery subQuery, String relatedColumnName, String propertyName) {
        String selectClause = "select " + this.getSqlClause().getLocalTableAliasName() + "." + relatedColumnName;
        String fromWhereClause = subQuery.getSqlClause().getClauseFromWhereWithUnionTemplate();
        fromWhereClause = this.replaceString(fromWhereClause, ".conditionQuery.", "." + this.getLocationBase(propertyName) + ".");
        fromWhereClause = this.replaceString(fromWhereClause, this.getSqlClause().getUnionSelectClauseMark(), selectClause);
        fromWhereClause = this.replaceString(fromWhereClause, this.getSqlClause().getUnionWhereClauseMark(), "");
        fromWhereClause = this.replaceString(fromWhereClause, this.getSqlClause().getUnionWhereFirstConditionMark(), "");
        return String.valueOf(selectClause) + " " + fromWhereClause;
    }

    protected void registerExistsSubQuery(ConditionQuery subQuery, String columnName, String relatedColumnName, String propertyName) {
        this.registerExistsSubQuery(subQuery, columnName, relatedColumnName, propertyName, null);
    }

    protected void registerNotExistsSubQuery(ConditionQuery subQuery, String columnName, String relatedColumnName, String propertyName) {
        this.registerExistsSubQuery(subQuery, columnName, relatedColumnName, propertyName, "not");
    }

    protected void registerExistsSubQuery(ConditionQuery subQuery, String columnName, String relatedColumnName, String propertyName, String existsOption) {
        this.assertObjectNotNull("ExistsSubQyery(" + columnName + ")", subQuery);
        existsOption = existsOption != null ? String.valueOf(existsOption) + " " : "";
        String realColumnName = this.getExistsSubQueryRealColumnName(columnName);
        String subQueryClause = this.getExistsSubQuerySql(subQuery, realColumnName, relatedColumnName, propertyName);
        String clause = null;
        if (this.getSqlClause().isFormatClauseEffective()) {
            String ln = this.getLineSeparator();
            int subQueryLevel = subQuery.getSubQueryLevel();
            String subQueryIdentity = String.valueOf(propertyName) + "[" + subQueryLevel + "]";
            String beginMark = String.valueOf(this.getSqlClause().resolveSubQueryBeginMark(subQueryIdentity)) + ln;
            String endMark = this.getSqlClause().resolveSubQueryEndMark(subQueryIdentity);
            String endIndent = "       ";
            clause = String.valueOf(existsOption) + "exists (" + beginMark + subQueryClause + ln + endIndent + ")" + endMark;
        } else {
            clause = String.valueOf(existsOption) + "exists (" + subQueryClause + ")";
        }
        this.registerWhereClause(clause);
    }

    protected String getExistsSubQueryRealColumnName(String columnName) {
        return this.getRealColumnName(columnName);
    }

    protected String getExistsSubQuerySql(ConditionQuery subQuery, String realColumnName, String relatedColumnName, String propertyName) {
        int subQueryLevel = subQuery.getSubQueryLevel();
        if (this._subQueryLevel <= subQueryLevel) {
            this._subQueryLevel = subQueryLevel + 1;
        }
        String tableAliasName = "dfsublocal_" + subQueryLevel;
        String selectClause = "select " + tableAliasName + "." + relatedColumnName;
        String fromWhereClause = subQuery.getSqlClause().getClauseFromWhereWithWhereUnionTemplate();
        fromWhereClause = this.replaceString(fromWhereClause, "dflocal", tableAliasName);
        fromWhereClause = this.replaceString(fromWhereClause, ".conditionQuery.", "." + this.getLocationBase(propertyName) + ".");
        String joinCondition = String.valueOf(tableAliasName) + "." + relatedColumnName + " = " + realColumnName;
        String firstConditionAfter = " and ";
        if (this.getSqlClause().isFormatClauseEffective()) {
            firstConditionAfter = String.valueOf(this.getLineSeparator()) + "   and ";
        }
        fromWhereClause = this.replaceString(fromWhereClause, this.getSqlClause().getWhereClauseMark(), "where " + joinCondition);
        fromWhereClause = this.replaceString(fromWhereClause, this.getSqlClause().getWhereFirstConditionMark(), String.valueOf(joinCondition) + firstConditionAfter);
        fromWhereClause = this.replaceString(fromWhereClause, this.getSqlClause().getUnionSelectClauseMark(), selectClause);
        fromWhereClause = this.replaceString(fromWhereClause, this.getSqlClause().getUnionWhereClauseMark(), "where " + joinCondition);
        fromWhereClause = this.replaceString(fromWhereClause, this.getSqlClause().getUnionWhereFirstConditionMark(), String.valueOf(joinCondition) + firstConditionAfter);
        return String.valueOf(selectClause) + " " + fromWhereClause;
    }

    protected void registerDeriveSubQuery(String function, ConditionQuery subQuery, String columnName, String relatedColumnName, String propertyName, String aliasName) {
        String clause;
        this.assertObjectNotNull("DeriveSubQuery(" + columnName + ")", subQuery);
        String realColumnName = this.getDeriveSubQueryRealColumnName(columnName);
        String subQueryClause = this.getDeriveSubQuerySql(function, subQuery, realColumnName, relatedColumnName, propertyName, aliasName);
        if (this.getSqlClause().isFormatClauseEffective()) {
            String ln = this.getLineSeparator();
            int subQueryLevel = subQuery.getSubQueryLevel();
            String subQueryIdentity = String.valueOf(propertyName) + "[" + subQueryLevel + "]";
            String beginMark = String.valueOf(this.getSqlClause().resolveSubQueryBeginMark(subQueryIdentity)) + ln;
            String endMark = this.getSqlClause().resolveSubQueryEndMark(subQueryIdentity);
            String endIndent = "       ";
            clause = "(" + beginMark + subQueryClause + ln + "       " + ") as " + aliasName + endMark;
        } else {
            clause = "(" + subQueryClause + ") as " + aliasName;
        }
        this.getSqlClause().specifyDeriveSubQuery(aliasName, clause);
    }

    protected String getDeriveSubQueryRealColumnName(String columnName) {
        return this.getRealColumnName(columnName);
    }

    protected String getDeriveSubQuerySql(String function, ConditionQuery subQuery, String realColumnName, String relatedColumnName, String propertyName, String aliasName) {
        int subQueryLevel = subQuery.getSubQueryLevel();
        if (this._subQueryLevel <= subQueryLevel) {
            this._subQueryLevel = subQueryLevel + 1;
        }
        String tableAliasName = "dfsublocal_" + subQueryLevel;
        String deriveColumnName = subQuery.getSqlClause().getSpecifiedColumnNameAsOne();
        if (deriveColumnName == null || deriveColumnName.trim().length() == 0) {
            this.throwDeriveReferrerInvalidColumnSpecificationException(function, aliasName);
        }
        this.assertDeriveReferrerColumnType(function, subQuery, deriveColumnName);
        subQuery.getSqlClause().clearSpecifiedSelectColumn();
        String selectClause = "select " + function + "(" + tableAliasName + "." + deriveColumnName + ")";
        String fromWhereClause = subQuery.getSqlClause().getClauseFromWhereWithWhereUnionTemplate();
        fromWhereClause = this.replaceString(fromWhereClause, "dflocal", tableAliasName);
        fromWhereClause = this.replaceString(fromWhereClause, ".conditionQuery.", "." + this.getLocationBase(propertyName) + ".");
        String joinCondition = String.valueOf(tableAliasName) + "." + relatedColumnName + " = " + realColumnName;
        String firstConditionAfter = " and ";
        if (this.getSqlClause().isFormatClauseEffective()) {
            firstConditionAfter = String.valueOf(this.getLineSeparator()) + "   and ";
        }
        fromWhereClause = this.replaceString(fromWhereClause, this.getSqlClause().getWhereClauseMark(), "where " + joinCondition);
        fromWhereClause = this.replaceString(fromWhereClause, this.getSqlClause().getWhereFirstConditionMark(), String.valueOf(joinCondition) + firstConditionAfter);
        fromWhereClause = this.replaceString(fromWhereClause, this.getSqlClause().getUnionSelectClauseMark(), selectClause);
        fromWhereClause = this.replaceString(fromWhereClause, this.getSqlClause().getUnionWhereClauseMark(), "where " + joinCondition);
        fromWhereClause = this.replaceString(fromWhereClause, this.getSqlClause().getUnionWhereFirstConditionMark(), String.valueOf(joinCondition) + firstConditionAfter);
        return String.valueOf(selectClause) + " " + fromWhereClause;
    }

    protected void throwDeriveReferrerInvalidColumnSpecificationException(String function, String aliasName) {
        String msg = "Look! Read the message below." + this.getLineSeparator();
        msg = String.valueOf(msg) + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.getLineSeparator();
        msg = String.valueOf(msg) + "The specified the column for derive-referrer was Invalid!" + this.getLineSeparator();
        msg = String.valueOf(msg) + this.getLineSeparator();
        msg = String.valueOf(msg) + "[Advice]" + this.getLineSeparator();
        msg = String.valueOf(msg) + " You should call specify().column[TargetColumn]() only once." + this.getLineSeparator();
        msg = String.valueOf(msg) + "  For example:" + this.getLineSeparator();
        msg = String.valueOf(msg) + "    " + this.getLineSeparator();
        msg = String.valueOf(msg) + "    [Wrong]" + this.getLineSeparator();
        msg = String.valueOf(msg) + "    /- - - - - - - - - - - - - - - - - - - - " + this.getLineSeparator();
        msg = String.valueOf(msg) + "    MemberCB cb = new MemberCB();" + this.getLineSeparator();
        msg = String.valueOf(msg) + "    cb.specify().derivePurchaseList()." + function + "(new SubQuery<PurchaseCB>() {" + this.getLineSeparator();
        msg = String.valueOf(msg) + "        public void query(PurchaseCB subCB) {" + this.getLineSeparator();
        msg = String.valueOf(msg) + "            // *No! It's empty!" + this.getLineSeparator();
        msg = String.valueOf(msg) + "        }" + this.getLineSeparator();
        msg = String.valueOf(msg) + "    }, \"LATEST_PURCHASE_DATETIME\");" + this.getLineSeparator();
        msg = String.valueOf(msg) + "    - - - - - - - - - -/" + this.getLineSeparator();
        msg = String.valueOf(msg) + "    " + this.getLineSeparator();
        msg = String.valueOf(msg) + "    [Wrong]" + this.getLineSeparator();
        msg = String.valueOf(msg) + "    /- - - - - - - - - - - - - - - - - - - - " + this.getLineSeparator();
        msg = String.valueOf(msg) + "    MemberCB cb = new MemberCB();" + this.getLineSeparator();
        msg = String.valueOf(msg) + "    cb.specify().derivePurchaseList()." + function + "(new SubQuery<PurchaseCB>() {" + this.getLineSeparator();
        msg = String.valueOf(msg) + "        public void query(PurchaseCB subCB) {" + this.getLineSeparator();
        msg = String.valueOf(msg) + "            subCB.specify().columnPurchaseDatetime();" + this.getLineSeparator();
        msg = String.valueOf(msg) + "            subCB.specify().columnPurchaseCount(); // *No! It's duplicated!" + this.getLineSeparator();
        msg = String.valueOf(msg) + "        }" + this.getLineSeparator();
        msg = String.valueOf(msg) + "    }, \"LATEST_PURCHASE_DATETIME\");" + this.getLineSeparator();
        msg = String.valueOf(msg) + "    - - - - - - - - - -/" + this.getLineSeparator();
        msg = String.valueOf(msg) + "    " + this.getLineSeparator();
        msg = String.valueOf(msg) + "    [Good!]" + this.getLineSeparator();
        msg = String.valueOf(msg) + "    /- - - - - - - - - - - - - - - - - - - - " + this.getLineSeparator();
        msg = String.valueOf(msg) + "    MemberCB cb = new MemberCB();" + this.getLineSeparator();
        msg = String.valueOf(msg) + "    cb.specify().derivePurchaseList()." + function + "(new SubQuery<PurchaseCB>() {" + this.getLineSeparator();
        msg = String.valueOf(msg) + "        public void query(PurchaseCB subCB) {" + this.getLineSeparator();
        msg = String.valueOf(msg) + "            subCB.specify().columnPurchaseDatetime(); // *Point!" + this.getLineSeparator();
        msg = String.valueOf(msg) + "        }" + this.getLineSeparator();
        msg = String.valueOf(msg) + "    }, \"LATEST_PURCHASE_DATETIME\");" + this.getLineSeparator();
        msg = String.valueOf(msg) + "    - - - - - - - - - -/" + this.getLineSeparator();
        msg = String.valueOf(msg) + this.getLineSeparator();
        msg = String.valueOf(msg) + "[Alias Name]" + this.getLineSeparator() + aliasName + this.getLineSeparator();
        msg = String.valueOf(msg) + "* * * * * * * * * */";
        throw new DeriveReferrerInvalidColumnSpecificationException(msg);
    }

    protected void assertDeriveReferrerColumnType(String function, ConditionQuery subQuery, String deriveColumnName) {
        DBMeta dbmeta = DBMetaInstanceHandler.findDBMeta(subQuery.getTableDbName());
        Class<?> deriveColumnType = dbmeta.findColumnInfo(deriveColumnName).getPropertyType();
        if (("sum".equalsIgnoreCase(function) || "avg".equalsIgnoreCase(function)) && !Number.class.isAssignableFrom(deriveColumnType)) {
            this.throwDeriveReferrerUnmatchedColumnTypeException(function, deriveColumnName, deriveColumnType);
        }
    }

    protected void throwDeriveReferrerUnmatchedColumnTypeException(String function, String deriveColumnName, Class<?> deriveColumnType) {
        String msg = "Look! Read the message below." + this.getLineSeparator();
        msg = String.valueOf(msg) + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.getLineSeparator();
        msg = String.valueOf(msg) + "The type of the specified the column unmatched with the function!" + this.getLineSeparator();
        msg = String.valueOf(msg) + this.getLineSeparator();
        msg = String.valueOf(msg) + "[Advice]" + this.getLineSeparator();
        msg = String.valueOf(msg) + "You should confirm the list as follow:" + this.getLineSeparator();
        msg = String.valueOf(msg) + "    max()   : String, Number, Date" + this.getLineSeparator();
        msg = String.valueOf(msg) + "    min()   : String, Number, Date" + this.getLineSeparator();
        msg = String.valueOf(msg) + "    sum()   : Number" + this.getLineSeparator();
        msg = String.valueOf(msg) + "    avg()   : Number" + this.getLineSeparator();
        msg = String.valueOf(msg) + "    count() : String, Number, Date" + this.getLineSeparator();
        msg = String.valueOf(msg) + this.getLineSeparator();
        msg = String.valueOf(msg) + "[Function]" + this.getLineSeparator() + function + this.getLineSeparator();
        msg = String.valueOf(msg) + this.getLineSeparator();
        msg = String.valueOf(msg) + "[Derive Column]" + this.getLineSeparator() + deriveColumnName + "(" + deriveColumnType.getName() + ")" + this.getLineSeparator();
        msg = String.valueOf(msg) + "* * * * * * * * * */";
        throw new DeriveReferrerUnmatchedColumnTypeException(msg);
    }

    protected void setupConditionValueAndRegisterWhereClause(ConditionKey key, Object value, ConditionValue cvalue, String colName, String capPropName, String uncapPropName) {
        key.setupConditionValue(cvalue, value, this.getLocation(uncapPropName, key));
        this.getSqlClause().registerWhereClause(this.getRealColumnName(colName), key, cvalue);
    }

    protected void setupConditionValueAndRegisterWhereClause(ConditionKey key, Object value, ConditionValue cvalue, String colName, String capPropName, String uncapPropName, ConditionOption option) {
        key.setupConditionValue(cvalue, value, this.getLocation(uncapPropName, key), option);
        this.getSqlClause().registerWhereClause(this.getRealColumnName(colName), key, cvalue, option);
    }

    protected void registerWhereClause(String whereClause) {
        this.getSqlClause().registerWhereClause(whereClause);
    }

    protected void registerInlineWhereClause(String whereClause) {
        if (this.isBaseQuery(this)) {
            this.getSqlClause().registerBaseTableInlineWhereClause(whereClause);
        } else {
            this.getSqlClause().registerOuterJoinInlineWhereClause(this.getRealAliasName(), whereClause, this._onClauseInline);
        }
    }

    public void registerUnionQuery(ConditionQuery unionQuery, boolean unionAll, String unionQueryPropertyName) {
        String unionQueryClause = this.getUnionQuerySql(unionQuery, unionQueryPropertyName);
        this.getSqlClause().registerUnionQuery(unionQueryClause, unionAll);
    }

    protected String getUnionQuerySql(ConditionQuery unionQuery, String unionQueryPropertyName) {
        String unionQueryClause;
        String fromClause = unionQuery.getSqlClause().getFromClause();
        String whereClause = unionQuery.getSqlClause().getWhereClause();
        if (whereClause.trim().length() <= 0) {
            unionQueryClause = String.valueOf(fromClause) + " " + this.getSqlClause().getUnionWhereClauseMark();
        } else {
            int whereIndex = whereClause.indexOf("where ");
            if (whereIndex < 0) {
                String msg = "The whereClause should have 'where' string: " + whereClause;
                throw new IllegalStateException(msg);
            }
            int clauseIndex = whereIndex + "where ".length();
            String mark = this.getSqlClause().getUnionWhereFirstConditionMark();
            unionQueryClause = String.valueOf(fromClause) + " " + whereClause.substring(0, clauseIndex) + mark + whereClause.substring(clauseIndex);
        }
        String oldStr = ".conditionQuery.";
        String newStr = ".conditionQuery." + unionQueryPropertyName + ".";
        return this.replaceString(unionQueryClause, ".conditionQuery.", newStr);
    }

    public void withNullsFirst() {
        this.getSqlClause().addNullsFirstToPreviousOrderBy();
    }

    public void withNullsLast() {
        this.getSqlClause().addNullsLastToPreviousOrderBy();
    }

    protected void registerSpecifiedDerivedOrderBy_Asc(String aliasName) {
        if (!this.getSqlClause().hasSpecifiedDeriveSubQuery(aliasName)) {
            this.throwSpecifiedDerivedOrderByAliasNameNotFoundException(aliasName);
        }
        this.getSqlClause().registerOrderBy(aliasName, null, true);
    }

    protected void registerSpecifiedDerivedOrderBy_Desc(String aliasName) {
        if (!this.getSqlClause().hasSpecifiedDeriveSubQuery(aliasName)) {
            this.throwSpecifiedDerivedOrderByAliasNameNotFoundException(aliasName);
        }
        this.getSqlClause().registerOrderBy(aliasName, null, false);
    }

    protected void throwSpecifiedDerivedOrderByAliasNameNotFoundException(String aliasName) {
        String msg = "Look! Read the message below." + this.getLineSeparator();
        msg = String.valueOf(msg) + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.getLineSeparator();
        msg = String.valueOf(msg) + "The aliasName was Not Found in specified alias names." + this.getLineSeparator();
        msg = String.valueOf(msg) + this.getLineSeparator();
        msg = String.valueOf(msg) + "[Advice]" + this.getLineSeparator();
        msg = String.valueOf(msg) + "You should specified an alias name that is the same as one in specify-derived-referrer." + this.getLineSeparator();
        msg = String.valueOf(msg) + "  For example:" + this.getLineSeparator();
        msg = String.valueOf(msg) + "    " + this.getLineSeparator();
        msg = String.valueOf(msg) + "    [Wrong]" + this.getLineSeparator();
        msg = String.valueOf(msg) + "    /- - - - - - - - - - - - - - - - - - - - " + this.getLineSeparator();
        msg = String.valueOf(msg) + "    MemberCB cb = new MemberCB();" + this.getLineSeparator();
        msg = String.valueOf(msg) + "    cb.specify().derivePurchaseList().max(new SubQuery<PurchaseCB>() {" + this.getLineSeparator();
        msg = String.valueOf(msg) + "        public void query(PurchaseCB subCB) {" + this.getLineSeparator();
        msg = String.valueOf(msg) + "            subCB.specify().specifyProduct().columnProductName(); // *No!" + this.getLineSeparator();
        msg = String.valueOf(msg) + "        }" + this.getLineSeparator();
        msg = String.valueOf(msg) + "    }, \"LATEST_PURCHASE_DATETIME\");" + this.getLineSeparator();
        msg = String.valueOf(msg) + "    cb.query().addSpecifiedDerivedOrderBy_Desc(\"WRONG_NAME_DATETIME\");" + this.getLineSeparator();
        msg = String.valueOf(msg) + "    - - - - - - - - - -/" + this.getLineSeparator();
        msg = String.valueOf(msg) + "    " + this.getLineSeparator();
        msg = String.valueOf(msg) + "    [Good!]" + this.getLineSeparator();
        msg = String.valueOf(msg) + "    /- - - - - - - - - - - - - - - - - - - - " + this.getLineSeparator();
        msg = String.valueOf(msg) + "    MemberCB cb = new MemberCB();" + this.getLineSeparator();
        msg = String.valueOf(msg) + "    cb.specify().derivePurchaseList().max(new SubQuery<PurchaseCB>() {" + this.getLineSeparator();
        msg = String.valueOf(msg) + "        public void query(PurchaseCB subCB) {" + this.getLineSeparator();
        msg = String.valueOf(msg) + "            subCB.specify().columnPurchaseDatetime();// *Point!" + this.getLineSeparator();
        msg = String.valueOf(msg) + "        }" + this.getLineSeparator();
        msg = String.valueOf(msg) + "    }, \"LATEST_PURCHASE_DATETIME\");" + this.getLineSeparator();
        msg = String.valueOf(msg) + "    cb.query().addSpecifiedDerivedOrderBy_Desc(\"LATEST_PURCHASE_DATETIME\");" + this.getLineSeparator();
        msg = String.valueOf(msg) + "    - - - - - - - - - -/" + this.getLineSeparator();
        msg = String.valueOf(msg) + this.getLineSeparator();
        msg = String.valueOf(msg) + "[Not Found Alias Name]" + this.getLineSeparator() + aliasName + this.getLineSeparator();
        msg = String.valueOf(msg) + "* * * * * * * * * */";
        throw new SpecifiedDerivedOrderByAliasNameNotFoundException(msg);
    }

    protected void registerOrderBy(String columnName, boolean ascOrDesc) {
        this.getSqlClause().registerOrderBy(this.getRealColumnName(columnName), null, ascOrDesc);
    }

    protected void regOBA(String columnName) {
        this.registerOrderBy(columnName, true);
    }

    protected void regOBD(String columnName) {
        this.registerOrderBy(columnName, false);
    }

    protected String resolveJoinAliasName(String relationPath, int nestLevel) {
        return this.getSqlClause().resolveJoinAliasName(relationPath, nestLevel);
    }

    protected String resolveNestLevelExpression(String name) {
        return this.getSqlClause().resolveNestLevelExpression(name, this.getNestLevel());
    }

    protected String resolveNextRelationPath(String tableName, String relationPropertyName) {
        int relationNo = this.getSqlClause().resolveRelationNo(tableName, relationPropertyName);
        String nextRelationPath = "_" + relationNo;
        if (this._relationPath != null) {
            nextRelationPath = String.valueOf(this._relationPath) + nextRelationPath;
        }
        return nextRelationPath;
    }

    protected String prepareFixedCondition(String fixedCondition, String localAliasName, String foreignAliasName) {
        fixedCondition = this.replaceString(fixedCondition, "$$alias$$", foreignAliasName);
        fixedCondition = this.replaceString(fixedCondition, "$$foreignAlias$$", foreignAliasName);
        fixedCondition = this.replaceString(fixedCondition, "$$localAlias$$", localAliasName);
        return fixedCondition;
    }

    @Override
    public ConditionValue invokeValue(String columnFlexibleName) {
        this.assertStringNotNullAndNotTrimmedEmpty("columnFlexibleName", columnFlexibleName);
        DBMeta dbmeta = DBMetaInstanceHandler.findDBMeta(this.getTableDbName());
        String columnCapPropName = this.initCap(dbmeta.findPropertyName(columnFlexibleName));
        String methodName = "get" + columnCapPropName;
        Method method = this.helpGettingCQMethod(this, methodName, new Class[0], columnFlexibleName);
        return (ConditionValue)this.helpInvokingCQMethod(this, method, new Object[0]);
    }

    @Override
    public void invokeQuery(String columnFlexibleName, String conditionKeyName, Object value) {
        this.assertStringNotNullAndNotTrimmedEmpty("columnFlexibleName", columnFlexibleName);
        this.assertStringNotNullAndNotTrimmedEmpty("conditionKeyName", conditionKeyName);
        if (value == null) {
            return;
        }
        PropertyNameCQContainer container = this.helpExtractingPropertyNameCQContainer(columnFlexibleName);
        String propertyName = container.getPropertyName();
        ConditionQuery cq = container.getConditionQuery();
        DBMeta dbmeta = DBMetaInstanceHandler.findDBMeta(cq.getTableDbName());
        String columnCapPropName = this.initCap(dbmeta.findPropertyName(propertyName));
        String methodName = "set" + columnCapPropName + "_" + this.initCap(conditionKeyName);
        Method method = this.helpGettingCQMethod(cq, methodName, new Class[]{value.getClass()}, propertyName);
        this.helpInvokingCQMethod(cq, method, new Object[]{value});
    }

    @Override
    public void invokeOrderBy(String columnFlexibleName, boolean isAsc) {
        this.assertStringNotNullAndNotTrimmedEmpty("columnFlexibleName", columnFlexibleName);
        PropertyNameCQContainer container = this.helpExtractingPropertyNameCQContainer(columnFlexibleName);
        String propertyName = container.getPropertyName();
        ConditionQuery cq = container.getConditionQuery();
        String ascDesc = isAsc ? "Asc" : "Desc";
        DBMeta dbmeta = DBMetaInstanceHandler.findDBMeta(cq.getTableDbName());
        String columnCapPropName = this.initCap(dbmeta.findPropertyName(propertyName));
        String methodName = "addOrderBy_" + columnCapPropName + "_" + ascDesc;
        Method method = this.helpGettingCQMethod(cq, methodName, new Class[0], propertyName);
        this.helpInvokingCQMethod(cq, method, new Object[0]);
    }

    @Override
    public ConditionQuery invokeForeignCQ(String foreignPropertyName) {
        this.assertStringNotNullAndNotTrimmedEmpty("foreignPropertyName", foreignPropertyName);
        String methodName = "query" + this.initCap(foreignPropertyName);
        Method method = this.helpGettingCQMethod(this, methodName, new Class[0], foreignPropertyName);
        return (ConditionQuery)this.helpInvokingCQMethod(this, method, new Object[0]);
    }

    private PropertyNameCQContainer helpExtractingPropertyNameCQContainer(String name) {
        String[] strings = name.split("\\.");
        int length = strings.length;
        String propertyName = null;
        ConditionQuery cq = this;
        int index = 0;
        String[] stringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            if (length == index + 1) {
                propertyName = element;
                break;
            }
            cq = cq.invokeForeignCQ(element);
            ++index;
            ++n2;
        }
        return new PropertyNameCQContainer(propertyName, cq);
    }

    private Method helpGettingCQMethod(ConditionQuery cq, String methodName, Class<?>[] argTypes, String property) {
        try {
            return cq.getClass().getMethod(methodName, argTypes);
        }
        catch (NoSuchMethodException e) {
            String msg = "The method is not existing:";
            msg = String.valueOf(msg) + " methodName=" + methodName;
            msg = String.valueOf(msg) + " argTypes=" + this.convertObjectArrayToStringView(argTypes);
            msg = String.valueOf(msg) + " tableName=" + cq.getTableDbName();
            msg = String.valueOf(msg) + " property=" + property;
            throw new IllegalStateException(msg, e);
        }
    }

    private Object helpInvokingCQMethod(ConditionQuery cq, Method method, Object[] args) {
        try {
            return method.invoke((Object)cq, args);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e.getCause());
        }
    }

    protected String fRES(String value) {
        return this.filterRemoveEmptyString(value);
    }

    private String filterRemoveEmptyString(String value) {
        return value != null && !"".equals(value) ? value : null;
    }

    protected <PROPERTY_TYPE> List<PROPERTY_TYPE> cTL(Collection<PROPERTY_TYPE> col) {
        return this.convertToList(col);
    }

    private <PROPERTY_TYPE> List<PROPERTY_TYPE> convertToList(Collection<PROPERTY_TYPE> col) {
        if (col == null) {
            return null;
        }
        if (col instanceof List) {
            return this.filterRemoveNullOrEmptyValueFromList((List)col);
        }
        return this.filterRemoveNullOrEmptyValueFromList(new ArrayList<PROPERTY_TYPE>(col));
    }

    private <PROPERTY_TYPE> List<PROPERTY_TYPE> filterRemoveNullOrEmptyValueFromList(List<PROPERTY_TYPE> ls) {
        if (ls == null) {
            return null;
        }
        ArrayList<PROPERTY_TYPE> newList = new ArrayList<PROPERTY_TYPE>();
        for (PROPERTY_TYPE element : ls) {
            if (element == null || element instanceof String && ((String)element).length() == 0) continue;
            newList.add(element);
        }
        return newList;
    }

    public void doNss(NssCall callback) {
        String foreignPropertyName = callback.qf().getForeignPropertyName();
        String foreignTableAliasName = callback.qf().getRealAliasName();
        this.getSqlClause().registerSelectedSelectColumn(foreignTableAliasName, this.getTableDbName(), foreignPropertyName, this.getRelationPath());
        this.getSqlClause().registerSelectedForeignInfo(callback.qf().getRelationPath(), foreignPropertyName);
    }

    protected void registerOuterJoin(ConditionQuery cq, Map<String, String> joinOnMap) {
        this.getSqlClause().registerOuterJoin(cq.getTableSqlName(), cq.getRealAliasName(), joinOnMap);
    }

    protected final String replaceString(String text, String fromText, String toText) {
        return SimpleStringUtil.replace(text, fromText, toText);
    }

    protected String initCap(String str) {
        return SimpleStringUtil.initCap(str);
    }

    protected String getLineSeparator() {
        return SimpleSystemUtil.getLineSeparator();
    }

    protected String convertObjectArrayToStringView(Object[] objArray) {
        return TraceViewUtil.convertObjectArrayToStringView(objArray);
    }

    protected <KEY, VALUE> LinkedHashMap<KEY, VALUE> newLinkedHashMap() {
        return new LinkedHashMap();
    }

    protected void assertObjectNotNull(String variableName, Object value) {
        if (variableName == null) {
            String msg = "The value should not be null: variableName=" + variableName + " value=" + value;
            throw new IllegalArgumentException(msg);
        }
        if (value == null) {
            String msg = "The value should not be null: variableName=" + variableName;
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertColumnName(String columnName) {
        if (columnName == null) {
            String msg = "The columnName should not be null.";
            throw new IllegalArgumentException(msg);
        }
        if (columnName.trim().length() == 0) {
            String msg = "The columnName should not be empty-string.";
            throw new IllegalArgumentException(msg);
        }
        if (columnName.indexOf(",") >= 0) {
            String msg = "The columnName should not contain comma ',': " + columnName;
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertAliasName(String aliasName) {
        if (aliasName == null) {
            String msg = "The aliasName should not be null.";
            throw new IllegalArgumentException(msg);
        }
        if (aliasName.trim().length() == 0) {
            String msg = "The aliasName should not be empty-string.";
            throw new IllegalArgumentException(msg);
        }
        if (aliasName.indexOf(",") >= 0) {
            String msg = "The aliasName should not contain comma ',': " + aliasName;
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertStringNotNullAndNotTrimmedEmpty(String variableName, String value) {
        this.assertObjectNotNull("variableName", variableName);
        this.assertObjectNotNull("value", value);
        if (value.trim().length() == 0) {
            String msg = "The value should not be empty: variableName=" + variableName + " value=" + value;
            throw new IllegalArgumentException(msg);
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + ":{aliasName=" + this._aliasName + ", nestLevel=" + this._nestLevel + ", subQueryLevel=" + this._subQueryLevel + ", foreignPropertyName=" + this._foreignPropertyName + ", relationPath=" + this._relationPath + ", onClauseInline=" + this._onClauseInline + "}";
    }

    public static class DeriveReferrerInvalidColumnSpecificationException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public DeriveReferrerInvalidColumnSpecificationException(String msg) {
            super(msg);
        }
    }

    public static class DeriveReferrerUnmatchedColumnTypeException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public DeriveReferrerUnmatchedColumnTypeException(String msg) {
            super(msg);
        }
    }

    public static interface NssCall {
        public ConditionQuery qf();
    }

    private static class PropertyNameCQContainer {
        protected String _propertyName;
        protected ConditionQuery _cq;

        public PropertyNameCQContainer(String propertyName, ConditionQuery cq) {
            this._propertyName = propertyName;
            this._cq = cq;
        }

        public String getPropertyName() {
            return this._propertyName;
        }

        public ConditionQuery getConditionQuery() {
            return this._cq;
        }
    }

    public static class SpecifiedDerivedOrderByAliasNameNotFoundException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public SpecifiedDerivedOrderByAliasNameNotFoundException(String msg) {
            super(msg);
        }
    }
}

