/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.ea2ddl.dao.allcommon.bhv;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import jp.sourceforge.ea2ddl.dao.allcommon.BehaviorSelector;
import jp.sourceforge.ea2ddl.dao.allcommon.DaoSelector;
import jp.sourceforge.ea2ddl.dao.allcommon.Entity;
import jp.sourceforge.ea2ddl.dao.allcommon.bhv.BehaviorReadable;
import jp.sourceforge.ea2ddl.dao.allcommon.bhv.batch.TokenFileOutputOption;
import jp.sourceforge.ea2ddl.dao.allcommon.bhv.batch.TokenFileOutputResult;
import jp.sourceforge.ea2ddl.dao.allcommon.bhv.load.LoadReferrerOption;
import jp.sourceforge.ea2ddl.dao.allcommon.bhv.setup.ValueLabelBox;
import jp.sourceforge.ea2ddl.dao.allcommon.bhv.setup.ValueLabelSetupper;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.ConditionBean;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.ConditionBeanContext;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.ListResultBean;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.PagingBean;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.PagingHandler;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.PagingInvoker;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.PagingResultBean;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.ResultBeanBuilder;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.outsidesql.OutsideSqlDao;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.outsidesql.executor.OutsideSqlBasicExecutor;
import jp.sourceforge.ea2ddl.dao.allcommon.dbmeta.info.ColumnInfo;
import jp.sourceforge.ea2ddl.dao.allcommon.exception.DangerousResultSizeException;
import jp.sourceforge.ea2ddl.dao.allcommon.helper.token.file.FileMakingHeaderInfo;
import jp.sourceforge.ea2ddl.dao.allcommon.helper.token.file.FileMakingOption;
import jp.sourceforge.ea2ddl.dao.allcommon.helper.token.file.impl.FileMakingSimpleFacadeImpl;
import jp.sourceforge.ea2ddl.dao.allcommon.util.SimpleSystemUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBehaviorReadable
implements BehaviorReadable {
    protected BehaviorSelector _behaviorSelector;
    protected DaoSelector _daoSelector;

    @Override
    public int getCountAll() {
        return this.callGetCountAll();
    }

    @Override
    public int readCount(ConditionBean cb) {
        this.assertConditionBeanNotNull(cb);
        return this.callReadCount(cb);
    }

    @Override
    public Entity readEntity(ConditionBean cb) {
        this.assertConditionBeanNotNull(cb);
        ListResultBean<Entity> ls = this.readList(cb);
        if (ls.isEmpty()) {
            return null;
        }
        this.assertEntitySelectedAsOne(ls, cb);
        return (Entity)ls.get(0);
    }

    @Override
    public Entity readEntityWithDeletedCheck(ConditionBean cb) {
        this.assertConditionBeanNotNull(cb);
        ListResultBean<Entity> ls = this.readList(cb);
        this.assertEntityNotDeleted(ls, (Object)cb);
        this.assertEntitySelectedAsOne(ls, cb);
        return (Entity)ls.get(0);
    }

    protected <ENTITY extends Entity, CB extends ConditionBean> ENTITY helpSelectEntityInternally(CB cb, InternalSelectEntityCallback<ENTITY, CB> callback) {
        this.assertConditionBeanNotNull(cb);
        cb.checkSafetyResult(1);
        List<ENTITY> ls = null;
        try {
            ls = callback.callbackSelectList(cb);
        }
        catch (DangerousResultSizeException e) {
            this.throwEntityDuplicatedException("{Over safetyMaxResultSize '1'}", cb, e);
        }
        if (ls.isEmpty()) {
            return null;
        }
        this.assertEntitySelectedAsOne(ls, cb);
        return (ENTITY)((Entity)ls.get(0));
    }

    protected <ENTITY extends Entity, CB extends ConditionBean> ENTITY helpSelectEntityWithDeletedCheckInternally(CB cb, InternalSelectEntityWithDeletedCheckCallback<ENTITY, CB> callback) {
        this.assertConditionBeanNotNull(cb);
        cb.checkSafetyResult(1);
        List<ENTITY> ls = null;
        try {
            ls = callback.callbackSelectList(cb);
        }
        catch (DangerousResultSizeException e) {
            this.throwEntityDuplicatedException("{Over safetyMaxResultSize '1'}", cb, e);
        }
        this.assertEntityNotDeleted(ls, cb);
        this.assertEntitySelectedAsOne(ls, cb);
        return (ENTITY)((Entity)ls.get(0));
    }

    @Override
    public ListResultBean<Entity> readList(ConditionBean cb) {
        this.assertConditionBeanNotNull(cb);
        return new ResultBeanBuilder<Entity>(this.getTableDbName()).buildListResultBean(cb, this.callReadList(cb));
    }

    @Override
    public PagingResultBean<Entity> readPage(final ConditionBean cb) {
        this.assertConditionBeanNotNull(cb);
        PagingInvoker<Entity> invoker = new PagingInvoker<Entity>(this.getTableDbName());
        PagingHandler<Entity> handler = new PagingHandler<Entity>(){

            @Override
            public PagingBean getPagingBean() {
                return cb;
            }

            @Override
            public int count() {
                return AbstractBehaviorReadable.this.readCount(cb);
            }

            @Override
            public List<Entity> paging() {
                return AbstractBehaviorReadable.this.readList(cb);
            }
        };
        return invoker.invokePaging(handler);
    }

    protected void assertEntityNotDeleted(Entity entity, Object searchKey4Log) {
        if (entity == null) {
            this.throwEntityAlreadyDeletedException(searchKey4Log);
        }
    }

    protected void assertEntityNotDeleted(List ls, Object searchKey4Log) {
        if (ls == null || ls.isEmpty()) {
            this.throwEntityAlreadyDeletedException(searchKey4Log);
        }
    }

    protected void assertEntitySelectedAsOne(List ls, Object searchKey4Log) {
        if (ls == null || ls.isEmpty()) {
            this.throwEntityAlreadyDeletedException(searchKey4Log);
        }
        if (ls.size() > 1) {
            this.throwEntityDuplicatedException(String.valueOf(ls.size()), searchKey4Log, null);
        }
    }

    private void throwEntityAlreadyDeletedException(Object searchKey4Log) {
        ConditionBeanContext.throwEntityAlreadyDeletedException(searchKey4Log);
    }

    private void throwEntityDuplicatedException(String resultCountString, Object searchKey4Log, Throwable cause) {
        ConditionBeanContext.throwEntityDuplicatedException(resultCountString, searchKey4Log, cause);
    }

    public OutsideSqlBasicExecutor outsideSql() {
        this.assertDaoSelectorNotNull("outsideSql");
        OutsideSqlDao outsideSqlDao = this._daoSelector.select(OutsideSqlDao.class);
        return new OutsideSqlBasicExecutor(outsideSqlDao, this.getTableDbName());
    }

    private void assertDaoSelectorNotNull(String methodName) {
        if (this._daoSelector == null) {
            String msg = "Look! Read the message below." + this.getLineSeparator();
            msg = String.valueOf(msg) + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.getLineSeparator();
            msg = String.valueOf(msg) + "Not found the selector of dao as behavior's attributed!" + this.getLineSeparator();
            msg = String.valueOf(msg) + this.getLineSeparator();
            msg = String.valueOf(msg) + "[Advice]" + this.getLineSeparator();
            msg = String.valueOf(msg) + "Please confirm the definition of the selector at your 'dbflute.dicon'." + this.getLineSeparator();
            msg = String.valueOf(msg) + "It is precondition that '" + methodName + "()' needs the selector instance." + this.getLineSeparator();
            msg = String.valueOf(msg) + this.getLineSeparator();
            msg = String.valueOf(msg) + "[Your Behavior's Attributes]" + this.getLineSeparator();
            msg = String.valueOf(msg) + "  _behaviorSelector  : " + this._behaviorSelector + this.getLineSeparator();
            msg = String.valueOf(msg) + "  _daoSelector       : " + this._daoSelector + this.getLineSeparator();
            msg = String.valueOf(msg) + "* * * * * * * * * */" + this.getLineSeparator();
            throw new IllegalStateException(msg);
        }
    }

    public <ENTITY extends Entity> List<Map<String, Object>> createValueLabelList(List<ENTITY> entityList, ValueLabelSetupper<ENTITY> valueLabelSetupper) {
        ArrayList<Map<String, Object>> valueLabelList = new ArrayList<Map<String, Object>>();
        ValueLabelBox box = new ValueLabelBox();
        for (Entity entity : entityList) {
            HashMap<String, Object> valueLabel = new HashMap<String, Object>();
            valueLabelSetupper.setup(box, entity);
            valueLabel.put("value", box.getValue());
            valueLabel.put("label", box.getLabel());
            valueLabelList.add(valueLabel);
        }
        return valueLabelList;
    }

    @Override
    public BigDecimal readNextVal() {
        try {
            Method method = this.getClass().getMethod("selectNextVal", new Class[0]);
            Object sequenceObject = method.invoke((Object)this, new Object[0]);
            if (sequenceObject instanceof BigDecimal) {
                return (BigDecimal)sequenceObject;
            }
            return (BigDecimal)this.helpConvertingSequenceObject(BigDecimal.class, sequenceObject);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("The table does not have sequence: " + this.getTableDbName(), e);
        }
        catch (Exception e) {
            throw new RuntimeException("The selectNextVal() of the table threw the exception: " + this.getTableDbName(), e);
        }
    }

    protected Object helpConvertingSequenceObject(Class resultClass, Object sequenceObject) {
        try {
            Constructor constructor = resultClass.getConstructor(String.class);
            return constructor.newInstance(sequenceObject.toString());
        }
        catch (NoSuchMethodException constructor) {
        }
        catch (Exception e) {
            throw new RuntimeException("The readNextVal() of the table threw the exception: " + this.getTableDbName(), e);
        }
        try {
            Method method = resultClass.getMethod("valueOf", Long.TYPE);
            return method.invoke(null, Long.valueOf(sequenceObject.toString()));
        }
        catch (NoSuchMethodException method) {
        }
        catch (Exception e) {
            throw new RuntimeException("The readNextVal() of the table threw the exception: " + this.getTableDbName(), e);
        }
        String msg = "Cannot convert sequenceObject to resultClass:";
        msg = String.valueOf(msg) + " resultClass=" + resultClass + " sequenceObjectType=" + sequenceObject.getClass();
        throw new IllegalStateException(msg);
    }

    protected <LOCAL_ENTITY extends Entity, PK, REFERRER_CB extends ConditionBean, REFERRER_ENTITY extends Entity> void helpLoadReferrerInternally(List<LOCAL_ENTITY> localEntityList, LoadReferrerOption<REFERRER_CB, REFERRER_ENTITY> loadReferrerOption, InternalLoadReferrerCallback<LOCAL_ENTITY, PK, REFERRER_CB, REFERRER_ENTITY> callback) {
        this.doHelpLoadReferrerInternally(localEntityList, loadReferrerOption, callback);
    }

    protected <LOCAL_ENTITY extends Entity, PK, REFERRER_CB extends ConditionBean, REFERRER_ENTITY extends Entity> void doHelpLoadReferrerInternally(List<LOCAL_ENTITY> localEntityList, LoadReferrerOption<REFERRER_CB, REFERRER_ENTITY> loadReferrerOption, InternalLoadReferrerCallback<LOCAL_ENTITY, PK, REFERRER_CB, REFERRER_ENTITY> callback) {
        PK referrerListKey;
        this.assertBehaviorSelectorNotNull("loadReferrer");
        this.assertObjectNotNull("localEntityList", localEntityList);
        this.assertObjectNotNull("loadReferrerOption", loadReferrerOption);
        if (localEntityList.isEmpty()) {
            return;
        }
        LinkedHashMap<PK, Entity> pkLocalEntityMap = new LinkedHashMap<PK, Entity>();
        ArrayList<PK> pkList = new ArrayList<PK>();
        for (Entity localEntity : localEntityList) {
            PK primaryKeyValue = callback.callbackBase_getPrimaryKeyValue(localEntity);
            pkList.add(callback.callbackBase_getPrimaryKeyValue(localEntity));
            pkLocalEntityMap.put(this.toLowerCasePrimaryKeyIfString(primaryKeyValue), localEntity);
        }
        REFERRER_CB cb = loadReferrerOption.getReferrerConditionBean() != null ? loadReferrerOption.getReferrerConditionBean() : callback.callbackReferrer_newMyConditionBean();
        callback.callbackReferrer_queryForeignKeyInScope(cb, pkList);
        loadReferrerOption.delegateKeyConditionExchangingFirstWhereClauseForLastOne(cb);
        if (!loadReferrerOption.isStopOrderByKey()) {
            callback.callbackReferrer_queryAddOrderByForeignKeyAsc(cb);
            cb.getSqlComponentOfOrderByClause().exchangeFirstOrderByElementForLastOne();
        }
        loadReferrerOption.delegateConditionBeanSettingUp(cb);
        List<REFERRER_ENTITY> referrerList = callback.callbackReferrer_selectList(cb);
        loadReferrerOption.delegateEntitySettingUp(referrerList);
        LinkedHashMap pkReferrerListMap = new LinkedHashMap();
        for (Entity referrerEntity : referrerList) {
            PK foreignKeyValue = callback.callbackReferrer_getForeignKeyValue(referrerEntity);
            referrerListKey = this.toLowerCasePrimaryKeyIfString(foreignKeyValue);
            if (!pkReferrerListMap.containsKey(referrerListKey)) {
                pkReferrerListMap.put(referrerListKey, new ArrayList());
            }
            ((List)pkReferrerListMap.get(referrerListKey)).add(referrerEntity);
            Entity localEntity = (Entity)pkLocalEntityMap.get(referrerListKey);
            callback.callbackReferrer_setForeignEntity(referrerEntity, localEntity);
        }
        for (Entity localEntity : localEntityList) {
            PK primaryKey = callback.callbackBase_getPrimaryKeyValue(localEntity);
            referrerListKey = this.toLowerCasePrimaryKeyIfString(primaryKey);
            if (pkReferrerListMap.containsKey(referrerListKey)) {
                callback.callbackBase_setReferrerList(localEntity, (List)pkReferrerListMap.get(referrerListKey));
                continue;
            }
            callback.callbackBase_setReferrerList(localEntity, new ArrayList());
        }
    }

    protected <PK> PK toLowerCasePrimaryKeyIfString(PK value) {
        return (PK)this.toLowerCaseIfString(value);
    }

    protected BehaviorSelector xgetBSFLR() {
        this.assertBehaviorSelectorNotNull("loadReferrer");
        return this.getBehaviorSelector();
    }

    private void assertBehaviorSelectorNotNull(String methodName) {
        if (this._behaviorSelector == null) {
            String msg = "Look! Read the message below." + this.getLineSeparator();
            msg = String.valueOf(msg) + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.getLineSeparator();
            msg = String.valueOf(msg) + "Not found the selector of behavior as behavior's attributed!" + this.getLineSeparator();
            msg = String.valueOf(msg) + this.getLineSeparator();
            msg = String.valueOf(msg) + "[Advice]" + this.getLineSeparator();
            msg = String.valueOf(msg) + "Please confirm the definition of the selector at your 'dbflute.dicon'." + this.getLineSeparator();
            msg = String.valueOf(msg) + "It is precondition that '" + methodName + "()' needs the selector instance." + this.getLineSeparator();
            msg = String.valueOf(msg) + this.getLineSeparator();
            msg = String.valueOf(msg) + "[Your Behavior's Attributes]" + this.getLineSeparator();
            msg = String.valueOf(msg) + "  _behaviorSelector  : " + this._behaviorSelector + this.getLineSeparator();
            msg = String.valueOf(msg) + "  _daoSelector       : " + this._daoSelector + this.getLineSeparator();
            msg = String.valueOf(msg) + "* * * * * * * * * */" + this.getLineSeparator();
            throw new IllegalStateException(msg);
        }
    }

    protected <LOCAL_ENTITY extends Entity, FOREIGN_ENTITY extends Entity> List<FOREIGN_ENTITY> helpPulloutInternally(List<LOCAL_ENTITY> localEntityList, InternalPulloutCallback<LOCAL_ENTITY, FOREIGN_ENTITY> callback) {
        this.assertObjectNotNull("localEntityList", localEntityList);
        LinkedHashSet<FOREIGN_ENTITY> foreignSet = new LinkedHashSet<FOREIGN_ENTITY>();
        for (Entity entity : localEntityList) {
            FOREIGN_ENTITY foreignEntity = callback.callbackGetForeignEntity(entity);
            if (foreignEntity == null || foreignSet.contains(foreignEntity)) continue;
            foreignSet.add(foreignEntity);
        }
        return new ArrayList(foreignSet);
    }

    public TokenFileOutputExecutor tokenFileOutput() throws FileNotFoundException, IOException {
        return new TokenFileOutputExecutor();
    }

    protected int callGetCountAll() {
        return this.readCount(this.newConditionBean());
    }

    protected List<Entity> callGetListAll() {
        return this.readList(this.newConditionBean());
    }

    protected int callReadCount(ConditionBean cb) {
        this.assertConditionBeanNotNull(cb);
        Class[] types = new Class[]{cb.getClass()};
        Method mtd = this.getMethod(this.getDaoReadable().getClass(), "selectCount", types);
        Object result = this.invoke(mtd, this.getDaoReadable(), new Object[]{cb});
        return (Integer)result;
    }

    protected List<Entity> callReadList(ConditionBean cb) {
        this.assertConditionBeanNotNull(cb);
        Class[] types = new Class[]{cb.getClass()};
        Method mtd = this.getMethod(this.getDaoReadable().getClass(), "selectList", types);
        Object result = this.invoke(mtd, this.getDaoReadable(), new Object[]{cb});
        return (List)result;
    }

    private Method getMethod(Class clazz, String methodName, Class[] argTypes) {
        try {
            return clazz.getMethod(methodName, argTypes);
        }
        catch (NoSuchMethodException ex) {
            String msg = "class=" + clazz + " method=" + methodName + "-" + Arrays.asList(argTypes);
            throw new RuntimeException(msg, ex);
        }
    }

    private Object invoke(Method method, Object target, Object[] args) {
        try {
            return method.invoke(target, args);
        }
        catch (InvocationTargetException ex) {
            Throwable t = ex.getCause();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            String msg = "target=" + target + " method=" + method + "-" + Arrays.asList(args);
            throw new RuntimeException(msg, ex);
        }
        catch (IllegalAccessException ex) {
            String msg = "target=" + target + " method=" + method + "-" + Arrays.asList(args);
            throw new RuntimeException(msg, ex);
        }
    }

    protected abstract boolean hasVersionNoValue(Entity var1);

    protected abstract boolean hasUpdateDateValue(Entity var1);

    protected Object toLowerCaseIfString(Object obj) {
        if (obj != null && obj instanceof String) {
            return ((String)obj).toLowerCase();
        }
        return obj;
    }

    protected String getLineSeparator() {
        return SimpleSystemUtil.getLineSeparator();
    }

    protected <ENTITY extends Entity> ENTITY helpDowncastInternally(Entity entity, Class<ENTITY> clazz) {
        this.assertObjectNotNull("entity", entity);
        this.assertObjectNotNull("clazz", clazz);
        try {
            return (ENTITY)entity;
        }
        catch (ClassCastException e) {
            String msg = "The entity should be " + clazz.getSimpleName() + " but it was: " + entity.getClass();
            throw new RuntimeException(msg, e);
        }
    }

    protected void assertObjectNotNull(String variableName, Object value) {
        if (variableName == null) {
            String msg = "The value should not be null: variableName=" + variableName + " value=" + value;
            throw new IllegalArgumentException(msg);
        }
        if (value == null) {
            String msg = "The value should not be null: variableName=" + variableName;
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertEntityNotNull(Entity entity) {
        this.assertObjectNotNull("entity", entity);
    }

    protected void assertConditionBeanNotNull(ConditionBean cb) {
        this.assertObjectNotNull("cb", cb);
    }

    protected void assertEntityNotNullAndHasPrimaryKeyValue(Entity entity) {
        this.assertEntityNotNull(entity);
        if (!entity.hasPrimaryKeyValue()) {
            String msg = "The entity must should primary-key: entity=" + entity;
            throw new IllegalArgumentException(String.valueOf(msg) + entity);
        }
    }

    protected void assertStringNotNullAndNotTrimmedEmpty(String variableName, String value) {
        this.assertObjectNotNull("variableName", variableName);
        this.assertObjectNotNull(variableName, value);
        if (value.trim().length() == 0) {
            String msg = "The value should not be empty: variableName=" + variableName + " value=" + value;
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertListNotNullAndEmpty(List ls) {
        this.assertObjectNotNull("ls", ls);
        if (!ls.isEmpty()) {
            String msg = "The list should be empty: ls=" + ls.toString();
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertListNotNullAndNotEmpty(List ls) {
        this.assertObjectNotNull("ls", ls);
        if (ls.isEmpty()) {
            String msg = "The list should not be empty: ls=" + ls.toString();
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertListNotNullAndHasOnlyOne(List ls) {
        this.assertObjectNotNull("ls", ls);
        if (ls.size() != 1) {
            String msg = "The list should contain only one object: ls=" + ls.toString();
            throw new IllegalArgumentException(msg);
        }
    }

    protected BehaviorSelector getBehaviorSelector() {
        return this._behaviorSelector;
    }

    public void setBehaviorSelector(BehaviorSelector behaviorSelector) {
        this._behaviorSelector = behaviorSelector;
    }

    protected DaoSelector getDaoSelector() {
        return this._daoSelector;
    }

    public void setDaoSelector(DaoSelector daoSelector) {
        this._daoSelector = daoSelector;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface InternalLoadReferrerCallback<LOCAL_ENTITY extends Entity, PK, REFERRER_CB extends ConditionBean, REFERRER_ENTITY extends Entity> {
        public PK callbackBase_getPrimaryKeyValue(LOCAL_ENTITY var1);

        public void callbackBase_setReferrerList(LOCAL_ENTITY var1, List<REFERRER_ENTITY> var2);

        public REFERRER_CB callbackReferrer_newMyConditionBean();

        public void callbackReferrer_queryForeignKeyInScope(REFERRER_CB var1, List<PK> var2);

        public void callbackReferrer_queryAddOrderByForeignKeyAsc(REFERRER_CB var1);

        public List<REFERRER_ENTITY> callbackReferrer_selectList(REFERRER_CB var1);

        public PK callbackReferrer_getForeignKeyValue(REFERRER_ENTITY var1);

        public void callbackReferrer_setForeignEntity(REFERRER_ENTITY var1, LOCAL_ENTITY var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface InternalPulloutCallback<LOCAL_ENTITY extends Entity, FOREIGN_ENTITY extends Entity> {
        public FOREIGN_ENTITY callbackGetForeignEntity(LOCAL_ENTITY var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface InternalSelectEntityCallback<ENTITY extends Entity, CB extends ConditionBean> {
        public List<ENTITY> callbackSelectList(CB var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface InternalSelectEntityWithDeletedCheckCallback<ENTITY extends Entity, CB extends ConditionBean> {
        public List<ENTITY> callbackSelectList(CB var1);
    }

    public class TokenFileOutputExecutor {
        public TokenFileOutputResult outputTokenFile(ConditionBean cb, String filename, TokenFileOutputOption tokenFileOutputOption) throws FileNotFoundException, IOException {
            AbstractBehaviorReadable.this.assertConditionBeanNotNull(cb);
            AbstractBehaviorReadable.this.assertStringNotNullAndNotTrimmedEmpty("filename", filename);
            AbstractBehaviorReadable.this.assertObjectNotNull("tokenFileOutputOption", tokenFileOutputOption);
            ListResultBean<Entity> ls = AbstractBehaviorReadable.this.readList(cb);
            ArrayList<List<String>> rowList = new ArrayList<List<String>>();
            for (Entity entity : ls) {
                List<String> valueList = AbstractBehaviorReadable.this.getDBMeta().convertToColumnStringValueList(entity);
                rowList.add(valueList);
            }
            FileMakingSimpleFacadeImpl fileMakingSimpleFacade = new FileMakingSimpleFacadeImpl();
            FileMakingOption fileMakingOption = tokenFileOutputOption.getFileMakingOption();
            FileMakingHeaderInfo fileMakingHeaderInfo = new FileMakingHeaderInfo();
            ArrayList<String> columnDbNameList = new ArrayList<String>();
            for (ColumnInfo columnInfo : AbstractBehaviorReadable.this.getDBMeta().getColumnInfoList()) {
                columnDbNameList.add(columnInfo.getColumnDbName());
            }
            fileMakingHeaderInfo.setColumnNameList(columnDbNameList);
            fileMakingOption.setFileMakingHeaderInfo(fileMakingHeaderInfo);
            fileMakingSimpleFacade.makeFromRowList(filename, rowList, fileMakingOption);
            TokenFileOutputResult tokeFileOutputResult = new TokenFileOutputResult();
            tokeFileOutputResult.setSelectedList(ls);
            return tokeFileOutputResult;
        }
    }
}

