/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.ea2ddl.dao.allcommon;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import jp.sourceforge.ea2ddl.dao.allcommon.BehaviorSelector;
import jp.sourceforge.ea2ddl.dao.allcommon.CacheAbstractSelector;
import jp.sourceforge.ea2ddl.dao.allcommon.DaoReadable;
import jp.sourceforge.ea2ddl.dao.allcommon.bhv.BehaviorReadable;
import jp.sourceforge.ea2ddl.dao.allcommon.dbmeta.DBMeta;
import jp.sourceforge.ea2ddl.dao.allcommon.dbmeta.DBMetaInstanceHandler;
import jp.sourceforge.ea2ddl.dao.allcommon.util.TraceViewUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheBehaviorSelector
extends CacheAbstractSelector
implements BehaviorSelector {
    private static final Log _log = LogFactory.getLog(CacheBehaviorSelector.class);
    protected Map<Class<? extends BehaviorReadable>, BehaviorReadable> _behaviorCache = new LinkedHashMap<Class<? extends BehaviorReadable>, BehaviorReadable>();

    @Override
    public void initializeConditionBeanMetaData() {
        Map<String, DBMeta> dbmetaMap = DBMetaInstanceHandler.getDBMetaMap();
        Collection<DBMeta> dbmetas = dbmetaMap.values();
        long before = 0L;
        if (_log.isInfoEnabled()) {
            before = System.currentTimeMillis();
            _log.info((Object)"/= = = = = = = = = = = = = = = = = initializeConditionBeanMetaData()");
        }
        for (DBMeta dbmeta : dbmetas) {
            BehaviorReadable bhv = this.byName(dbmeta.getTableDbName());
            DaoReadable dao = bhv.getDaoReadable();
            dao.initializeDaoMetaData("selectList");
        }
        if (_log.isInfoEnabled()) {
            long after = System.currentTimeMillis();
            _log.info((Object)("Initialized Count: " + dbmetas.size()));
            _log.info((Object)("= = = = = = = = = =/ [" + TraceViewUtil.convertToPerformanceView(after - before) + "]"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <BEHAVIOR extends BehaviorReadable> BEHAVIOR select(Class<BEHAVIOR> behaviorType) {
        if (this._behaviorCache.containsKey(behaviorType)) {
            return (BEHAVIOR)this._behaviorCache.get(behaviorType);
        }
        Map<Class<? extends BehaviorReadable>, BehaviorReadable> map = this._behaviorCache;
        synchronized (map) {
            if (this._behaviorCache.containsKey(behaviorType)) {
                return (BEHAVIOR)this._behaviorCache.get(behaviorType);
            }
            BehaviorReadable bhv = (BehaviorReadable)this.getComponent(behaviorType);
            this._behaviorCache.put(behaviorType, bhv);
            return (BEHAVIOR)bhv;
        }
    }

    @Override
    public BehaviorReadable byName(String tableFlexibleName) {
        this.assertStringNotNullAndNotTrimmedEmpty("tableFlexibleName", tableFlexibleName);
        DBMeta dbmeta = DBMetaInstanceHandler.findDBMeta(tableFlexibleName);
        return this.select(this.getBehaviorType(dbmeta));
    }

    protected Class<BehaviorReadable> getBehaviorType(DBMeta dbmeta) {
        Class<BehaviorReadable> behaviorType;
        String behaviorTypeName = dbmeta.getBehaviorTypeName();
        if (behaviorTypeName == null) {
            String msg = "The dbmeta.getBehaviorTypeName() should not return null: dbmeta=" + dbmeta;
            throw new IllegalStateException(msg);
        }
        try {
            behaviorType = Class.forName(behaviorTypeName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("The class does not exist: " + behaviorTypeName, e);
        }
        return behaviorType;
    }
}

