/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.ea2ddl.dao.allcommon;

import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccessContext {
    private static final ThreadLocal<AccessContext> threadLocal = new ThreadLocal();
    protected String accessUser;
    protected String accessProcess;
    protected String accessModule;
    protected Date accessDate;
    protected AccessDateProvider accessDateProvider;
    protected Timestamp accessTimestamp;
    protected AccessTimestampProvider accessTimestampProvider;
    protected Map<String, Object> accessValueMap;

    public static AccessContext getAccessContextOnThread() {
        return threadLocal.get();
    }

    public static void setAccessContextOnThread(AccessContext accessContext) {
        if (accessContext == null) {
            String msg = "The argument[accessContext] must not be null.";
            throw new IllegalArgumentException(msg);
        }
        threadLocal.set(accessContext);
    }

    public static boolean isExistAccessContextOnThread() {
        return threadLocal.get() != null;
    }

    public static void clearAccessContextOnThread() {
        threadLocal.set(null);
    }

    public static String getAccessUserOnThread() {
        AccessContext userContextOnThread;
        String accessUser;
        if (AccessContext.isExistAccessContextOnThread() && (accessUser = (userContextOnThread = AccessContext.getAccessContextOnThread()).getAccessUser()) != null) {
            return accessUser;
        }
        return "Anonymous";
    }

    public static String getAccessProcessOnThread() {
        AccessContext userContextOnThread;
        String accessProcess;
        if (AccessContext.isExistAccessContextOnThread() && (accessProcess = (userContextOnThread = AccessContext.getAccessContextOnThread()).getAccessProcess()) != null) {
            return accessProcess;
        }
        return "Anonymous";
    }

    public static String getAccessModuleOnThread() {
        AccessContext userContextOnThread;
        String accessModule;
        if (AccessContext.isExistAccessContextOnThread() && (accessModule = (userContextOnThread = AccessContext.getAccessContextOnThread()).getAccessModule()) != null) {
            return accessModule;
        }
        return "Anonymous";
    }

    public static Date getAccessDateOnThread() {
        if (AccessContext.isExistAccessContextOnThread()) {
            AccessContext userContextOnThread = AccessContext.getAccessContextOnThread();
            Date accessDate = userContextOnThread.getAccessDate();
            if (accessDate != null) {
                return accessDate;
            }
            if (userContextOnThread.getAccessDateProvider() != null) {
                return userContextOnThread.getAccessDateProvider().getAccessDate();
            }
        }
        return new Date();
    }

    public static Timestamp getAccessTimestampOnThread() {
        if (AccessContext.isExistAccessContextOnThread()) {
            AccessContext userContextOnThread = AccessContext.getAccessContextOnThread();
            Timestamp accessTimestamp = userContextOnThread.getAccessTimestamp();
            if (accessTimestamp != null) {
                return accessTimestamp;
            }
            if (userContextOnThread.getAccessTimestampProvider() != null) {
                return userContextOnThread.getAccessTimestampProvider().getAccessTimestamp();
            }
        }
        return new Timestamp(System.currentTimeMillis());
    }

    public static Object getAccessValueOnThread(String key) {
        AccessContext userContextOnThread;
        Map<String, Object> accessValueMap;
        if (AccessContext.isExistAccessContextOnThread() && (accessValueMap = (userContextOnThread = AccessContext.getAccessContextOnThread()).getAccessValueMap()) != null) {
            return accessValueMap.get(key);
        }
        return null;
    }

    public String getAccessUser() {
        return this.accessUser;
    }

    public void setAccessUser(String accessUser) {
        this.accessUser = accessUser;
    }

    public String getAccessProcess() {
        return this.accessProcess;
    }

    public void setAccessProcess(String accessProcess) {
        this.accessProcess = accessProcess;
    }

    public String getAccessModule() {
        return this.accessModule;
    }

    public void setAccessModule(String accessModule) {
        this.accessModule = accessModule;
    }

    public Date getAccessDate() {
        return this.accessDate;
    }

    public void setAccessDate(Date accessDate) {
        this.accessDate = accessDate;
    }

    public AccessDateProvider getAccessDateProvider() {
        return this.accessDateProvider;
    }

    public void setAccessDateProvider(AccessDateProvider accessDateProvider) {
        this.accessDateProvider = accessDateProvider;
    }

    public Timestamp getAccessTimestamp() {
        return this.accessTimestamp;
    }

    public void setAccessTimestamp(Timestamp accessTimestamp) {
        this.accessTimestamp = accessTimestamp;
    }

    public AccessTimestampProvider getAccessTimestampProvider() {
        return this.accessTimestampProvider;
    }

    public void setAccessTimestampProvider(AccessTimestampProvider accessTimestampProvider) {
        this.accessTimestampProvider = accessTimestampProvider;
    }

    public Map<String, Object> getAccessValueMap() {
        return this.accessValueMap;
    }

    public void registerAccessValue(String key, Object value) {
        if (this.accessValueMap == null) {
            this.accessValueMap = new HashMap<String, Object>();
        }
        this.accessValueMap.put(key, value);
    }

    public static interface AccessDateProvider {
        public Date getAccessDate();
    }

    public static interface AccessTimestampProvider {
        public Timestamp getAccessTimestamp();
    }
}

