/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import javax.activation.DataHandler;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimePart;
import javax.mail.internet.MimePartDataSource;
import javax.mail.internet.MimeUtility;

public class MimeBodyPart
extends BodyPart
implements MimePart {
    protected DataHandler dh;
    protected byte[] content;
    protected InputStream contentStream;
    protected InternetHeaders headers;

    public MimeBodyPart() {
        this.headers = new InternetHeaders();
    }

    public MimeBodyPart(InputStream in) throws MessagingException {
        this.headers = new InternetHeaders(in);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        try {
            int count;
            while ((count = in.read(buffer, 0, 1024)) != -1) {
                baos.write(buffer, 0, count);
            }
        }
        catch (IOException e) {
            throw new MessagingException(e.toString(), e);
        }
        this.content = baos.toByteArray();
    }

    public MimeBodyPart(InternetHeaders headers, byte[] content) throws MessagingException {
        this.headers = headers;
        this.content = content;
    }

    public int getSize() throws MessagingException {
        if (this.content != null) {
            return this.content.length;
        }
        return -1;
    }

    public int getLineCount() throws MessagingException {
        return -1;
    }

    public String getContentType() throws MessagingException {
        String value = this.getSingleHeader("Content-Type");
        if (value == null) {
            value = "text/plain";
        }
        return value;
    }

    public boolean isMimeType(String type) throws MessagingException {
        return new ContentType(this.getContentType()).match(type);
    }

    public String getDisposition() throws MessagingException {
        return this.getSingleHeader("Content-Disposition");
    }

    public void setDisposition(String disposition) throws MessagingException {
        this.setHeader("Content-Disposition", disposition);
    }

    public String getEncoding() throws MessagingException {
        return this.getSingleHeader("Content-Transfer-Encoding");
    }

    public String getContentID() throws MessagingException {
        return this.getSingleHeader("Content-ID");
    }

    public void setContentID(String cid) throws MessagingException {
        this.setHeader("Content-ID", cid);
    }

    public String getContentMD5() throws MessagingException {
        return this.getSingleHeader("Content-MD5");
    }

    public void setContentMD5(String md5) throws MessagingException {
        this.setHeader("Content-MD5", md5);
    }

    public String[] getContentLanguage() throws MessagingException {
        return this.getHeader("Content-Language");
    }

    public void setContentLanguage(String[] languages) throws MessagingException {
        if (languages == null || languages.length == 0) {
            this.removeHeader("Content-Language");
        } else if (languages.length == 1) {
            this.setHeader("Content-Language", languages[0]);
        } else {
            StringBuffer buf = new StringBuffer(languages.length * 20);
            buf.append(languages[0]);
            for (int i = 1; i < languages.length; ++i) {
                buf.append(',').append(languages[i]);
            }
            this.setHeader("Content-Language", buf.toString());
        }
    }

    public String getDescription() throws MessagingException {
        return this.getSingleHeader("Content-Description");
    }

    public void setDescription(String description) throws MessagingException {
        this.setHeader("Content-Description", description);
    }

    public void setDescription(String description, String charset) throws MessagingException {
        this.setHeader("Content-Description", description);
    }

    public String getFileName() throws MessagingException {
        throw new UnsupportedOperationException("Method not yet implemented");
    }

    public void setFileName(String name) throws MessagingException {
        throw new UnsupportedOperationException("Method not yet implemented");
    }

    public InputStream getInputStream() throws MessagingException, IOException {
        return this.getDataHandler().getInputStream();
    }

    protected InputStream getContentStream() throws MessagingException {
        if (this.content != null) {
            return new ByteArrayInputStream(this.content);
        }
        throw new MessagingException("No content");
    }

    public InputStream getRawInputStream() throws MessagingException {
        return this.getContentStream();
    }

    public synchronized DataHandler getDataHandler() throws MessagingException {
        if (this.dh == null) {
            this.dh = new DataHandler(new MimePartDataSource(this));
        }
        return this.dh;
    }

    public Object getContent() throws MessagingException, IOException {
        return this.getDataHandler().getContent();
    }

    public void setDataHandler(DataHandler handler) throws MessagingException {
        this.dh = handler;
    }

    public void setContent(Object content, String type) throws MessagingException {
        this.setDataHandler(new DataHandler(content, type));
    }

    public void setText(String text) throws MessagingException {
        this.setText(text, MimeUtility.getDefaultJavaCharset());
    }

    public void setText(String text, String charset) throws MessagingException {
        this.setContent(text, "text/plain; charset=" + charset);
    }

    public void setContent(Multipart part) throws MessagingException {
        this.setDataHandler(new DataHandler(part, part.getContentType()));
        part.setParent(this);
    }

    public void writeTo(OutputStream out) throws IOException, MessagingException {
        this.headers.writeTo(out, null);
        out.write(13);
        out.write(10);
        this.getDataHandler().writeTo(out);
    }

    public String[] getHeader(String name) throws MessagingException {
        return this.headers.getHeader(name);
    }

    public String getHeader(String name, String delimiter) throws MessagingException {
        return this.headers.getHeader(name, delimiter);
    }

    public void setHeader(String name, String value) throws MessagingException {
        this.headers.setHeader(name, value);
    }

    public void addHeader(String name, String value) throws MessagingException {
        this.headers.addHeader(name, value);
    }

    public void removeHeader(String name) throws MessagingException {
        this.headers.removeHeader(name);
    }

    public Enumeration getAllHeaders() throws MessagingException {
        return this.headers.getAllHeaders();
    }

    public Enumeration getMatchingHeaders(String[] name) throws MessagingException {
        return this.headers.getMatchingHeaders(name);
    }

    public Enumeration getNonMatchingHeaders(String[] name) throws MessagingException {
        return this.headers.getNonMatchingHeaders(name);
    }

    public void addHeaderLine(String line) throws MessagingException {
        this.headers.addHeaderLine(line);
    }

    public Enumeration getAllHeaderLines() throws MessagingException {
        return this.headers.getAllHeaderLines();
    }

    public Enumeration getMatchingHeaderLines(String[] names) throws MessagingException {
        return this.headers.getMatchingHeaderLines(names);
    }

    public Enumeration getNonMatchingHeaderLines(String[] names) throws MessagingException {
        return this.headers.getNonMatchingHeaderLines(names);
    }

    protected void updateHeaders() throws MessagingException {
    }

    private String getSingleHeader(String name) throws MessagingException {
        String[] values = this.getHeader(name);
        if (values == null || values.length == 0) {
            return null;
        }
        return values[0];
    }
}

