/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.xml;

import java.io.InputStream;
import javax.xml.parsers.SAXParser;
import org.seasar.framework.util.ResourceUtil;
import org.seasar.framework.util.SAXParserFactoryUtil;
import org.seasar.framework.util.SAXParserUtil;
import org.seasar.framework.xml.SaxHandler;
import org.xml.sax.InputSource;

public class SaxHandlerParser {
    private SaxHandler saxHandler;
    private SAXParser saxParser;

    public SaxHandlerParser(SaxHandler saxHandler) {
        this(saxHandler, SAXParserFactoryUtil.newSAXParser());
    }

    public SaxHandlerParser(SaxHandler saxHandler, SAXParser saxParser) {
        this.saxHandler = saxHandler;
        this.saxParser = saxParser;
    }

    public SaxHandler getSaxHandler() {
        return this.saxHandler;
    }

    public SAXParser getSAXParser() {
        return this.saxParser;
    }

    public Object parse(String path) {
        return this.parse(ResourceUtil.getResourceAsStream(path), path);
    }

    public Object parse(InputStream inputStream) {
        return this.parse(new InputSource(inputStream));
    }

    public Object parse(InputStream inputStream, String path) {
        InputSource is = new InputSource(inputStream);
        is.setSystemId(path);
        return this.parse(is);
    }

    public Object parse(InputSource inputSource) {
        SAXParserUtil.parse(this.saxParser, inputSource, this.saxHandler);
        return this.saxHandler.getResult();
    }
}

