package enotebooksystem.enotebook;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Hashtable;
import java.util.Enumeration;
import javax.swing.*;
import javax.swing.filechooser.*;

/**
 * <p>BwHwHw |JEX، </p>
 * @author ɓ ~
 * @version 1.0
 */


public class FileFilter_xml extends FileFilter implements FilenameFilter{
  private static String TYPE_UNKNOWN = "Type Unknown";
  private static String HIDDEN_FILE = "Hidden File";

  private Hashtable filters = null;
  private String description = null;
  private String fullDescription = null;
  private boolean useExtensionsInDescription = true;

  public FileFilter_xml() {
  }
  /**
  * Return true if this file should be shown in the directory pane,
  * false if it shouldn't.
  *
  * Files that begin with "." are ignored.
  *
  * @see #getExtension
  * @see FileFilter#accepts
  */
  public boolean accept(File f) {
    if(f != null) {
      if(f.isDirectory()) {
        return true;
      }
      String extension = getExtension(f);
      if(extension != null && filters.get(getExtension(f)) != null) {
        return true;
      };
    }
    return false;
  }

  public boolean accept(File dir,String name){
    // fBNgoƂ
    //return new File(name).isDirectory();

    // gqɑ΂ătB^O|Ƃ
    return name.endsWith(".xml");
  }
  /**
   * Return the extension portion of the file's name .
   *
   * @see #getExtension
   * @see FileFilter#accept
   */
  public String getExtension(File f) {
    if(f != null) {
      String filename = f.getName();
      int i = filename.lastIndexOf('.');
      if(i>0 && i<filename.length()-1) {
        return filename.substring(i+1).toLowerCase();
      };
    }
    return null;
  }

  /**
   * Returns the human readable description of this filter. For
   * example: "JPEG and GIF Image Files (*.jpg, *.gif)"
   *
   * @see setDescription
   * @see setExtensionListInDescription
   * @see isExtensionListInDescription
   * @see FileFilter#getDescription
   */
  public String getDescription() {
    if(fullDescription == null) {
      if(description == null || isExtensionListInDescription()) {
        fullDescription = description==null ? "(" : description + " (";
        // build the description from the extension list
        Enumeration extensions = filters.keys();
        if(extensions != null) {
          fullDescription += "." + (String) extensions.nextElement();
          while (extensions.hasMoreElements()) {
            fullDescription += ", ." + (String) extensions.nextElement();
          }
        }
        fullDescription += ")";
      } else {
        fullDescription = description;
      }
    }
    return fullDescription;
  }
  /**
   * Returns whether the extension list (.jpg, .gif, etc) should
   * show up in the human readable description.
   *
   * Only relevent if a description was provided in the constructor
   * or using setDescription();
   *
   * @see getDescription
   * @see setDescription
   * @see setExtensionListInDescription
   */
  public boolean isExtensionListInDescription() {
    return useExtensionsInDescription;
  }
}