#!/bin/sh

# Copyright (c) 2012 ken.naruo
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.


## param setting
LANG=C;export LANG
SCRIPT_DIR=`dirname $0`
UNAME=`uname -n`
TIME=`date +%s`

JOB=`echo ${SCRIPT_DIR} | awk -F [/] '{field = $NF } END {print field }'`
JOBNET=`echo ${SCRIPT_DIR} | awk -F [/] '{field = $(NF-1) } END {print field }'`
PROJECT=`echo ${SCRIPT_DIR} | awk -F [/] '{field = $(NF-2) } END {print field}'`

## jobnet prof load
grep -v SCHEDULE ${SCRIPT_DIR}/../jobnet.prof > ${SCRIPT_DIR}/.jobnet_tmp
chmod 766 ${SCRIPT_DIR}/.jobnet_tmp
. ${SCRIPT_DIR}/.jobnet_tmp


## conf load
. ${SCRIPT_DIR}/../../../../.root



## contents get

cat ${SCRIPT_DIR}/monitor.conf | grep -v "^$" | grep -v ^#  > ${SCRIPT_DIR}/.monitor.conf.tmp

while read CONTEXT
do
  URL=`echo $CONTEXT | awk '{print $1}'`
  CONTENTS=`echo $CONTEXT | awk '{print $2}'`
  URL_NAME=`echo ${URL} | sed -e "s/\///g" | sed -e "s/:/./g"`
  MONITOR_STATUS_QUE=${ROOT}/que/monitor/${URL_NAME}_status
  MONITOR_ERROR_QUE=${ROOT}/que/monitor/${UNAME}_error_`date +%Y%m%d`

  wget -O ${SCRIPT_DIR}/.wget.tmp ${URL}
  if [ $? != 0 ];then

    echo "`date +%Y/%m/%d` `date +%H:%M:%S` ${URL} wget failed!" > ${MONITOR_STATUS_QUE}
    echo "`date +%Y/%m/%d` `date +%H:%M:%S` ${URL} wget failed!" >> ${MONITOR_ERROR_QUE}

      if [ ! -f ${SCRIPT_DIR}/.wget.${URL_NAME}.error.tmp ];then

        if [ "${MAIL_ADDR}" ];then
          TIME=`date +%s`
          MAIL_QUE=${ROOT}/que/mail/${PROJECT}_${JOBNET}_${JOB}_${URL_NAME}_${TIME}
          echo "MAIL_ADDR:${MAIL_ADDR}" > ${MAIL_QUE}
          echo "SUBJECT:contents check failed ${URL}">> ${MAIL_QUE}
          echo "`date +%Y/%m/%d` `date +%H:%M:%S` wget failed ${URL}" >> ${MAIL_QUE}
        fi

        touch ${SCRIPT_DIR}/.wget.${URL_NAME}.error.tmp

      fi

  else

    echo "`date +%Y/%m/%d` `date +%H:%M:%S` ${URL} wget success" > ${MONITOR_STATUS_QUE}

  fi


  if [ "${CONTENTS}" ];then

    grep "${CONTENTS}" ${SCRIPT_DIR}/.wget.tmp

    if [ $? != 0 ];then

      echo "`date +%Y/%m/%d` `date +%H:%M:%S` ${URL} contents check failed!" > ${MONITOR_STATUS_QUE}
      echo "`date +%Y/%m/%d` `date +%H:%M:%S` ${URL} contents check failed!" >> ${MONITOR_ERROR_QUE}

      if [ ! -f ${SCRIPT_DIR}/.wget.${URL_NAME}.error.tmp ];then

        if [ "${MAIL_ADDR}" ];then
          TIME=`date +%s`
          MAIL_QUE=${ROOT}/que/mail/${PROJECT}_${JOBNET}_${JOB}_${URL_NAME}_${TIME}
          echo "MAIL_ADDR:${MAIL_ADDR}" > ${MAIL_QUE}
          echo "SUBJECT:contents check failed ${URL}">> ${MAIL_QUE}
          echo "`date +%Y/%m/%d` `date +%H:%M:%S` contents check failed ${URL}" >> ${MAIL_QUE}
        fi

        touch ${SCRIPT_DIR}/.wget.${URL_NAME}.error.tmp

      fi

    else

      echo "`date +%Y/%m/%d` `date +%H:%M:%S` ${URL} wget success" > ${MONITOR_STATUS_QUE}

    fi

  fi

done < ${SCRIPT_DIR}/.monitor.conf.tmp

find ${SCRIPT_DIR} -type f -name *.tmp -mtime +0 |  xargs rm -f
exit 0
