#!/bin/sh

# Copyright (c) 2012 ken.naruo
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.


# .root load
LANG=C;export LANG
SCRIPT_DIR=`dirname $0`
. ${SCRIPT_DIR}/.root


PROJECT=$1
JOBNET=$2
JOBNET_HOME=${ROOT}/project/${PROJECT}/${JOBNET}
CONTROLLER_EXE=${JOBNET_HOME}/controller.sh
ENABLE_FLAG=${JOBNET_HOME}/.enabled
PROF=${JOBNET_HOME}/jobnet.prof
UTL_SCHEDULE=${ROOT}/utilities/.schedule
DEL_L="${ROOT}/utilities/log_delete.sh"
DEL_Q="${ROOT}/utilities/que_delete.sh"
CHECK_J="${ROOT}/utilities/jobnet_check.sh"
SNAP_SHOT="${ROOT}/utilities/snapshot.sh"

if [ "${PROJECT}" = "" -o "${JOBNET}" = "" ];then
 echo "usage: enable_jobnet.sh <PROJECT> <JOBNET>"
 exit 1
fi

if [ ! -f ${JOBNET_HOME}/jobnet.prof ];then
 echo "jobnet is not exist"
 exit 1
fi

if [ ! -f ${JOBNET_HOME}/controller.sh ];then
 echo "controller is not exist"
 echo "please execute \"mkcontroller.sh ${PROJECT} ${JOBNET}\""
 exit 1
fi


## jobnet prof input
SCHEDULE_CHECK=`grep SCHEDULE ${PROF} | awk -F [:] '{print $1}'`

## crontab update
if [ "${SCHEDULE_CHECK}" = "" ];then
 echo "schedule is not defined, ${JOBNET_HOME}/jobnet.prof" 
 exit 1
fi

crontab -l > ${JOBNET_HOME}/.crontab_tmp
chmod 766 ${JOBNET_HOME}/.crontab_tmp

if [ $? != 0 ];then
  echo "maybe permission is wrong ${JOBNET_HOME}/.crontab_tmp"
  exit 1
fi

ENTRY_CHECK=`grep ${CONTROLLER_EXE} ${JOBNET_HOME}/.crontab_tmp | awk '{print $1}'`

if [ "${ENTRY_CHECK}" ];then
 echo "jobnet has already enabled" 
 exit 1
fi

echo "`grep SCHEDULE ${PROF} | awk -F [:] '{print $2}'` ${CONTROLLER_EXE} > /dev/null 2>&1" >> ${JOBNET_HOME}/.crontab_tmp


echo "${JOBNET_HOME}/log" >> ${ROOT}/utilities/jobnet.list
touch ${ENABLE_FLAG}


# utility check
QUE_UTILITY_CHECK=`grep "${DEL_Q}" ${JOBNET_HOME}/.crontab_tmp`
if [ "${QUE_UTILITY_CHECK}" = "" ];then
 echo "`grep QUE_SCHEDULE ${UTL_SCHEDULE}| awk -F [:] '{print $2}'` ${DEL_Q} > /dev/null 2>&1" >> ${JOBNET_HOME}/.crontab_tmp
fi

LOG_UTILITY_CHECK=`grep "${DEL_L}" ${JOBNET_HOME}/.crontab_tmp`
if [ "${LOG_UTILITY_CHECK}" = "" ];then
 echo "`grep LOG_SCHEDULE ${UTL_SCHEDULE}| awk -F [:] '{print $2}'` ${DEL_L} > /dev/null 2>&1" >> ${JOBNET_HOME}/.crontab_tmp
fi

JOBNET_UTILITY_CHECK=`grep "${CHECK_J}" ${JOBNET_HOME}/.crontab_tmp`
if [ "${JOBNET_UTILITY_CHECK}" = "" ];then
 echo "`grep JOBNET_CHECK ${UTL_SCHEDULE}| awk -F [:] '{print $2}'` ${CHECK_J} > /dev/null 2>&1" >> ${JOBNET_HOME}/.crontab_tmp
fi

SNAP_UTILITY_CHECK=`grep "${SNAP_SHOT}" ${JOBNET_HOME}/.crontab_tmp`
if [ "${SNAP_UTILITY_CHECK}" = "" ];then
 echo "`grep SNAP_SHOT ${UTL_SCHEDULE}| awk -F [:] '{print $2}'` ${SNAP_SHOT} > /dev/null 2>&1" >> ${JOBNET_HOME}/.crontab_tmp
fi

# crontab crontab_new
crontab ${JOBNET_HOME}/.crontab_tmp

if [ $? != 0 ];then
 echo "your schedule entry is not accurate."
 echo "please check schedule and retry"
 echo "${JOBNET_HOME}/jobnet.prof"
fi

echo "-------------------------------------------------------------"
echo "JOBNET:${JOBNET} scheduled succesfully"
echo "please check crontab -l "

## cluster_check
IFCONFIG=/usr/sbin/ifconfig
LINUX=`uname -a | grep Linux`

if [ "${LINUX}" ];then
  IFCONFIG=/sbin/ifconfig
fi

. ${ROOT}/project/${PROJECT}/${JOBNET}/cluster.conf
. ${ROOT}/cluster/global.conf

if [ "${CLUSTER}" = yes  -o "${DISPATCH}" = yes  ];then

 if [ "${CONTROLLER}" = "" ];then
   echo "ERROR CONTROLLER is not defined at ${ROOT}/cluster/global.conf, please check it"
   echo "-------------------------------------------------------------"
   exit 1
 else
 for RHOST in ${CONTROLLER}
  do
    IP_ADDR_CHECK=`${IFCONFIG} -a | grep ${RHOST}`
    if [ "${IP_ADDR_CHECK}" = "" ];then

      if [ "${CLUSTER_USER}" = "" ];then
        ssh -p ${SSH_PORT} ${RHOST} echo "connection test" > /dev/null 2>&1
      else
        ssh -l ${CLUSTER_USER} -i /home/${CLUSTER_USER}/.ssh/id_rsa -p ${SSH_PORT} ${RHOST} echo "connection test" > /dev/null 2>&1
      fi

      if [ $? != 0 ];then
       echo "ERROR ${RHOST} connection failed"
       echo "please confirm CONTROLLER_SERVER ${ROOT}/cluster/global.conf"
       echo "you must install e-cron to remoteserver and set ssh key authentication"
       echo "see detail -> http://www.e-cron.org/guideline.html"
       echo "-------------------------------------------------------------"
       exit 1
      fi


      if [ "${CLUSTER_USER}" = "" ];then
        ssh -p ${SSH_PORT} ${RHOST} ls  ${ROOT} > /dev/null 2>&1
      else
        ssh -l ${CLUSTER_USER} -i /home/${CLUSTER_USER}/.ssh/id_rsa -p ${SSH_PORT} ${RHOST} ls  ${ROOT} > /dev/null 2>&1
      fi

      if [ $? != 0 ];then
       echo "ERROR ${RHOST} package check failed"
       echo "you must install e-cron to remoteserver"
       echo "-------------------------------------------------------------"
       exit 1
      fi

      if [ "${CLUSTER_USER}" = "" ];then
        ssh -p ${SSH_PORT} ${RHOST} ls ${CONTROLLER_EXE} > /dev/null 2>&1
      else
        ssh -l ${CLUSTER_USER} -i /home/${CLUSTER_USER}/.ssh/id_rsa -p ${SSH_PORT} ${RHOST} ls ${CONTROLLER_EXE} > /dev/null 2>&1
      fi


      if [ $? != 0 ];then
       echo ""
       echo "notice:please execute \"enable_cluster.sh ${PROJECT} ${JOBNET}\" on this server"
      fi
     
      if [ "${CLUSTER_USER}" = "" ];then
        ssh -p ${SSH_PORT} ${RHOST} ls ${ENABLE_FLAG} > /dev/null 2>&1
      else
        ssh -l ${CLUSTER_USER} -i /home/${CLUSTER_USER}/.ssh/id_rsa -p ${SSH_PORT} ${RHOST} ls ${ENABLE_FLAG} > /dev/null 2>&1
      fi

      if [ $? != 0 ];then
       echo "notice: please execute \"enable_jobnet.sh ${PROJECT} ${JOBNET}\" on remote server too"
      fi


    fi

   done
 fi
fi
echo "-------------------------------------------------------------"

echo "ROOT=${ROOT}" > ${ROOT}/utilities/.root
rm  ${JOBNET_HOME}/.crontab_tmp

exit 0
