﻿/*!
@page WhatSDX SDXとは？
SDXFrameworkはC++で自由ゲームを制作するための、クラスライブラリです。\n
以下のような特徴があります。\n
<HR>
<B>特徴</B>\n
<B>1.マルチプラットフォーム</B>\n
内部でSDL2.0を使っているので、多くのプラットフォームで動きます。\n
機能的にはSDL2.0+α程度ですが、SDL2.0に比べるとかなり使いやすくなっています\n
<HR>
<B>2.日本語サポート</B>\n
主に2つの理由で英語でなく日本語中心で開発を進めています。\n
一つ目は差別化のためです\n
　公式ドキュメントが英語だけのライブラリは多くあるので、日本語のサポートを優先した方が特徴が出ます。\n
OSSに参加したいけど英語はあまり得意では無い人に対してアピール出来るとも思います。\n
　世界規模で見れば英語話者が多いので、英語主体にした方が開発者が集まる可能性が高くなるのでは？と思う方がいるかもしれませんが、\n
そもそも最近はOSSが増えまくっているので、日本語だろうが英語だろうが簡単には共同開発者は集まりません。\n
\n
二つ目は効率を上げるためです。\n
　ライブラリ開発者が日本語の方が得意なので英語主体で開発を進めるのは効率が悪すぎます。\n
特に仮引数は日本語にするとIDEのヒント表示が見やすくなり、リファレンスを見る回数を減らせ、利用者にとってもメリットがあります。\n
\n
　参加者が増えたので英訳しようとなる可能性も一応考慮しており、\n
仮引数とドキュメント以外は英語風にしています、思ったより利用者が増えたので英訳しようと思った場合も大きな問題は起こりません。\n
\n
<HR>
<B>3.コピーレフトなライセンス</B>\n
　SDXはコピーレフトなライセンスであるGNU Affero General Public License Version 3を適用しています。\n
AGPLを適用すると緩いライセンスに比べて利用者が減るので都合が悪いのでは？と思われるかもしれませんが、そうでは無いと考えています\n
以下に理由を説明します\n
\n
　コードを公開する場合のライセンスの方針は大きく3つに分ける事が出来ると思います。\n
(※技術を独占したい、ソフトウェアを売りたい、自分のソフトを少しもいじって欲しく無い等の理由で公開出来ない場合は除きます)\n
ライセンスについては、経済的な視点、技術的な視点、コミュニティ的な視点で考えています。\n
\n
[1.緩いオープンなライセンス]\n
例えばApache LicenseやMITライセンスは派生物に対してライセンス表記ぐらいしか求めません。\n
企業に支援される事を目標とする場合、あるいは規模が極端に小さく著作権を主張する意味が無い場合、\n
ライセンスを確認せずに使えるようにしたい場合、オープンにしてもどうせ誰も利用しない場合、\n
利用者同士でコードを共有せずに競争させて良い物が出来れば良いと言う考えの場合、\n
GitHubを無料で使うためにコードを公開している場合等はApache LicenseやMITライセンスを適用するのが良いと思われます\n
\n
[2.自由でなく対価を要求するライセンス]\n
利用範囲が狭いため誰も作りたがらない物を受託開発する場合、金銭を要求するのが妥当だと思われます。\n
無償の労働を強要する事があってはいけません。\n
この場合ソフトウェア完成後にライセンスを変更しソースコードを公開するのも選択に入ります\n
\n
[3.コピーレフトなライセンス]\n
GPL等のコピーレフトなライセンスはユーザー同士が協力する事を強く推奨したい場合には良い選択です。\n
しかしながらライセンスが比較的ややこしかったり、権利を強く主張するので誤解されたり敬遠されがちでもあります\n
場合によっては緩いライセンスを適用した方が良いでしょう。\n
\n
SDXがAGPL ver3を選択した理由\n
[1.経済的な理由]\n
ソフトウェアを有償で販売したい場合、ソースコードから派生物を自由に作れると経済的に成り立たない事があります。\n
企業から支援を引き出せるOSSはなかなか生まれませんので、ソースコードの公開がダンピングになると言った懸念は有り得ます。\n
\n
しかしながらゲームの場合、イラストやBGMやシナリオを別のライセンスで配布すれば、ソフトウェア単体では動作しないので、\n
商業上の問題があまり発生しません。またゲームとサントラの値段があまり変わらないと言った事があるように、ソフトウェア単体での\n
価値下がりつつあるため、ゲームの価格に対して影響は殆どないと思われます。\n
\n
また自分しか持っていない独自技術がある場合でも公開した方が有利な場合が多いです。\n
ゲームの場合、一番最初にそのジャンルを開拓したり新しい事をした場合、後続のゲームが登場する事は宣伝になる上、ファン層の拡大につながる事が多いです。\n
特にマイナーなジャンルは積極的に技術を公開する方がメリットが多いと思います。\n
\n
あとはゲームを一部改変して遊びたいと言ったユーザーのニーズに答えやすくなる事や、ユーザーの支援が起こりやすくなると思います\n
保守コストは馬鹿にならないため、それらも重要です\n
\n
ライセンス違反が問題になる可能性はありますが、ソースコードを公開しない場合と大きな差はないと考えます\n
\n
プラットフォーム事業者との契約によっては公開出来ない例等もあるのですが、全体としてはソースコードを公開した方が有利であると考えています。\n
\n
さらに言えば大半の趣味で開発して無償で配布している人からするとどうせ利益なんて出ないので、コード公開で金銭的な利益が減る事はわりとどうでもよいでしょう\n
[2.技術的な理由]\n
経済上の理由で開発者が立ちゆかなくなると言った事が起こりにくいので、開発者同士で技術を公開しあった方があきらかに優位であると言えます。\n
コードを公開した所でゲームが簡単に作れる事にはならないので、全体の質は上がっても競争が激化する事もないと思います。\n
技術が上がれば、開発コストが下がり、クオリティが向上するため、経済的な利点にもなります\n
ライブラリ開発においては実際にどのような利用がなされているか調査したり取り込む事が楽になるのはメリットしかありません。\n
\n
　さらに後進の育成にも繋がります。\n
　某所の質問掲示板等ではこういうゲームを作りたいが参考になるコードはないか？と言った質問はたまに見かけるので需要もあるはずです\n
解説サイトを作るのは相当な手間ですが、コード公開はそこまで手間ではありません、教育機会均等の考えから言ってもコードの公開ぐらいはした方が良いと思います\n
\n
[3.コミュニティ的な理由]\n
　個人レベルでソースコードを公開しても、そういう事をしている人が少ないため、他開発者やユーザーから認知されにくいですし、\n
見ず知らずの人のために時間を使ってドキュメントの整備やら宣伝やらしようと言う人は少ないでしょう。\n
また個人で公開している場合、ライセンス違反に対して行動を取りづらく泣き寝入りになる可能性が上がります。\n
\n
　ライブラリをコピーレフトにして、それを共有する形を取りコミュニティとして自由ゲームを作れば、開発者の横の繋がりが強化され集団として発信出来るようになります。\n
\n
　技術の向上や経済的なメリットはあくまで自由ゲーム作者が一定数いる事が前提になるので、ライブラリをAGPLにする事は単体のゲームが自由であるのと全く意味が違います。\n
それにコードが公開されていれば自由にソフトウェアが改変出来ると言っても、それぞれが全く違う環境をベースにしていると手を出しにくいです。\n
\n
みんなで協力して自由なゲームを作る、それがSDXFrameworkのライセンスをAGPLにした理由です\n
\n
ライブラリ開発等に興味がある人はSorceForgeの掲示板で気軽にお問い合わせ下さい。
<HR>
<B>対応開発環境</B>\n
Windows7以降 + VisualStudio2013\n
\n
MacOSX最新版 + Xcode最新版\n
\n
GNU/Linux系のOS + Clang3.3以降\n
\n
解説を書いていないだけでSDL2.0が動く環境では大体使えるはずです\n
<HR>
<B>機能一覧</B>\n
@ref ClassGroup
*/