/*
 * Decompiled with CFR 0.152.
 */
package dvi.browser;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.DefaultListModel;

public class DviFileListModel
extends DefaultListModel {
    private static final long serialVersionUID = 5283897963874660339L;
    private volatile List<File> list = new ArrayList<File>();
    private File dir;
    private FileFilter filter;

    public void setDirectory(File dir) {
        this.dir = dir;
        this.updateFileList();
    }

    public void updateFileList() {
        ArrayList<File> newList = new ArrayList<File>();
        if (this.dir != null && this.dir.isDirectory()) {
            Object[] list = this.dir.listFiles(this.filter);
            Arrays.sort(list);
            for (Object f : list) {
                newList.add((File)f);
            }
        }
        int oldLen = this.list.size();
        int newLen = newList.size();
        this.list = newList;
        this.fireContentsChanged(this, 0, Math.max(newLen, oldLen));
    }

    public void notifyChange(int index) {
        this.fireContentsChanged(this, index, index);
    }

    public int getSize() {
        return this.list.size();
    }

    public Object getElementAt(int idx) {
        return this.list.get(idx);
    }

    public FileFilter getFilter() {
        return this.filter;
    }

    public void setFilter(FileFilter filter) {
        this.filter = filter;
    }
}

