/*
 * Decompiled with CFR 0.152.
 */
package dvi.browser;

import dvi.DviObject;
import dvi.api.DviContextSupport;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.io.File;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;

public class DviDirectoryIndexCellRenderer
extends DviObject
implements ListCellRenderer {
    JLabel label = new JLabel();

    public DviDirectoryIndexCellRenderer(DviContextSupport dcs) {
        super(dcs);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.label.setFont(new Font(null, 0, 14));
        this.label.setOpaque(true);
        this.label.setBackground(this.getDefaultBackgroundColor(index));
        this.label.setForeground(Color.black);
        this.label.setIcon(null);
        if (value instanceof File) {
            File file = (File)value;
            this.label.setText(file.getName());
            if (file.isDirectory()) {
                Icon icon = UIManager.getIcon("FileView.directoryIcon");
                this.label.setIcon(icon);
            } else {
                Icon icon = UIManager.getIcon("FileView.fileIcon");
                this.label.setIcon(icon);
            }
        } else {
            this.label.setText(String.valueOf(value));
        }
        if (isSelected) {
            if (cellHasFocus) {
                this.label.setForeground(Color.white);
                this.label.setBackground(new Color(44, 44, 255));
            } else {
                this.label.setForeground(Color.white);
                this.label.setBackground(Color.gray);
            }
        }
        return this.label;
    }

    private Color getDefaultBackgroundColor(int index) {
        if (index % 2 == 0) {
            return new Color(240, 255, 255);
        }
        return null;
    }
}

