/*
 * Decompiled with CFR 0.152.
 */
package dvi.launcher;

import dvi.launcher.LauncherException;
import dvi.util.DviUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class Launcher {
    private static final Logger LOGGER = Logger.getLogger(Launcher.class.getName());
    private static final String LAUNCHER_MAINCLASS_KEY = "dvi.launcher.mainClass";
    private static final String BUILTIN_DEFAULT_MAINCLASS = "dvi.browser.DviBrowser";
    private static final String BUILTIN_DEFAULT_LOGGING_CONF = "conf/logging.properties";
    private static final String LAUNCHER_MAINCLASS_LOGGING_CONF_KEY = "dvi.launcher.mainClass.logging.config.file";
    private static final String LAUNCHER_LOGGING_CONF_KEY = "dvi.launcher.logging.config.file";

    public static File getUserDir() {
        Properties props = System.getProperties();
        String userDir = props.getProperty("user.dir");
        return new File(userDir);
    }

    public static void main(String[] args) {
        try {
            LOGGER.info("Starting the application launcher.");
            Launcher.startApplication(args);
        }
        catch (Exception ex) {
            DviUtils.logStackTrace(LOGGER, Level.SEVERE, ex);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Launcher.showErrorMessage("Application exit with an error.  See log file for details.", "Launcher Error");
                }
            });
        }
    }

    public static void showErrorMessage(String msg, String title) {
        JOptionPane.showMessageDialog(null, msg, title, 0);
        LOGGER.info("Terminating.");
        System.exit(1);
    }

    public static File getWorkDir() throws Exception {
        Properties props = System.getProperties();
        String classpath = props.getProperty("java.class.path");
        File jarFile = new File(classpath);
        if (jarFile.isFile() && jarFile.canRead()) {
            return jarFile.getParentFile();
        }
        throw new LauncherException("Unable to determine the work dir: jar file does not exist:" + jarFile.getAbsolutePath());
    }

    public static void startApplication(String[] args) throws Exception {
        File f;
        File workDir = Launcher.getWorkDir();
        File confDir = new File(workDir, "conf");
        Properties props = new Properties();
        File launcherPropertiesFile = new File(confDir, "launcher.properties");
        if (launcherPropertiesFile.isFile() && launcherPropertiesFile.canRead()) {
            try {
                props.load(new FileInputStream(launcherPropertiesFile));
            }
            catch (FileNotFoundException e) {
                LOGGER.warning(e.toString());
            }
            catch (IOException e) {
                LOGGER.warning(e.toString());
            }
        }
        props.putAll((Map<?, ?>)System.getProperties());
        String launcherLoggingConfFilename = props.getProperty(LAUNCHER_LOGGING_CONF_KEY, null);
        if (launcherLoggingConfFilename != null && (f = new File(launcherLoggingConfFilename)).isFile() && f.canRead()) {
            try {
                LOGGER.info("Loading logging configuration file: " + f);
                LogManager.getLogManager().readConfiguration(new FileInputStream(f));
                LOGGER.info("Loaded logging configuration file: " + f);
            }
            catch (FileNotFoundException e) {
                LOGGER.warning(e.toString());
            }
            catch (IOException e) {
                LOGGER.warning(e.toString());
            }
        }
        File classpathsDir = new File(confDir, "classpaths.d");
        String mainClass = props.getProperty(LAUNCHER_MAINCLASS_KEY, BUILTIN_DEFAULT_MAINCLASS);
        String javaCommand = "java";
        if (DviUtils.isWindows()) {
            javaCommand = "javaw";
        }
        String classpath = Launcher.buildClasspathFromDirectory(classpathsDir);
        LOGGER.config("CLASSPATH=" + classpath);
        LOGGER.config("WORKDIR=" + workDir);
        LOGGER.config("CONFDIR=" + confDir);
        String loggingConf = props.getProperty(LAUNCHER_MAINCLASS_LOGGING_CONF_KEY, BUILTIN_DEFAULT_LOGGING_CONF);
        ArrayList<String> cmds = new ArrayList<String>();
        cmds.add(javaCommand);
        cmds.add("-cp");
        cmds.add(classpath);
        cmds.add("-Djava.util.logging.config.file=" + loggingConf);
        cmds.add(mainClass);
        LOGGER.config("Launching main class: " + mainClass);
        Process proc = DviUtils.unsafeRunCommandByShell(cmds.toArray(new String[0]), null, workDir);
        DviUtils.dumpStreamAsync("stdout", proc.getInputStream(), System.out);
        DviUtils.dumpStreamAsync("stderr", proc.getErrorStream(), System.err);
        int exitCode = proc.waitFor();
        if (exitCode != 0) {
            throw new LauncherException("Application exit with an error: " + DviUtils.join(" ", cmds.toArray(new String[0])));
        }
    }

    private static String buildClasspathFromDirectory(File classpathsDir) {
        ArrayList<String> classpathList = new ArrayList<String>();
        Object[] list = classpathsDir.listFiles();
        if (list == null) {
            list = new File[]{};
        }
        Arrays.sort(list);
        for (Object file : list) {
            if (!((File)file).isFile() || !((File)file).canRead()) continue;
            try {
                String[] lines;
                for (String line : lines = DviUtils.removeComments(DviUtils.readLinesFromFile((File)file), "#")) {
                    classpathList.add(Launcher.mapInternalClasspathToPlatformClasspath(line));
                }
            }
            catch (IOException e) {
                LOGGER.warning(e.toString());
            }
        }
        return DviUtils.join(Launcher.getClasspathSeparator(), classpathList.toArray(new String[0]));
    }

    private static String mapInternalClasspathToPlatformClasspath(String str) {
        return str;
    }

    private static String getClasspathSeparator() {
        String classpathSep = ":";
        if (DviUtils.isWindows()) {
            classpathSep = ";";
        }
        return classpathSep;
    }
}

