/*
 * Decompiled with CFR 0.152.
 */
package dvi;

public class DviByteRange {
    public static final DviByteRange EMPTY = new DviByteRange();
    private final long begin;
    private final long end;

    private DviByteRange() {
        this.begin = 0L;
        this.end = -1L;
    }

    public DviByteRange(long begin, long end) {
        if (begin <= end) {
            this.begin = begin;
            this.end = end;
        } else {
            this.begin = end;
            this.end = begin;
        }
    }

    public long begin() {
        return this.begin;
    }

    public long end() {
        return this.end;
    }

    public DviByteRange translate(long by) {
        return new DviByteRange(this.begin + by, this.end + by);
    }

    public DviByteRange intersect(DviByteRange a) {
        long e;
        if (a == null) {
            return this;
        }
        if (this.isEmpty()) {
            return EMPTY;
        }
        if (a.isEmpty()) {
            return EMPTY;
        }
        long b = Math.max(this.begin, a.begin);
        return b > (e = Math.min(this.end, a.end)) ? EMPTY : new DviByteRange(b, e);
    }

    public DviByteRange union(DviByteRange a) {
        if (a == null) {
            return this;
        }
        if (this.isEmpty()) {
            return a;
        }
        if (a.isEmpty()) {
            return this;
        }
        return new DviByteRange(Math.min(this.begin, a.begin), Math.max(this.end, a.end));
    }

    public boolean isEmpty() {
        return this == EMPTY;
    }

    public long length() {
        return this.end - this.begin + 1L;
    }

    public boolean contains(long point) {
        return this.begin <= point && point <= this.end;
    }

    public boolean intersects(DviByteRange a) {
        if (a == null) {
            return false;
        }
        return !this.intersect(a).isEmpty();
    }

    public String toString() {
        return "" + this.begin + "--" + this.end;
    }

    public int hashCode() {
        return (int)(this.begin + 33L * this.end);
    }

    public boolean equals(Object obj) {
        if (obj instanceof DviByteRange) {
            DviByteRange br = (DviByteRange)obj;
            return br.begin == this.begin && br.end == this.end;
        }
        return false;
    }
}

