/*
 * Decompiled with CFR 0.152.
 */
package dvi.util;

import dvi.DviException;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DviUtils {
    private static final Logger LOGGER = Logger.getLogger(DviUtils.class.getName());
    private static final String OS_NAME = System.getProperty("os.name");
    private static final Pattern patEnv = Pattern.compile("^([^=]*)=(.*)$");

    private DviUtils() {
    }

    public static boolean isFile(URL url) {
        if (url == null) {
            return false;
        }
        return "file".equals(url.getProtocol());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeStringToFile(File psFile, String postScriptData) throws IOException {
        FileOutputStream fos = new FileOutputStream(psFile);
        try {
            byte[] buf = postScriptData.getBytes();
            fos.write(buf);
        }
        finally {
            fos.flush();
            fos.close();
        }
    }

    public static File toLocalFile(URL url) throws DviException {
        if (url == null) {
            return null;
        }
        if ("file".equals(url.getProtocol())) {
            return new File(url.getPath());
        }
        throw new DviException("URL does not point to a local file. " + url);
    }

    public static String md5Hex(String ps) {
        if (ps == null) {
            return null;
        }
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] digest = md.digest(ps.getBytes());
            StringBuilder sb = new StringBuilder();
            for (byte b : digest) {
                sb.append(String.format("%02x", b));
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return "0";
        }
    }

    public static Map<String, String> getLoginShellEnvPosix() throws IOException, InterruptedException {
        return DviUtils.getLoginShellEnvPosix(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getLoginShellEnvPosix(String shell) throws IOException, InterruptedException {
        String[] cmds = new String[]{"printenv"};
        if (shell != null) {
            cmds = new String[]{shell, "-l", "-c", "printenv"};
        }
        Process proc = Runtime.getRuntime().exec(cmds);
        HashMap<String, String> map = new HashMap<String, String>();
        proc.getOutputStream().close();
        proc.getErrorStream().close();
        Scanner s = new Scanner(proc.getInputStream());
        try {
            while (s.hasNext()) {
                String line = s.nextLine();
                Matcher mat = patEnv.matcher(line);
                if (!mat.matches()) continue;
                String key = mat.group(1);
                String value = mat.group(2);
                LOGGER.finest("key=" + key + " value=" + value);
                map.put(key, value);
            }
        }
        finally {
            try {
                s.close();
            }
            catch (Exception e) {}
        }
        proc.waitFor();
        return map;
    }

    public static String getPathByLoginShellPosix() throws IOException, InterruptedException {
        String path = null;
        Map<String, String> env0 = DviUtils.getLoginShellEnvPosix(null);
        String shell = env0.get("SHELL");
        if (shell != null) {
            Map<String, String> env1 = DviUtils.getLoginShellEnvPosix(shell);
            path = env1.get("PATH");
        }
        return path;
    }

    public static String join(String left, String mid, String right, String[] arg) {
        if (arg == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        left = DviUtils.wrapNull(left, "");
        mid = DviUtils.wrapNull(mid, "");
        right = DviUtils.wrapNull(right, "");
        String sep = left;
        for (String s : arg) {
            sb.append(sep + s);
            sep = mid;
        }
        sb.append(right);
        return sb.toString();
    }

    public static String join(String sep, String[] args) {
        return DviUtils.join(null, sep, null, args);
    }

    public static <T> T wrapNull(T value, T defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public static Process unsafeRunCommandByShell(String[] cmds, String[] envp, File workDir) throws IOException {
        Process p = null;
        if (!DviUtils.isWindows()) {
            try {
                Map<String, String> env = DviUtils.getLoginShellEnvPosix();
                String shell = env.get("SHELL");
                if (shell != null) {
                    p = DviUtils.unsafeRunCommandByShellPosix(shell, true, cmds, envp, workDir);
                }
            }
            catch (InterruptedException e) {
                LOGGER.warning(e.toString());
            }
        }
        if (p == null) {
            p = Runtime.getRuntime().exec(cmds, envp, workDir);
        }
        return p;
    }

    public static Process unsafeRunCommandByShellPosix(String shell, boolean useLoginShell, String[] cmds, String[] envp, File workDir) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        list.add(shell);
        if (useLoginShell) {
            list.add("-l");
        }
        String[] cmdLine = list.toArray(new String[0]);
        StringBuilder subCommand = new StringBuilder();
        for (String cmd : cmds) {
            subCommand.append(cmd + " ");
        }
        LOGGER.fine("running shell: " + DviUtils.join(" ", cmdLine));
        LOGGER.fine("running command: " + subCommand.toString());
        Process proc = Runtime.getRuntime().exec(cmdLine, envp, workDir);
        PrintWriter out = new PrintWriter(proc.getOutputStream());
        out.println(subCommand.toString());
        out.close();
        return proc;
    }

    public static Thread dumpStreamAsync(final String name, final InputStream is, final PrintStream out) {
        Thread t = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Scanner s = new Scanner(is);
                try {
                    while (s.hasNext()) {
                        String line = s.nextLine();
                        if (out != null) {
                            out.println("[" + name + "] " + line);
                        }
                        if (!LOGGER.isLoggable(Level.FINER)) continue;
                        LOGGER.finer("[" + name + "] " + line);
                    }
                }
                finally {
                    try {
                        s.close();
                    }
                    catch (Exception exception) {}
                }
            }
        });
        t.start();
        return t;
    }

    public static boolean isMacOSX() {
        return OS_NAME.startsWith("Mac OS X");
    }

    public static boolean isWindows() {
        return OS_NAME.startsWith("Windows");
    }

    public static void silentClose(Closeable s) {
        try {
            s.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFileToByteArray(File file) throws IOException {
        if (file == null) {
            return null;
        }
        int len = (int)file.length();
        FileInputStream is = new FileInputStream(file);
        try {
            byte[] buf = new byte[len];
            if (len != is.read(buf)) {
                throw new IOException("Failed to read file content");
            }
            byte[] byArray = buf;
            return byArray;
        }
        finally {
            DviUtils.silentClose(is);
        }
    }

    public static String readFileToString(File file, String encoding) throws IOException {
        byte[] buf = DviUtils.readFileToByteArray(file);
        if (buf != null) {
            return new String(buf, encoding);
        }
        return null;
    }

    public static String readFileToString(File file) throws IOException {
        byte[] buf = DviUtils.readFileToByteArray(file);
        if (buf != null) {
            return new String(buf);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] readLinesFromFile(File file) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        FileInputStream is = new FileInputStream(file);
        Scanner s = new Scanner(is);
        try {
            while (s.hasNext()) {
                String line = s.nextLine();
                list.add(line);
            }
            String[] stringArray = list.toArray(new String[0]);
            return stringArray;
        }
        finally {
            DviUtils.silentClose(is);
        }
    }

    public static String[] removeComments(String[] list, String lineCommentStart) {
        if (list == null) {
            return list;
        }
        ArrayList<String> out = new ArrayList<String>();
        for (String item : list) {
            int pos = item.indexOf(lineCommentStart);
            String line = item;
            if (pos != -1) {
                line = line.substring(0, pos);
            }
            if ((line = line.trim()).length() <= 0) continue;
            out.add(line);
        }
        return out.toArray(new String[0]);
    }

    public static String joinPath(String[] args) {
        if (args == null) {
            return null;
        }
        return DviUtils.join(File.pathSeparator, args);
    }

    public static void logStackTrace(Logger logger, Level level, Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println(t.toString());
        for (StackTraceElement e : t.getStackTrace()) {
            pw.println("at " + e.getClassName() + "." + e.getMethodName() + "(" + e.getFileName() + ":" + e.getLineNumber() + ")");
        }
        logger.log(level, sw.toString());
    }
}

