/*
 * Decompiled with CFR 0.152.
 */
package dvi.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandShell {
    private String[] commandLine = null;
    private String[] envp = null;
    private File dir = null;
    private Handler handler = null;
    private volatile Process p = null;
    private Thread stdoutThread = null;
    private Thread stderrThread = null;

    public void setCommandLine(String[] commandLine) {
        this.commandLine = commandLine;
    }

    public void setCommandLine(Collection<String> cmdLine) {
        this.setCommandLine(cmdLine.toArray(new String[cmdLine.size()]));
    }

    public void setEnvironment(Collection<String> envp) {
        this.setEnvironment(envp.toArray(new String[envp.size()]));
    }

    public void setEnvironment(String[] envp) {
        this.envp = envp;
    }

    public void setWorkingDirectory(File dir) {
        this.dir = dir;
    }

    public void setHandler(Handler handler) {
        this.handler = handler;
    }

    protected void checkVars() {
        if (this.commandLine == null) {
            throw new IllegalArgumentException("commandLine can't be null");
        }
        if (this.commandLine.length < 1) {
            throw new IllegalArgumentException("commandLine can't be empty");
        }
    }

    /*
     * Loose catch block
     */
    public boolean execute() throws IOException {
        boolean result;
        block13: {
            result = false;
            this.p = null;
            this.checkVars();
            this.p = Runtime.getRuntime().exec(this.commandLine, this.envp, this.dir);
            this.processStreams();
            Object var4_4 = null;
            try {
                this.debug("join err");
                if (this.stderrThread != null) {
                    this.stderrThread.join();
                }
                this.stderrThread = null;
                this.debug("join out");
                if (this.stdoutThread != null) {
                    this.stdoutThread.join();
                }
                this.stdoutThread = null;
                this.debug("wait");
                this.p.waitFor();
                result = this.p.exitValue() == 0;
                this.debug("done: exitValue=" + this.p.exitValue());
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
            break block13;
            {
                catch (IOException ex) {
                    throw ex;
                }
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                try {
                    this.debug("join err");
                    if (this.stderrThread != null) {
                        this.stderrThread.join();
                    }
                    this.stderrThread = null;
                    this.debug("join out");
                    if (this.stdoutThread != null) {
                        this.stdoutThread.join();
                    }
                    this.stdoutThread = null;
                    this.debug("wait");
                    this.p.waitFor();
                    result = this.p.exitValue() == 0;
                    this.debug("done: exitValue=" + this.p.exitValue());
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
                throw throwable;
            }
        }
        this.p = null;
        return result;
    }

    protected void processStreams() throws IOException {
        this.p.getOutputStream().close();
        if (this.handler != null) {
            this.stderrThread = new Thread(new Runnable(){

                public void run() {
                    try {
                        CommandShell.this.handler.handleStderr(CommandShell.this.p.getErrorStream());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
            this.stdoutThread = new Thread(new Runnable(){

                public void run() {
                    try {
                        CommandShell.this.handler.handleStdout(CommandShell.this.p.getInputStream());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
            this.stderrThread.start();
            this.stdoutThread.start();
        }
    }

    public void debug(Object obj) {
        if (obj == null) {
            return;
        }
    }

    public void stop() {
        if (this.p != null) {
            this.p.destroy();
        }
    }

    public static class DumpHandler
    implements Handler {
        public void handleStdout(InputStream in) throws IOException {
            this.dumpStream("stdout", in);
        }

        public void handleStderr(InputStream in) throws IOException {
            this.dumpStream("stderr", in);
        }

        private void dumpStream(String prefix, InputStream in) throws IOException {
            String line;
            BufferedReader r = new BufferedReader(new InputStreamReader(in));
            while (null != (line = r.readLine())) {
                System.out.println(prefix + ": " + line);
            }
        }
    }

    public static interface Handler {
        public void handleStdout(InputStream var1) throws IOException;

        public void handleStderr(InputStream var1) throws IOException;
    }
}

