/*
 * Decompiled with CFR 0.152.
 */
package dvi.render;

import dvi.api.GammaCorrector;

public class DefaultGammaCorrector
implements GammaCorrector {
    private final double factor;
    private final double exponent;

    public DefaultGammaCorrector() {
        this(1.0, 1.0);
    }

    public DefaultGammaCorrector(double factor, double exponent) {
        this.factor = factor;
        this.exponent = exponent;
    }

    public double factor() {
        return this.factor;
    }

    public double exponent() {
        return this.exponent;
    }

    public int correctGamma(int c, int maxval) {
        return (int)(1024.0 * Math.min(1.0, Math.pow(this.factor * (double)c / (double)maxval, this.exponent)) + 0.5);
    }

    public int hashCode() {
        return (int)(33.0 * (this.factor + 33.0 * this.exponent));
    }

    public String toString() {
        return this.getClass().getName() + "[factor=" + this.factor + ",exponent=" + this.exponent + "]";
    }
}

