/*
 * Decompiled with CFR 0.152.
 */
package dvi.render;

import dvi.DviColor;
import dvi.DviException;
import dvi.DviPoint;
import dvi.DviResolution;
import dvi.api.Device;
import java.util.Stack;

public abstract class AbstractDevice
implements Device {
    private final DviResolution res;
    protected DviPoint point = DviPoint.ORIGIN;
    private DviColor color = new DviColor(0, 0, 0);
    protected final Stack<StackItem> stack = new Stack();

    public AbstractDevice(DviResolution res) {
        this.res = res;
    }

    public DviResolution getResolution() throws DviException {
        return this.res;
    }

    public DviPoint getReferencePoint() throws DviException {
        return this.point;
    }

    public void setReferencePoint(DviPoint point) throws DviException {
        this.point = point;
    }

    public void translate(DviPoint p) throws DviException {
        this.point = this.point.translate(p);
    }

    public void translate(int dx, int dy) throws DviException {
        this.point = this.point.translate(dx, dy);
    }

    public void setColor(DviColor color) throws DviException {
        this.color = color;
    }

    public DviColor getColor() throws DviException {
        return this.color;
    }

    public void save() throws DviException {
        this.stack.push(new StackItem(this.color, this.point));
    }

    public void restore() throws DviException {
        if (this.stack.empty()) {
            throw new IllegalStateException("stack underflow");
        }
        StackItem it = this.stack.pop();
        this.color = it.color;
        this.point = it.point;
    }

    private static class StackItem {
        private final DviColor color;
        private final DviPoint point;

        public StackItem(DviColor color, DviPoint point) {
            this.color = color;
            this.point = point;
        }
    }
}

