/*
 * Decompiled with CFR 0.152.
 */
package dvi.font;

import dvi.DviException;
import dvi.DviFontSpec;
import dvi.DviResolution;
import dvi.DviUnit;
import dvi.api.DviContextSupport;
import dvi.api.DviFont;
import dvi.font.AWTDynamicPkFont;
import dvi.font.AbstractDviFontResolver;
import dvi.font.LogicalFont;
import java.awt.Font;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AWTDynamicPkFontResolver
extends AbstractDviFontResolver {
    private static final Logger LOGGER = Logger.getLogger(AWTDynamicPkFontResolver.class.getName());

    public AWTDynamicPkFontResolver(DviContextSupport dcs, LogicalFont logicalFont) {
        super(dcs, logicalFont);
    }

    @Override
    public Collection<DviFont> call() throws Exception {
        Font rawFont = this.mapToRawAWTFont(this.getLogicalFont());
        ArrayList<DviFont> list = new ArrayList<DviFont>();
        if (rawFont != null) {
            AWTDynamicPkFont font = new AWTDynamicPkFont(this.getDviContext(), rawFont);
            list.add(font);
        }
        return list;
    }

    protected Font mapToRawAWTFont(LogicalFont logicalFont) {
        DviFontSpec fs = logicalFont.fontSpec();
        DviResolution res = logicalFont.resolution();
        DviUnit dviUnit = logicalFont.dviUnit();
        String face = this.mapToRawAWTFontFace(logicalFont);
        if (face != null) {
            LOGGER.fine("Using AWT font face " + face + " to render " + logicalFont);
            int fontSize = (int)dviUnit.mapToPixelDouble(fs.spaceSize(), res.dpi());
            if ("dvicore-awt-dynamic-pk-font-serif".equals(face)) {
                LOGGER.fine("Using serif for" + logicalFont);
                return new Font("serif", 0, fontSize);
            }
            if ("dvicore-awt-dynamic-pk-font-sans-serif".equals(face)) {
                LOGGER.fine("Using sans-serif for" + logicalFont);
                return new Font("sans-serif", 0, fontSize);
            }
            LOGGER.fine("No AWT font face to render " + logicalFont);
            return new Font(face, 0, fontSize);
        }
        LOGGER.fine("No AWT font face to render " + logicalFont);
        return null;
    }

    protected String mapToRawAWTFontFace(LogicalFont logicalFont) {
        return logicalFont.fontSpec().name();
    }

    @Override
    public String getCacheKey() {
        LogicalFont spec = this.getLogicalFont();
        return spec.fontSpec().fontName() + "-" + spec.fontSpec().checkSum() + "-" + spec.fontSpec().spaceSize() + "-" + spec.fontSpec().designSize() + "-" + spec.resolution().dpi() + "-" + spec.dviUnit();
    }

    @Override
    protected DviFont createInstanceFromStream(InputStream openStream) throws DviException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected String mapToDviResourceName(LogicalFont logicalFont) {
        throw new UnsupportedOperationException();
    }
}

