/*
 * Decompiled with CFR 0.152.
 */
package dvi.font;

import dvi.DviException;
import dvi.api.DviContextSupport;
import dvi.font.AbstractDynamicPkFont;
import dvi.font.LogicalFont;
import dvi.font.PkGlyph;
import dvi.font.RunLengthEncodedGlyph;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.WritableRaster;

public class AWTDynamicPkFont
extends AbstractDynamicPkFont {
    private static final long serialVersionUID = 6218737476095318238L;
    private final Font font;

    public AWTDynamicPkFont(DviContextSupport dcs, Font font) throws DviException {
        super(dcs);
        if (font == null) {
            throw new NullPointerException("font is null");
        }
        this.font = font;
    }

    public boolean hasChar(int code) {
        return true;
    }

    protected PkGlyph generatePkGlyph(LogicalFont lf, int code) throws DviException {
        String unicode = this.getDviContext().getCharacterCodeMapper(lf).mapCharacterCodeToUnicode(lf, code);
        BufferedImage img = new BufferedImage(1, 1, 10);
        Graphics2D g = img.createGraphics();
        FontMetrics fm = g.getFontMetrics(this.font);
        int descent = fm.getMaxDescent();
        int ascent = fm.getMaxAscent();
        int leading = fm.getLeading();
        int width = fm.charWidth(unicode.charAt(0));
        int height = descent + ascent + leading;
        int padding = descent;
        int bw = width + padding * 2;
        int bh = height + padding * 2;
        height = fm.getHeight();
        g.dispose();
        g = null;
        img = new BufferedImage(bw, bh, 10);
        g = img.createGraphics();
        g.setFont(this.font);
        g.drawString(unicode, padding, ascent + padding);
        g.dispose();
        WritableRaster raster = img.getRaster();
        DataBufferByte data = (DataBufferByte)raster.getDataBuffer();
        RunLengthEncodedGlyph rlg = RunLengthEncodedGlyph.readByteGray(data.getData(), bw, bh, padding, ascent + padding);
        return rlg.toPkGlyph();
    }
}

