/*
 * Decompiled with CFR 0.152.
 */
package dvi.doc;

import dvi.DviException;
import dvi.DviFontSpec;
import dvi.DviFontTable;
import dvi.DviObject;
import dvi.DviUnit;
import dvi.api.DviContextSupport;
import dvi.api.DviData;
import dvi.api.DviDocument;
import dvi.api.DviExecutorContext;
import dvi.api.DviInput;
import dvi.api.DviPage;
import dvi.cmd.DviBop;
import dvi.cmd.DviPostPost;
import dvi.cmd.DviPostamble;
import dvi.cmd.DviPreamble;
import dvi.doc.DefaultDviPage;
import dvi.doc.URLDviDocument;
import dvi.io.DviInputStreamReader;
import dvi.render.EmptyHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public class StreamDviDocument
extends DviObject
implements DviDocument {
    public static final long MAX_BUFFER_LENGTH = 10000000L;
    private DviPreamble preamble = null;
    private DviPostamble postamble = null;
    private DviPostPost postPost = null;
    private byte[] buf = null;
    final DviFontTable fontTable = new DviFontTable();
    private ArrayList<DviPage> pages = new ArrayList();

    public StreamDviDocument(DviContextSupport dcs, InputStream in) throws DviException {
        super(dcs);
        try {
            this.parseInputStream(in);
        }
        catch (IOException ex) {
            throw new DviException(ex);
        }
    }

    private void parseInputStream(InputStream is) throws IOException, DviException {
        MyInputStream mis = new MyInputStream(is);
        final DviInputStreamReader in = new DviInputStreamReader(mis);
        this.getDviContext().execute(new DviData(){

            public DviInput getInput() {
                return in;
            }

            public DviFontTable getFontTable() {
                throw new UnsupportedOperationException();
            }

            public DviUnit getDviUnit() {
                throw new UnsupportedOperationException();
            }

            public long getDataSize() throws DviException {
                throw new UnsupportedOperationException();
            }

            public DviInput getInput(long start, long end) throws DviException {
                throw new UnsupportedOperationException();
            }
        }, new EmptyHandler(){
            private int pageNum = 0;
            private DviExecutorContext ctx;
            private long bop;

            public void begin(DviExecutorContext ctx) {
                this.ctx = ctx;
            }

            public void end() {
                this.ctx = null;
            }

            public void doPre(DviPreamble pre) {
                StreamDviDocument.this.preamble = pre;
            }

            public void doPost(DviPostamble post) {
                StreamDviDocument.this.postamble = post;
            }

            public void doPostPost(DviPostPost pp) {
                StreamDviDocument.this.postPost = pp;
                this.ctx.setTerminate(true);
            }

            public void doBop(DviBop bop) {
                this.bop = this.ctx.getCommandRange().begin();
            }

            public void doEop() {
                long eop = this.ctx.getCommandRange().begin();
                DviObject doc = StreamDviDocument.this;
                if (doc.getDviContext() instanceof URLDviDocument) {
                    doc = (URLDviDocument)((Object)doc.getDviContext());
                }
                DviPage page = StreamDviDocument.this.createPage(this.pageNum, this.bop, eop);
                StreamDviDocument.this.pages.add(page);
                ++this.pageNum;
            }

            public void doDefineFont(int fn, DviFontSpec fs) {
                StreamDviDocument.this.fontTable.put(fn, fs);
            }
        });
        if (this.preamble == null) {
            throw new DviException("no preamble found in the stream.");
        }
        if (this.postamble == null) {
            throw new DviException("no postamble found in the stream.");
        }
        if (this.postPost == null) {
            throw new DviException("no postPost found in the stream.");
        }
        this.buf = mis.baos.toByteArray();
    }

    protected DviPage createPage(int pageNum, long bop, long eop) {
        return new DefaultDviPage(this, pageNum, bop, eop);
    }

    public int getTotalPages() throws DviException {
        return this.postamble.totalPages();
    }

    public DviUnit getDviUnit() {
        return this.postamble.dviUnit();
    }

    public DviPreamble getPreamble() {
        return this.preamble;
    }

    public DviPostamble getPostamble() {
        return this.postamble;
    }

    public DviPostPost getPostPost() {
        return this.postPost;
    }

    public DviFontTable getFontTable() {
        return this.fontTable;
    }

    public DviInput getInput() throws DviException {
        ByteArrayInputStream bais = new ByteArrayInputStream(this.buf);
        return new DviInputStreamReader(bais);
    }

    public long getDataSize() {
        return this.buf.length;
    }

    public DviInput getInput(long start, long end) throws DviException {
        DviInputStreamReader in = new DviInputStreamReader(new ByteArrayInputStream(this.buf, (int)start, (int)(end - start) + 1));
        in.setOffset(start);
        return in;
    }

    public DviPage getPage(int p) throws DviException {
        if (p < 0 || this.getTotalPages() <= p) {
            throw new IllegalArgumentException("page number out of bounds.");
        }
        return this.pages.get(p);
    }

    public DviPage[] getPages() {
        return this.pages.toArray(new DviPage[this.pages.size()]);
    }

    private static class MyInputStream
    extends FilterInputStream {
        private final ByteArrayOutputStream baos = new ByteArrayOutputStream();

        public MyInputStream(InputStream is) {
            super(is);
        }

        public int read() throws IOException {
            int c = super.read();
            this.baos.write(c);
            return c;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int r = super.read(b, off, len);
            if (r > 0) {
                this.baos.write(b, off, r);
            }
            return r;
        }

        public void reset() throws IOException {
            throw new UnsupportedOperationException();
        }

        public long skip(long n) throws IOException {
            throw new UnsupportedOperationException();
        }

        public boolean markSupported() {
            return false;
        }
    }
}

